@ECHO OFF
rem Script to help users download MS2-extra firmware

set FILE=.
set CHOICE=
set DOWNLOAD=
set VERBOSE=1
set DELAY=0

cls

rem First check if the zipfile was extracted correctly
rem if not exist %FILE% goto FAILURE
if exist CHOICE.COM goto C_OK
if not exist CHOICE.COM goto FAILURE
set CHOICE=CHOICE.COM
echo CHOICE.COM found in wrong place. This batch file may fail.
echo Ensure you 'use folder names' when extracting.
echo .
pause
goto D_TEST

:C_OK
set CHOICE=CHOICE.COM

:D_TEST
if exist ms2dl.exe goto D_OK
if not exist ms2dl.exe goto FAILURE
set DOWNLOAD=ms2dl.exe
echo ms2dl.exe found in wrong place. This batch file may fail.
echo Ensure you 'use folder names' when extracting.
echo .
pause
goto CHKFILE

:D_OK
set DOWNLOAD=ms2dl.exe

:CHKFILE
if not exist %FILE% goto ASK
echo Caution! %FILE% found as well, be sure you are downloading
echo the right file.

:ASK
cls
ECHO .
ECHO   Downloading new Firmware to Megasquirt board
ECHO .
ECHO PLEASE NOTE: This is for MS2 or Microsquirt ONLY !!
ECHO .
echo ..............! ! W A R N I N G ! ! .............
echo.
echo This will wipe out ALL settings on the Megasquirt.
echo.
echo. so if you havent saved the settings in MegaTune 
echo.     it may be best to Quit and do it now !
ECHO .
ECHO .

ECHO MS2 or Microsquirt choice.
ECHO    1 - MS2
ECHO    2 - Microsquirt
ECHO    Q - Quit

%CHOICE% /c:12Q  " Select Megasquirt type [ MS2 ]: Q to Quit "
if errorlevel 1 set FILE=ms2_extra.s19
if errorlevel 2 set FILE=ms2_extra_us.s19
if errorlevel 3 goto ALL_DONE
:GOT_CPU

cls
ECHO Communication ports:
ECHO    1 - COM1
ECHO    2 - COM2
ECHO    3 - COM3
ECHO    4 - COM4
ECHO    5 - COM5
ECHO    6 - COM6
ECHO    7 - COM7
ECHO    8 - COM8
ECHO    9 - COM9
ECHO    Q - Quit

%CHOICE% /c:123456789Q  " Select download port [ COM1 ]: Q to Quit "
if errorlevel 1 set PORT=-c1
if errorlevel 2 set PORT=-c2
if errorlevel 3 set PORT=-c3
if errorlevel 4 set PORT=-c4
if errorlevel 5 set PORT=-c5
if errorlevel 6 set PORT=-c6
if errorlevel 7 set PORT=-c7
if errorlevel 8 set PORT=-c8
if errorlevel 9 set PORT=-c9
if errorlevel 10 goto ALL_DONE
:GOT_PORT

cls
ECHO Debug options:
ECHO    1 - No debug - recommended for most users
ECHO    2 - Add send delay
ECHO    3 - Add send delay and debug on screen
ECHO    Q - Quit
ECHO .
ECHO . (Note that these are only applied to the main application, not to bootstrap)
ECHO .
ECHO . If unsure, press  1
ECHO .

%CHOICE% /c:123Q  " Select debug option : "
rem Without this comment here, the next lines do not work correctly???
if errorlevel 4 goto ALL_DONE
if errorlevel 3 goto DEB3
if errorlevel 2 goto DEB2
if errorlevel 1 goto GOT_DEBUG
;undefined other number
goto GOT_DEBUG

:DEB2
set DELAY=5
goto REP_DEBUG

:DEB3
set DELAY=5
set VERBOSE=5

:REP_DEBUG
echo DELAY=%DELAY% VERBOSE=%VERBOSE%
pause

:GOT_DEBUG

cls
echo If you are upgrading from standard Megasquirt2 code you will need to
echo use the boot jumper soon. If you are upgrading from a recent MS2/Extra 
echo then this program will do it for you.
echo .
echo If you are unsure then press  Y     to quit - press Q
echo .
echo .
echo .
echo . Please read the README file!!!
echo .
%CHOICE% /c:YNQ  "Are you upgrading from standard Megasquirt2 code "
if errorlevel==3 goto ALL_DONE
if errorlevel==2 goto BOOTLOAD
if errorlevel==1 goto BOOTJUMP

:BOOTJUMP
cls
echo 1. Turn off Megasquirt
echo .
echo .
pause
echo 2.                       ! ! W A R N I N G ! !
echo .
echo    !!!Ensure ALL Direct Driven Coils Are UNPLUGGED from MS ECU!!!
echo .
echo .     If in doubt unplug all ignition coils from system! 
echo .        Damage to the MS ECU will result if you leave 
echo .          coils driven from the MS plugged in
echo .
pause
echo 3. Install Boot jumper. (marked B/LD on the MS2 plug-in card itself.)
echo .
echo .
pause
echo 4. Turn on Megasquirt
echo .
echo .
pause
echo .
echo %DOWNLOAD% %PORT% bootstrap.s19 
%DOWNLOAD% -r 115200 %PORT% bootstrap.s19
echo Bootstrap loaded...
echo .
echo .
echo 5. Turn off Megasquirt
pause
echo .
echo .
echo 6. Remove Boot jumper
pause
echo .
echo .
echo NOTE! If you experience problems in the next phase then you might have a
echo problem with your computer's serial system. One possible workaround for
echo the normal step 7 is as follows.
echo 7A Unplug the serial cable
echo 7B Turn on the Megasquirt
echo 7C Plug the serial cable in again
echo .
echo .
echo 7. Turn on Megasquirt
pause
echo .
echo .
echo %DOWNLOAD% %PORT% %FILE%
%DOWNLOAD% -r 115200 %PORT% -j %FILE%
goto ALL_DONE

rem -------------------------------------------------------
:FAILURE
echo The zipfile has not been extracted correctly - please ensure you
echo 'use folder names' or create sub directories when extracting.
echo This batch file cannot run without:
echo CHOICE.COM
echo ms2dl.exe
echo %FILE%
echo .
echo Aborting
goto ALL_DONE

rem -------------------------------------------------------
:BOOTLOAD
cls
echo 1. Ensure the boot jumper (marked B/LD on MS2 daughtercard) is NOT installed.
echo .
echo .
pause
echo 2. Turn  Megasquirt  ON
echo .
echo .
pause
echo 3.                       ! ! W A R N I N G ! !
echo .
echo    !!!Ensure ALL Direct Driven Coils Are UNPLUGGED from MS ECU!!!
echo .
echo .     If in doubt unplug all ignition coils from system! 
echo .        Damage to the MS ECU will result if you leave 
echo .          coils driven from the MS plugged in
echo .
pause
echo .
echo 
echo .
echo %DOWNLOAD% -d %DELAY% -v %VERBOSE% -r %DOWNLOAD% -j %PORT% %FILE%
%DOWNLOAD% -d %DELAY% -v %VERBOSE% -r 115200 -j %PORT% %FILE%

:ALL_DONE
pause
SET PORT=
SET FILE=
SET CHOICE=
SET DOWNLOAD=
ECHO.
ECHO.                ! ! W A R N I N G ! !
ECHO.
ECHO. Ensure you set the wheel decoder / wasted spark settings
ECHO.            using your tuning software
ECHO. before re-connecting any directly driven coils to the ECU
ECHO.           See the MS2-Extra manuals if in any doubt
ECHO.
ECHO.
echo You can now close this window
