/* $Id: ms2_extra_misc.c,v 1.44.6.63 2009/06/10 04:34:24 culverk Exp $ */
#include "ms2_extra.h"

long boost_ctl_last_error[2];

void boost_ctl_init(void)
{
    boost_ctl_last_error[0] = boost_ctl_last_error[1] = 0;
    boost_ctl_timer = 0;
    boost_ctl_duty = 100;
}

void boost_ctl(void)
{
    int tmp1 = 0;

    if (flagbyte3 & flagbyte3_runboost) {
        DISABLE_INTERRUPTS;
        flagbyte3 &= ~flagbyte3_runboost;
        ENABLE_INTERRUPTS;
        if (flash5.boost_ctl_settings & BOOST_CTL_CLOSED_LOOP) {
            /* CLOSED LOOP BOOST */
            int targ_load, boost_deriv;
            int boost_ctl_error;
            long Kp, Ki, Kd, PV, SP;

            /* do not try to control boost below 100% load */
            if (outpc.fuelload < 1000) {
                DISABLE_INTERRUPTS;
                boost_ctl_duty = flash5.boost_ctl_closeduty;
                ENABLE_INTERRUPTS;
                outpc.boostduty = boost_ctl_duty;
		boost_ctl_last_error[0] = boost_ctl_last_error[1] = 0;
                return;
            }

            targ_load = intrp_2ditable(outpc.rpm, outpc.tps, 8, 8,
                    &pg5_ptr->boost_ctl_loadtarg_rpm_bins[0],
                    &pg5_ptr->boost_ctl_loadtarg_tps_bins[0],
                    &pg5_ptr->boost_ctl_load_targets[0][0]);

            PV = ((long)(outpc.map - 1000) * 10000) /
                 (flash4.OverBoostKpa - 1000);
            SP = ((long)(targ_load - 1000) * 10000) /
                 (flash4.OverBoostKpa - 1000);

            boost_ctl_error = SP - PV;

            boost_deriv = PV - (2*boost_ctl_last_error[0]) + boost_ctl_last_error[1];

            Kp = ((long)(PV - boost_ctl_last_error[0]) * flash5.boost_ctl_Kp);
            Ki = (((long)boost_ctl_error * flash5.boost_ctl_ms * flash5.boost_ctl_Ki) / 1000);
            Kd = ((long)boost_deriv * ((long)flash5.boost_ctl_Kd*10) / flash5.boost_ctl_ms);

	    boost_ctl_last_error[1] = boost_ctl_last_error[0];
	    boost_ctl_last_error[0] = PV;

            tmp1 =  boost_ctl_duty + (((long)(Kp - Ki + Kd) * 
                                     (flash5.boost_ctl_openduty - flash5.boost_ctl_closeduty)) /
                                      100000);

            if (tmp1 < flash5.boost_ctl_closeduty) {
                tmp1 = flash5.boost_ctl_closeduty;
            } else if (tmp1 > flash5.boost_ctl_openduty) {
                tmp1 = flash5.boost_ctl_openduty;
            }

            DISABLE_INTERRUPTS;
            boost_ctl_duty = tmp1;
            ENABLE_INTERRUPTS;

        } else {
            /* OPEN LOOP BOOST
             * lookup duty based on TPS,RPM
             */
            boost_ctl_duty = intrp_2dctable(outpc.rpm, outpc.tps, 8, 8,
                    &pg5_ptr->boost_ctl_pwmtarg_rpm_bins[0],
                    &pg5_ptr->boost_ctl_pwmtarg_tps_bins[0],
                    &pg5_ptr->boost_ctl_pwm_targets[0][0], 0);

        }
        outpc.boostduty = boost_ctl_duty;
    }
}

//get_adc should be placed in 0x3c page along with the clt, mat, ego, maf data tables
void get_adc(char chan1, char chan2)
{
    char chan;
    //long adcval;
    int adcvalv,tmp1,tmp2,tmp3;
    unsigned int tmpadc;

    for (chan = chan1; chan <= chan2; chan++)  {
        //    switch(chan)  {
        // when using switch, gcc puts lookup table around 0x5000 and then linker
        // gets all upset because we are in page 0x3c and jump table isn't. Replace
        // with ifs instead. No functional difference. This is known bug in gcc
        if (chan == 0) {
            //removed lag code and first_adc comparison as only called here from init
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %2\n"
                    "ldy    %3\n"
                    "emul\n"
                    "ldx    #1023\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %2\n"
                    : "=d"(outpc.map)
                    : "m"(flash4.mapmax),
                    "m"(flash4.map0),
                    "m"(ATD0DR0)
                    : "y", "x");

        } else if (chan == 1) {
            //        adcval = (long)flash4.mat0 +
            //          ((long)flash4.matmult * matfactor_table[ATD0DR1]) / 100; // deg F or C x 10
            __asm__ __volatile__ (
                    //                "ldd    %1\n"
                    "asld\n"
                    "tfr    d,x\n"
                    "ldy    %2,x\n"
                    "ldd    %3\n"
                    "emul\n"
                    "ldx    #100\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %4\n"
                    : "=d"(tmp1)
                    : "d"(ATD0DR1),
                    "m"(matfactor_table[0]),
                    "m"(flash4.matmult),
                    "m"(flash4.mat0)
                    : "x", "y" );

            if(first_adc)
                outpc.mat = tmp1;
            else {
                //          outpc.mat += (short)((flash4.adcLF * (adcval - outpc.mat)) / 100);
                __asm__ __volatile__ (
                        //                "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n"      // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr     y,d\n"
                        "addd    %3\n"
                        : "=d"(outpc.mat)
                        : "d"(tmp1),
                        "m"(flash4.adcLF),
                        "m"(outpc.mat)
                        : "x", "y" );
            }
        } else if (chan == 2) {
            //        adcval = (long)flash4.clt0 +
            //          ((long)flash4.cltmult * cltfactor_table[ATD0DR2]) / 100; // deg F or C x 10
            __asm__ __volatile__ (
                    //                "ldd    %1\n"
                    "asld\n"
                    "tfr    d,x\n"
                    "ldy    %2,x\n"
                    "ldd    %3\n"
                    "emul\n"
                    "ldx    #100\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %4\n"
                    : "=d"(tmp1)
                    : "d"(ATD0DR2),
                    "m"(cltfactor_table[0]),
                    "m"(flash4.cltmult),
                    "m"(flash4.clt0)
                    : "x", "y" );
            if(first_adc)
                outpc.clt = tmp1;
            else {
                //          outpc.clt += (short)((flash4.adcLF * (adcval - outpc.clt)) / 100);
                __asm__ __volatile__ (
                        "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n"      // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr     y,d\n"
                        "addd    %3\n"
                        : "=d"(outpc.clt)
                        : "m"(tmp1),
                        "m"(flash4.adcLF),
                        "m"(outpc.clt)
                        : "x", "y" );
            }
        } else if (chan == 3) {
            outpc.tpsadc = ATD0DR3;
            //          adcval = (ATD0DR3 - (long)flash4.tps0) * 1000 /
            //          (flash4.tpsmax - flash4.tps0);                           // % x 10
            //          outpc.tps = (short)adcval;
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %2\n"
                    "tfr    d,x\n"

                    "ldd    %3\n"
                    "subd   %2\n"
                    "ldy    #1000\n"
                    "emul\n"
                    "ediv\n"
                    : "=y"(tmp1)
                    : "m"(flash4.tpsmax),
                    "m"(flash4.tps0),
                    "m"(ATD0DR3)
                    : "d", "x");

        } else if (chan == 4) {
            //        adcval = (long)flash4.batt0 +
            //          ((long)(flash4.battmax - flash4.batt0) * ATD0DR4) / 1023; // V x 10
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %2\n"
                    "ldy    %3\n"
                    "emul\n"
                    "ldx    #1023\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %2\n"
                    : "=d"(tmp1)
                    : "m"(flash4.battmax),
                    "m"(flash4.batt0),
                    "m"(ATD0DR4)
                    : "y", "x");
            if(first_adc)
                outpc.batt = tmp1;
            else {
                //        outpc.batt += (short)((flash4.adcLF * (adcval - outpc.batt)) / 100);
                __asm__ __volatile__ (
                        "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n"      // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr     y,d\n"
                        "addd    %3\n"
                        : "=d"(outpc.batt)
                        : "m"(tmp1),
                        "m"(flash4.adcLF),
                        "m"(outpc.batt)
                        : "x", "y" );
            }
        } else if (chan == 5) {
            // check if sensor bad (near limits)
            if((ATD0DR5 < 3) || (ATD0DR5 > 1020))
                bad_ego_flag |= 0x01;
            else
                bad_ego_flag &= ~0x01;
            __asm__ __volatile__ (
                    //                "ldx    %1\n"
                    "ldab   %2,x\n"
                    "clra\n"
                    "ldy    %3\n"
                    "emul\n"
                    "ldx    #100\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %4\n"
                    : "=d"(tmp3)
                    : "x"(ATD0DR5),
                    "m"(egofactor_table[0]),
                    "m"(flash4.egomult),
                    "m"(flash4.ego0)
                    : "y" );

            tmp1 = (int)ATD0DR5;
            __asm__ __volatile__ ("ldd #500\n"
                    "emuls\n"
                    "ldx #1023\n"
                    "edivs\n":
                    "=y" (adcvalv):
                    "y" (tmp1):
                    "d","x");
            if(first_adc)        {
                outpc.ego1 = tmp3;
                outpc.egoV1 = adcvalv;                          // Vx100
            }
            else  {
                //            outpc.ego1 += (short)((flash4.egoLF * (adcval - outpc.ego1)) / 100);
                __asm__ __volatile__ (
                        "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n"      // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr     y,d\n"
                        "addd    %3\n"
                        : "=d"(outpc.ego1)
                        : "m"(tmp3),
                        "m"(flash4.egoLF),
                        "m"(outpc.ego1)
                        : "x", "y" );

                tmp1 = (int)flash4.egoLF;
                tmp2 = adcvalv - outpc.egoV1;
                __asm__ __volatile__ ("emuls\n"
                        "ldx #100\n"
                        "edivs\n":
                        "=y" (adcvalv):
                        "d" (tmp1),
                        "y" (tmp2):
                        "x");
                outpc.egoV1 += adcvalv;      // Vx100
            }
        } else if (chan == 6) {
            outpc.adc6 = ATD0DR6;
        } else if (chan == 7) {
            outpc.adc7 = ATD0DR7;

        }                        // end of switch
    }                            // end of for loop

    // if GPIO slave copy these raw ADCs to a convenient place so master can grab them
    if (flash4.mycan_id) {
        outpc.gpioadc[0] = ATD0DR0;
        outpc.gpioadc[1] = ATD0DR1;
        outpc.gpioadc[2] = ATD0DR2;
        outpc.gpioadc[3] = ATD0DR3;
        outpc.gpioadc[4] = ATD0DR4;
        outpc.gpioadc[5] = ATD0DR5;
        outpc.gpioadc[6] = ATD0DR6;
        outpc.gpioadc[7] = ATD0DR7;
    }

    // now calculate other stuff that uses optional ADC inputs
    if (flash4.BaroOption == 2)  {

        if (flash4.rtbaroport == 6) {
            tmpadc = outpc.adc6;
        } else if (flash4.rtbaroport == 7) {
            tmpadc = outpc.adc7;
        } else if (flash4.rtbaroport > 7) {
            //read for GPIO port copy
            tmpadc = outpc.gpioadc[flash4.rtbaroport & 0x7];
        } else {
            tmpadc = 0;
        }

        //          adcval = (long)flash4.baro0 +
        //            ((long)(flash4.baromax - flash4.baro0) * tmpadc) / 1023; // kPa x 10
        __asm__ __volatile__ (
                "ldd    %1\n"
                "subd   %2\n"
                "ldy    %3\n"
                "emul\n"
                "ldx    #1023\n"
                "ediv\n"
                "tfr    y,d\n"
                "addd   %2\n"
                : "=d"(tmp1)
                : "m"(flash4.baromax),
                "m"(flash4.baro0),
                "m"(tmpadc)
                : "y", "x");

        if(first_adc)
            outpc.baro = tmp1;
        else {
            //            outpc.baro += (short)((flash4.adcLF * (adcval - outpc.baro)) / 100);
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %3\n"
                    "tfr    d,y\n"
                    "clra\n"
                    "ldab    %2\n"      // it is a uchar
                    "emuls\n"
                    "ldx     #100\n"
                    "edivs\n"
                    "tfr     y,d\n"
                    "addd    %3\n"
                    : "=d"(outpc.baro)
                    : "m"(tmp1),
                    "m"(flash4.adcLF),
                    "m"(outpc.baro)
                    : "x", "y" );
        }
    }

    if((flash4.EgoOption == 2) || (flash4.EgoOption == 4))  {

        if (flash4.ego2port == 6) {
            tmpadc = outpc.adc6;
        } else if (flash4.ego2port == 7) {
            tmpadc = outpc.adc7;
        } else if (flash4.ego2port > 7) {
            //read for GPIO port copy
            tmpadc = outpc.gpioadc[flash4.ego2port & 0x7];
        } else {
            tmpadc = 0;
        }
        //works up to here... but egoV2 isn't getting set?
        // check if sensor bad (near limits)
        if((tmpadc < 3) || (tmpadc > 1020)) {
            bad_ego_flag |= 0x02;
        } else {
            bad_ego_flag &= ~0x02;
        }
        //          adcval = (long)flash4.ego0 +
        //            ((long)flash4.egomult * egofactor_table[tmpadc]) / 100; // afr x 10
        __asm__ __volatile__ (
                //                "ldx    %1\n"
                "ldab   %2,x\n"
                "clra\n"
                "ldy    %3\n"
                "emul\n"
                "ldx    #100\n"
                "ediv\n"
                "tfr    y,d\n"
                "addd   %4\n"
                : "=d"(tmp3)
                : "x"(tmpadc),
                "m"(egofactor_table[0]),
                "m"(flash4.egomult),
                "m"(flash4.ego0)
                : "y" );

        // next line doesn't compile right because gcc doesn't notice that X got clobbered above
        //          tmp1 = (int)tmpadc;
        __asm__ __volatile__ ("ldd #500\n"
                "emuls\n"
                "ldx #1023\n"
                "edivs\n":
                "=y" (adcvalv):
                "y" (tmpadc):    // was tmp1
                "d","x");
        if(first_adc)    { // skip the LF for
            outpc.ego2 = tmp3;
            outpc.egoV2 = adcvalv;                              // Vx100
        } else  {
            //            outpc.ego2 += (short)((flash4.egoLF * (adcval - outpc.ego2)) / 100);
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %3\n"
                    "tfr    d,y\n"
                    "clra\n"
                    "ldab    %2\n"      // it is a uchar
                    "emuls\n"
                    "ldx     #100\n"
                    "edivs\n"
                    "tfr     y,d\n"
                    "addd    %3\n"
                    : "=d"(outpc.ego2)
                    : "m"(tmp3),
                    "m"(flash4.egoLF),
                    "m"(outpc.ego2)
                    : "x", "y" );

            tmp1 = (int)flash4.egoLF;
            tmp2 = adcvalv - outpc.egoV2;
            __asm__ __volatile__ ("emuls\n"
                    "ldx #100\n"
                    "edivs\n":
                    "=y" (adcvalv):
                    "d" (tmp1),
                    "y" (tmp2):
                    "x");
            outpc.egoV2 += adcvalv;      // Vx100
        }
    } else  {
        outpc.ego2 = outpc.ego1;
        outpc.egoV2 = outpc.egoV1;
    }


    //was knock. Now use the ADC pin as a digi input if requested

    return;
}

/* x value to look up, n number of values, x_table MAP/RPM/whatever, sgn wtf, z_table percentage */
int intrp_1dctable(int x, unsigned char n, int * x_table, char sgn,
        unsigned char * z_table)
{
    int ix;
    long interp, interp3;
    // bound input arguments
    if(x > x_table[n-1])  {
        if(!sgn)
            return((int)z_table[n -1]);
        else
            return((int)((char)z_table[n -1]));
    }
    if(x < x_table[0])  {
        if(!sgn)
            return((int)z_table[0]);
        else
            return((int)((char)z_table[0]));
    }
    for(ix = n - 2; ix > -1; ix--)  {
        if(x > x_table[ix])  {
            break;
        }
    }
    if(ix < 0)ix = 0;

    interp =    x_table[ix + 1] - x_table[ix];
    if(interp != 0)  {
        interp3 = (x - x_table[ix]);
        interp3 = (100 * interp3);
        interp = interp3 / interp;
    }
    if(!sgn)
        return((int)(z_table[ix] +
                    interp * (z_table[ix+1] - z_table[ix])/ 100));
    else
        return((int)((char)z_table[ix] +
                    interp * ((char)z_table[ix+1] - (char)z_table[ix])/ 100));
}

int intrp_1ditable(int x, unsigned char n, int * x_table, unsigned int * z_table)
{
    int ix;
    long interp, interp3;

    unsigned int result;

    // bound input arguments
    if(x > x_table[n-1])  {
        return(z_table[n -1]);
    }
    if(x < x_table[0])  {
        return(z_table[0]);
    }
    for(ix = n - 2; ix > -1; ix--)  {
        if(x > x_table[ix])  {
            break;
        }
    }
    if(ix < 0)ix = 0;

    //    outpc.status3 = z_table[0];

    interp = x_table[ix + 1] - x_table[ix];
    if(interp != 0)  {
        interp3 = (x - x_table[ix]);
        interp3 = (100 * interp3);
        interp = interp3 / interp;
    }

    if (z_table[ix+1] >= z_table[ix]) {
        result = (z_table[ix] + interp * (z_table[ix+1] - z_table[ix])/100);
    } else {
        result = (z_table[ix] - interp * (z_table[ix] - z_table[ix+1])/100);
    }

    return(result);
}

int intrp_2dctable(unsigned int x, int y, unsigned char nx, unsigned char ny,
                   unsigned int * x_table, int * y_table, unsigned char * z_table,
                   unsigned char hires)
{
    int ix,jx;
    long interp1, interp2, interp3;
    int result;
    // bound input arguments
    if(x > x_table[nx-1])x = x_table[nx-1];
    else if(x < x_table[0])x = x_table[0];
    if(y > y_table[ny-1])y = y_table[ny-1];
    else if(y < y_table[0])y = y_table[0];
    // Find bounding indices in table
    for(ix = ny - 2; ix > -1; ix--)  {  // Start w highest index
        //  because will generally have least time for calculations at hi y
        if(y > y_table[ix])  {
            break;
        }
    }
    if(ix < 0)ix = 0;
    for(jx = nx - 2; jx > -1; jx--)  {  // Start w highest index
        // because will generally have least time for calculations at hi x
        if(x > x_table[jx])  {
            break;
        }
    }
    if(jx < 0)jx = 0;
    // do 2D interpolate
    interp1 = y_table[ix + 1] - y_table[ix];
    if(interp1 != 0)  {
        interp3 = (y - y_table[ix]);
        interp3 = (100 * interp3);
        interp1 = interp3 / interp1;
    }
    interp2 =   x_table[jx + 1] - x_table[jx];
    if(interp2 != 0)  {
        interp3 = (x - x_table[jx]);
        interp3 = (100 * interp3);
        interp2 = interp3 / interp2;
    }

    if (hires) {
        result = (int)(((100 - interp1) * (100 - interp2) * z_table[ix*nx+jx]
                    + interp1 * (100 - interp2) * z_table[(ix+1)*nx+jx]
                    + interp2 * (100 - interp1) * z_table[ix*nx+jx+1]
                    + interp1 * interp2 * z_table[(ix+1)*nx+jx+1]) / 1000);
    } else {
        result = (int)(((100 - interp1) * (100 - interp2) * z_table[ix*nx+jx]
                    + interp1 * (100 - interp2) * z_table[(ix+1)*nx+jx]
                    + interp2 * (100 - interp1) * z_table[ix*nx+jx+1]
                    + interp1 * interp2 * z_table[(ix+1)*nx+jx+1]) / 10000);
    }

    return(result);
}

int barocor_eq(int baro)
{
    // returns baro correction in % (100 is no correction)
    // baro in kPa x 10
    return((int)(flash4.bcor0 + (((long)flash4.bcormult * baro) / 1000)));
}

int aircor_eq(int mat)
{
    signed int cor;
    signed char ccor;
    // returns air density correction from equation in % (100 is no correction)
    //   mat in deg F x10 or deg Cx10
    /* Following equations used:

       For Farenheit, air density (pounds/cubic feet) = .0391568 x map (kPa x 10)
       -------------------------
       ((mat(degFx10)/10) + 459.7)
       If we take 70 degF as standard temperature (no density correction) and ignore
       map, which is already accounted for elsewhere,then
       air density correction(%) = (70 + 459.7) x 100
       ------------------
       ((mat/10) + 459.7)
       For Celsius, with a 20 deg C reference and mat in deg C x 10
       air density correction(%) = (20 + 273.2) x 100
       ------------------
       ((mat/10) + 273.2)

       This function could actually be unsigned char. Doesn't need to be signed int.
     */
    if(flash4.Temp_Units == 0)  {    // deg F
        cor = 529700 / (mat + 4597);
    }
    else  {                          // deg C
        cor = 293200 / (mat + 2732);
    }
    if (flash5.airden_scaling) { // only if non-zero
        ccor = (unsigned char)cor - 100;
        cor = ((signed int)(ccor * flash5.airden_scaling)) / 100;
        cor = cor + 100;
    }
    return (int)cor;
}

int intrp_2ditable(unsigned int x, int y, unsigned char nx, unsigned char ny,
                   unsigned int * x_table, int * y_table, int * z_table)
{
    int ix,jx;
    long interp1, interp2, interp3;
    // bound input arguments
    if(x > x_table[nx-1])x = x_table[nx-1];
    else if(x < x_table[0])x = x_table[0];
    if(y > y_table[ny-1])y = y_table[ny-1];
    else if(y < y_table[0])y = y_table[0];
    // Find bounding indices in table
    for(ix = ny - 2; ix > -1; ix--)  {  // Start w highest index
        //  because will generally have least time for calculations at hi y
        if(y > y_table[ix])  {
            break;
        }
    }
    if(ix < 0)ix = 0;
    for(jx = nx - 2; jx > -1; jx--)  {  // Start w highest index
        // because will generally have least time for calculations at hi x
        if(x > x_table[jx])  {
            break;
        }
    }
    if(jx < 0)jx = 0;
    // do 2D interpolate
    interp1 = y_table[ix + 1] - y_table[ix];
    if(interp1 != 0)  {
        interp3 = (y - y_table[ix]);
        interp3 = (100 * interp3);
        interp1 = interp3 / interp1;
    }
    interp2 =   x_table[jx + 1] - x_table[jx];
    if(interp2 != 0)  {
        interp3 = (x - x_table[jx]);
        interp3 = (100 * interp3);
        interp2 = interp3 / interp2;
    }
    return((int)(((100 - interp1) * (100 - interp2) * z_table[ix*nx+jx]
                    + interp1 * (100 - interp2) * z_table[(ix+1)*nx+jx]
                    + interp2 * (100 - interp1) * z_table[ix*nx+jx+1]
                    + interp1 * interp2 * z_table[(ix+1)*nx+jx+1]) / 10000));
}

int CW_table(int clt, int *table, int *temp_table)
{
    int ix;
    long interp, interp3;
    // returns values for various cold warmup table interpolations
    // bound input arguments
    if(clt > temp_table[NO_TEMPS-1])  {
        return(table[NO_TEMPS -1]);
    }
    if(clt < temp_table[0])  {
        return(table[0]);
    }
    for(ix = NO_TEMPS - 2; ix > -1; ix--)  {
        if(clt > temp_table[ix])  {
            break;
        }
    }
    if(ix < 0)ix = 0;

    interp = temp_table[ix + 1] - temp_table[ix];
    if(interp != 0)  {
        interp3 = (clt - temp_table[ix]);
        interp3 = (100 * interp3);
        interp = interp3 / interp;
    }
    return((int)(table[ix] + interp * (table[ix+1] - table[ix])/ 100));
}

void set_spr_port(char port, char val)
{
    unsigned char pval;

    if (val) {
        outpc.port_status |= (0x01 << port);
    } else {
        outpc.port_status &= ~(0x01 << port);    // JL fix
    }

    if(port < 4)  {
        pval = (0x01 << (port + 2));
        if(val)
            PTM |= pval;
        else
            PTM &= ~pval;
    } else if(port < 6)  {
        /* Workaround for MT bug, reverse IAC1 and IAC2 */
        if (port == 4) {
            port = 5;
        } else if (port == 5) {
            port = 4;
        }
        pval = (0x01 << (port + 2));
        if(val)  {
            DISABLE_INTERRUPTS
                PTT |= pval;
            ENABLE_INTERRUPTS
        } else  {
            DISABLE_INTERRUPTS
                PTT &= ~pval;
            ENABLE_INTERRUPTS
        }
    } else  {
        if(val)
            PORTA |= 0x01;
        else
            PORTA &= ~0x01;
    }
}

//*****************************************************************************
//* Function Name: Flash_Init
//* Description : Initialize Flash NVM for HCS12 by programming
//* FCLKDIV based on passed oscillator frequency, then
//* uprotect the array, and finally ensure PVIOL and
//* ACCERR are cleared by writing to them.
//*
//*****************************************************************************
void Flash_Init()
{
    /* Next, initialize FCLKDIV register to ensure we can program/erase */
    FCLKDIV = 39;
    //  FPROT = 0xFF; /* Disable all protection (only in special modes)*/
    // commented as it will likely spew out error normally
    FSTAT = PVIOL|ACCERR;/* Clear any errors */
    return;
}

void realtime(void)
{
    unsigned char t1;
    if (rtsci == 0) {
        goto skip_rt;
    }
    if (rtsci == 1) {
        // copy outpc to txbuf one by one to allow interrupts
        txbuf.seconds = outpc.seconds;
        txbuf.pw1 = outpc.pw1;
        txbuf.pw2 = outpc.pw2;
        txbuf.rpm = outpc.rpm;
        txbuf.adv_deg = outpc.adv_deg;
        txbuf.squirt = outpc.squirt;
        txbuf.engine = outpc.engine;
        txbuf.afrtgt1 = outpc.afrtgt1;
        txbuf.afrtgt2 = outpc.afrtgt2;
        txbuf.wbo2_en1 = outpc.wbo2_en1;
        txbuf.wbo2_en2 = outpc.wbo2_en2;
        txbuf.baro = outpc.baro;
        txbuf.map = outpc.map;
        txbuf.mat = outpc.mat;
        txbuf.clt = outpc.clt;
        txbuf.tps = outpc.tps;
        txbuf.batt = outpc.batt;
        txbuf.ego1 = outpc.ego1;
        txbuf.ego2 = outpc.ego2;
        txbuf.knock = outpc.knock;
        txbuf.egocor1 = outpc.egocor1;
        txbuf.egocor2 = outpc.egocor2;
        txbuf.aircor = outpc.aircor;
        txbuf.warmcor = outpc.warmcor;
        txbuf.tpsaccel = outpc.tpsaccel;
        txbuf.tpsfuelcut = outpc.tpsfuelcut;
        txbuf.barocor = outpc.barocor;
        txbuf.gammae = outpc.gammae;
        txbuf.vecurr1 = outpc.vecurr1;
        txbuf.vecurr2 = outpc.vecurr2;
        txbuf.iacstep = outpc.iacstep;
        txbuf.cold_adv_deg = outpc.cold_adv_deg;
        txbuf.tpsdot = outpc.tpsdot;
        txbuf.mapdot = outpc.mapdot;
        txbuf.coil_dur = outpc.coil_dur;
        txbuf.maf = outpc.maf;
        txbuf.fuelload = outpc.fuelload;
        txbuf.fuelcor = outpc.fuelcor;
        txbuf.port_status = outpc.port_status;
        txbuf.knk_rtd = outpc.knk_rtd;
        txbuf.EAEfcor1 = outpc.EAEfcor1;
        txbuf.EAEfcor2 = outpc.EAEfcor2;
        txbuf.egoV1 = outpc.egoV1;
        txbuf.egoV2 = outpc.egoV2;

        // the following only apply to MS2/Extra but should not hurt MV2
        txbuf.status1 = outpc.status1;
        if (outpc.status1 & status1_syncok) { // actually synced
            if ((outpc.status1 & status1_synclatch) == 0) { // latched not synced
                txbuf.status1 &= ~status1_syncok; // claim still not synced to user
                outpc.status1 |= status1_synclatch; // reset latch
            }
        }
        txbuf.status2 = outpc.status2;
        txbuf.status3 = outpc.status3;
        txbuf.status4 = outpc.status4;
        txbuf.looptime = outpc.looptime;
        txbuf.istatus5 = outpc.istatus5;
        txbuf.tpsadc = outpc.tpsadc;
        txbuf.fuelload2 = outpc.fuelload2;
        txbuf.ignload = outpc.ignload;
        txbuf.ignload2 = outpc.ignload2;
        //txbuf. spare[5]; - deleted
        txbuf.synccnt = outpc.synccnt;
        txbuf.timing_err = outpc.timing_err;
        DISABLE_INTERRUPTS;
        txbuf.dt3 = outpc.dt3; // these two are long, some ensure coherency with sei/cli
        ENABLE_INTERRUPTS;
        DISABLE_INTERRUPTS;
        txbuf.wallfuel1 = outpc.wallfuel1;
        txbuf.wallfuel2 = outpc.wallfuel2;
        ENABLE_INTERRUPTS;
        txbuf.gpioadc[0] = outpc.gpioadc[0];
        txbuf.gpioadc[1] = outpc.gpioadc[1];
        txbuf.gpioadc[2] = outpc.gpioadc[2];
        txbuf.gpioadc[3] = outpc.gpioadc[3];
        txbuf.gpioadc[4] = outpc.gpioadc[4];
        txbuf.gpioadc[5] = outpc.gpioadc[5];
        txbuf.gpioadc[6] = outpc.gpioadc[6];
        txbuf.gpioadc[7] = outpc.gpioadc[7];

        txbuf.gpiopwmin[0] = outpc.gpiopwmin[0];
        txbuf.gpiopwmin[1] = outpc.gpiopwmin[1];
        txbuf.gpiopwmin[2] = outpc.gpiopwmin[2];
        txbuf.gpiopwmin[3] = outpc.gpiopwmin[3];

        txbuf.gpioport[0] = outpc.gpioport[0];
        txbuf.gpioport[1] = outpc.gpioport[1];
        txbuf.gpioport[2] = outpc.gpioport[2];

        txbuf.adc6 = outpc.adc6;
        txbuf.adc7 = outpc.adc7;
        txbuf.boostduty = outpc.boostduty;
        txbuf.syncreason = outpc.syncreason;
        if (outpc.syncreason) {
            outpc.syncreason = 0; // send the sync loss reason code once then reset it
        }
        txbuf.user0 = outpc.user0;

        rtcksum = 0;
        rcv_timeout = 0xffffffff;
        SCI0CR2 &= ~0x80;   // xmit interrupt disable
        SCI0CR2 |= 0x08;   // xmit enable
    }

    if (SCI0SR1 & 0x80) { // check if output buffer is ready for more
        // send data block etc.
        __asm__ __volatile__ (
                "clra\n"
                "ldab %1\n"
                "tfr d,x\n"
                "dex\n"
                "ldab %2,x\n"
                "stab %0\n"
                : "=m" (t1)
                : "m" (rtsci), "m" (txbuf) );
        SCI0DRL = t1;
//        rtcksum = rtcksum ^ t1;
        rtsci++;
        if ( (((flagbyte2 & flagbyte2_MV2) == 0) && (rtsci > SIZEOFTXBUF))
                || ((flagbyte2 & flagbyte2_MV2) && (rtsci > 112 )) ) {  // HARDCODING
            rtsci = 0;
// Disable the checksum as nobody is using it and it causes inconsistencies with CAN pass-through data
//            while ((SCI0SR1 & 0x80) == 0) { ; } // wait until byte sent
//            SCI0DRL = rtcksum;
        }


    }
skip_rt: ;
    /* done realtime data portion */
    /* In here want to handle grabbing realtime data from GPIO at defined intervals
       and populating outpc */
}

void INJ1(void)
{
    /* While we're here, check to see if we should start injection yet */
    if (outpc.pw1 > 0) {
#ifndef MICROSQUIRT
        PWMPER2 = pg4_ptr->InjPWMPd;   // set PWM period (us)
        PWMDTY2 = PWMPER2;           // set PWM duty to 100 %
        pwm1_on = pg4_ptr->InjPWMTim; // .128 ms
        PWMCNT2 = 0x00;  // clear counter
        PWME |= 0x04;    // enable PWM2
#endif

        TCTL2 |= 0x04;   // set output hi in OL1
        CFORC |= 0x02;   // force high
        TC1 = TCNT + outpc.pw1;  // load OC compare reg
        TCTL2 = TCTL2 & 0xFB;    // set output lo in OL1
        TIE |= 0x02;             // Enable Inj1 OC interrupt
        TFLG1 = 0x02;	           // clear OC interrupt flag
        *pPTMpin[3] |= 0x08;   // turn on inj led
        outpc.squirt |= 0x01;  // inj1 squirting
    } else {
        TIE &= ~0x02;    // disable int
        CFORC &= ~0x02; // don't force high
    }
}

void INJ2(void)
{
    if (outpc.pw2 > 0) {
#ifndef MICROSQUIRT
        if (flash4.ICIgnOption & 0x20) { // if using own settings
            PWMPER4 = pg4_ptr->InjPWMPd2;  // set PWM period (us)
            pwm2_on = pg4_ptr->InjPWMTim2; // .128 ms
        } else {
            PWMPER4 = pg4_ptr->InjPWMPd;   // set PWM period (us)
            pwm2_on = pg4_ptr->InjPWMTim; // .128 ms
        }
        PWMDTY4 = PWMPER4;           // set PWM duty to 100 %
        PWMCNT4 = 0x00;  // clear counter
        PWME |= 0x10;    // enable PWM4
#endif
        TCTL2 |= 0x40;   // set output hi in OL3
        CFORC |= 0x08;   // force high
        TC3 = TCNT + outpc.pw2;  // load OC compare reg
        TCTL2 = TCTL2 & 0xBF;   // set output lo in OL3
        TIE |= 0x08;            // Enable Inj2 OC interrupt
        TFLG1 = 0x08;	          // clear OC interrupt flag
        *pPTMpin[3] |= 0x08;   // turn on inj led
        outpc.squirt |= 0x02;  // inj2 squirting
    } else {
        TIE &= ~0x08;    // disable int
        CFORC &= ~0x08;   // don't force high
    }
}


/**************************************************************************
 **
 ** Calculation of Battery Voltage Correction for Injector Opening Time
 **
 ** Injector open time is implemented as a linear function of
 **  battery voltage, from 7.2 volts to 19.2 volts,
 **  with 13.2 volts being the nominal operating voltage
 **
 ** INJOPEN = injector open time at 13.2 volts in ms x 10
 ** BATTFAC = injector open adjustment factor 6 volts from 13.2V in ms x 10
 **
 **
 ** + (INJOPEN + BATTFAC)
 ** +   *
 ** +                     (INJOPEN)
 ** +                         *
 ** +                                       (INJOPEN - BATTFAC)
 ** +                                               *
 ** +
 ** ++++++++++++++++++++++++++++++++++++++++++++++++++++++
 **    7.2V                 13.2V                19.2
 **
 **************************************************************************/
void calc_opentime()
{
    int tmp1;

    tmp1 = (((long)pg4_ptr->BatFac * (outpc.batt - 72)) / 60);

    if (tmp1 < (pg4_ptr->InjOpen + pg4_ptr->BatFac)) {
        //positive which is reasonable
        pw_open1 = (unsigned int)(pg4_ptr->InjOpen + pg4_ptr->BatFac - tmp1);
    } else {
        pw_open1 = pg4_ptr->InjOpen;
    }

    // if it was negative then don't set so use last value
    if (pw_open1 > 5000) {
        pw_open1 = 5000; // hardcoded 5ms max
    }

    // if channel 2 has different parameters, then apply them here
    if (pg4_ptr->ICIgnOption & 0x20) {
        tmp1 = (((long)pg4_ptr->BatFac2 * (outpc.batt - 72)) / 60);

        if (tmp1 < (pg4_ptr->InjOpen2 + pg4_ptr->BatFac2)) {
            //positive which is reasonable
            pw_open2 = (unsigned int)(pg4_ptr->InjOpen2 + pg4_ptr->BatFac2 - tmp1);
        } else {
            pw_open2 = pg4_ptr->InjOpen2;
        }

        // if it was negative then don't set so use last value
        if (pw_open2 > 5000) {
            pw_open2 = 5000; // hardcoded 5ms max
        }
    } else {
        pw_open2 = pw_open1;
    }

}

unsigned int twoptlookup(unsigned int x, unsigned int x0, unsigned int x1, unsigned int y0, unsigned int y1 )
{
    long interp, interp3;
    unsigned int result;

    // bound input arguments
    if(x >= x1)  {
        return(y1);
    }

    if(x <= x0)  {
        return(y0);
    }

    interp = (long)x1 - (long)x0;
    interp3 = ((long)x - (long)x0);
    interp3 = (100 * interp3);
    interp = interp3 / interp;

    interp = interp * ((long)y1 - (long)y0)/100;
    result = (unsigned int)( (long)y0 + interp );

    return(result);
}

//Without this next code segment in page3a, the config error code doesn't get included in the s19
//Seems like buggy behaviour in binutils
void bs_text3a (void) {
    return;
}
