/* $Id: ms2_extra_inj.c,v 1.10.6.11 2009/06/20 05:15:54 culverk Exp $ */
#include "ms2_extra.h"

static unsigned int staging_percent;
static unsigned char squirts_per_rev;

/* staging parameters from user are size of primaries and size of secondaries.
 * we will calculate a percentage (100% means same-size injectors) and store
 * in RAM for the staged pw calc
 */
void setup_staging(void)
{
    staging_percent = ((unsigned long)flash10.staged_pri_size * 100) /
        (flash10.staged_pri_size + flash10.staged_sec_size);
    flagbyte4 &= ~flagbyte4_staging_on;
    squirts_per_rev = (num_cyl / flash4.Divider) >> 1;
}

unsigned char calc_duty(unsigned long base_pw)
{
    unsigned long time_per_rev;
    unsigned long dtpred_time;
    unsigned int duty;
     
    /* add this since it's really part of the duty...
     * Divide by 100 because we were doing our calcs in
     * usec * 100 resolution before.
     */
    base_pw = (base_pw / 100) + pw_open1;

    base_pw *= squirts_per_rev;

    base_pw = (base_pw*3)>>1;

    /* how long is 1 rev right now */
    DISABLE_INTERRUPTS;
    dtpred_time = dtpred;
    ENABLE_INTERRUPTS;

    time_per_rev = (num_cyl >> 1) * dtpred_time;

    /* rolled over, but we don't want to stage b/c of that */
    if (time_per_rev < dtpred_time) {
	return 0;
    }

    duty = (unsigned int)((base_pw * 100) / time_per_rev);

    if (duty > 255) {
	duty = 255;
    }

    return (unsigned char)duty;
}

/* determine if staging should be on or not */
unsigned char staging_on(unsigned long base_pw)
{
    unsigned char param;
    static unsigned char staged_first_param_on = 0, staged_second_param_on = 0;
    int param_to_check;

    param = flash10.staged & 0x7;
    /* First parameter */

    if (param == 0x1 ) {
        param_to_check = outpc.rpm;
    } else if (param == 0x2) {
        param_to_check = outpc.map / 10;
    } else if (param == 0x3) {
        param_to_check = outpc.tps / 10;
    } else {
	/* calc duty and check against setting */
	param_to_check = calc_duty(base_pw);
    }

    if (param_to_check >= flash10.staged_param_1) {
        staged_first_param_on = 1;
    } else if (param_to_check < (flash10.staged_param_1 - flash10.staged_hyst_1)) {
        staged_first_param_on = 0;
    }

    param = flash10.staged & 0x38;

    /* only one param, so return the result */
    if (!param) {
        return (staged_first_param_on);
    }

    if (param == 0x8) {
        param_to_check = outpc.rpm;
    } else if (param == 0x10) {
        param_to_check = outpc.map / 10;
    } else if (param == 0x18) {
        param_to_check = outpc.tps / 10;
    } else {
	param_to_check = calc_duty(base_pw);
    }

    if (param_to_check >= flash10.staged_param_2) {
        staged_second_param_on = 1;
    } else if ( param_to_check < (flash10.staged_param_2 - flash10.staged_hyst_2)) {
        staged_second_param_on = 0;
    }

    if (flash10.staged & 0x80) {
        return (staged_first_param_on && staged_second_param_on);
    } else {
        return (staged_first_param_on || staged_second_param_on);
    }

    return 0;
}

/* now we calculate the staged pulse-width based on the staging percent, and
 * conditions for staging
 */
void calc_staged_pw(unsigned long base_pw)
{
    unsigned long calculated_pw1, calculated_pw2, calculated_base_pw, calculated_secondary_enriched;
    unsigned long per_ignevent_amt_pw1, per_ignevent_amt_pw2;
    unsigned char staged_num_events_pri;

    if(staging_on(base_pw)) {
        /* staging should be on, calculate staged pw */
        calculated_base_pw = (base_pw * (unsigned long)staging_percent) / 100;

        /* did staging just come on? if so, pw_staged2 will be 0... use that to reset
         * the transition count if necessary */

        if ((flash10.staged & 0x40) && (!(flagbyte4 & flagbyte4_transition_done))) {
            if (pw_staged2 == 0) {
                DISABLE_INTERRUPTS;
                staged_num_events = 1;
                ENABLE_INTERRUPTS;
            }

            calculated_secondary_enriched = (calculated_base_pw + ((long)flash10.staged_secondary_enrichment *
                                             100));

            per_ignevent_amt_pw1 = (base_pw - calculated_base_pw) / flash10.staged_transition_events;
            per_ignevent_amt_pw2 = (calculated_secondary_enriched - calculated_base_pw) /
                                    flash10.staged_transition_events;

	    staged_num_events_pri = staged_num_events - flash10.staged_primary_delay;
	    if (staged_num_events_pri > staged_num_events) {
		/* rolled over */
		staged_num_events_pri = 0;
	    }

            calculated_pw2 = calculated_secondary_enriched - (staged_num_events * per_ignevent_amt_pw2);
            calculated_pw1 = base_pw - (staged_num_events_pri * per_ignevent_amt_pw1);

            if (calculated_pw2 <= calculated_base_pw) {
                calculated_pw2 = calculated_base_pw;
            }

            if (staged_num_events_pri >= flash10.staged_transition_events) {
                flagbyte4 |= flagbyte4_transition_done;
            }

            if (flagbyte4 & flagbyte4_transition_done) {
                calculated_pw2 = calculated_pw1 = calculated_base_pw;
            }
        } else {
            calculated_pw2 = calculated_pw1 = calculated_base_pw;
        }

        pw_staged1 = calculated_pw1;
        pw_staged2 = calculated_pw2;
    } else {
        /* staging should be off, just set the pulse-width to the base_pw */

        pw_staged1 = base_pw;
        pw_staged2 = 0;
        flagbyte4 &= ~flagbyte4_transition_done;
    }
}

/**************************************************************************
 **
 **  EAE Transient Enrichment Section:
 **
 BF = Basic Fuel amount
 P = MAP value
 EXC = EGO correction factor
 TCC = Corrections for temperature, barometric pressure, etc...
 DFC = Desired Amount of Fuel
 WF = total amt of fuel adhering to walls
 AWC = Adhere to wall coefficient: proportion of the fuel injected in next pulse which will adhere.
 AWA = actual amount that'll adhere in the next pulse
 SOC = proportion of fuel injected in next pulse which will be sucked off the walls
 SOA = actual amt of fuel injected in next pulse which will be sucked off the walls
 SQF = actual amt of fuel squirted for this pulse
 AFC = time that injector is commanded to be open
 DT = injector opening time
 BAWC = AWC but only with reference to manifold pressure.
 BSOC = same as BAWC but for SOC
 AWW = correction to AWC based on CLT
 SOW = correction to SOC based on CLT
 AWN = correction to AWC based on engine speed
 SON = correction to SOC based on engine speed
 AWF = correction to AWC based on air velocity
 SOF = correction to SOC based on air velocity

 AWC = BAWC*AWW*AWN*AWF
 SOC = BSOC*SOW*SON*SOF

 SOA = SOC * WF
 SQF = (DFC - SOA)/(1-AWC)
 AWA = SQF * AWC

 if (fuelcut)
 WF = WF - SOA
 else
 WF = WF + AWA - SOA

 AFC = SQF + DT

 calculation of WF should be done in ISR, the rest can and will be done
 in main loop.
 **
 **************************************************************************/

void run_EAE_calcs (void)
{
    if(flash4.EAEOption)  {
        unsigned long wflocal1, wflocal2;
        unsigned long SQF1, SQF2, SOAtmp1, SOAtmp2, AWAtmp1, AWAtmp2;
        unsigned char BAWC, AWN, SOC, BSOC, SON, AWC, AWW, SOW;


        BAWC = (unsigned char)intrp_1dctable(outpc.fuelload,NO_FMAPS,(int *)flash5.EAEAWCKPAbins,
                0, (unsigned char *)flash5.EAEBAWC);
        AWN = (unsigned char)intrp_1dctable(outpc.rpm,NO_FRPMS,(int *)flash5.EAEAWCRPMbins, 0,
                (unsigned char *)flash5.EAEAWN);
        AWW = (unsigned char)intrp_1dctable(outpc.clt,12,(int *)flash5.EAEAWWCLTbins,
                0, (unsigned char *)flash5.EAEAWW);
        /* BAWC in 1% units, so 100 = 100%, but make end result in .1% units */

        AWC = ((unsigned long)BAWC * AWN * AWW) / 10000;
        if (AWC >= 100) AWC = 99; /* avoid div by 0 below */

        BSOC = (unsigned char)intrp_1dctable(outpc.fuelload,NO_FMAPS,(int *)flash5.EAESOCKPAbins,
                0, (unsigned char *)flash5.EAEBSOC);
        SON = (unsigned char)intrp_1dctable(outpc.rpm,NO_FRPMS,(int *)flash5.EAESOCRPMbins, 0,
                (unsigned char *)flash5.EAESON);
        SOW = (unsigned char)intrp_1dctable(outpc.clt,12,(int *)flash5.EAESOWCLTbins,
                0, (unsigned char *)flash5.EAESOW);

        /* units here are .1% */
        SOC = ((unsigned long)BSOC * SON * SOW) / 10000;

        /* table lookups done, do calcs */

        /* calculate actual amt "sucked off" the walls */

        DISABLE_INTERRUPTS;
        wflocal1 = WF1;
        wflocal2 = WF2;
        ENABLE_INTERRUPTS;

        SOAtmp1 = (SOC * wflocal1) / 1000;
        SOAtmp2 = (SOC * wflocal2) / 1000;

        DISABLE_INTERRUPTS;
        SOA1 = SOAtmp1;
        SOA2 = SOAtmp2;
        ENABLE_INTERRUPTS;

        if (SOAtmp1 > tmp_pw1) SOAtmp1 = tmp_pw1;
        if (SOAtmp2 > tmp_pw2) SOAtmp2 = tmp_pw2;

        /* Calc actual amt of fuel to be injected in next pulse */
        SQF1 = ((unsigned long)((unsigned long)(tmp_pw1 - SOAtmp1) * 100)) / (100 - AWC);
        SQF2 = ((unsigned long)((unsigned long)(tmp_pw2 - SOAtmp2) * 100)) / (100 - AWC);

        if (SQF1 > 3200000) {
            SQF1 = 3200000;
        }
        if (SQF2 > 3200000) {
            SQF2 = 3200000;
        }

        /* do % calc */

        outpc.EAEfcor1 = ((unsigned long)SQF1 * 100) / tmp_pw1;
        outpc.EAEfcor2 = ((unsigned long)SQF2 * 100) / tmp_pw2;

        AWAtmp1 = ((unsigned long)SQF1 * AWC) / 100;
        AWAtmp2 = ((unsigned long)SQF2 * AWC) / 100;

        DISABLE_INTERRUPTS;
        AWA1 = AWAtmp1;
        AWA2 = AWAtmp2;
        ENABLE_INTERRUPTS;
        outpc.wallfuel1 = wflocal1;
        outpc.wallfuel2 = wflocal2;

        if(!(outpc.engine & 0x02)) {
            tmp_pw1 = SQF1;
            tmp_pw2 = SQF2;
        }

        /* WF calc in interrupt */
    }
}
