/* $Id: ms2_extra_init.c,v 1.76.6.51 2009/06/10 04:34:23 culverk Exp $ */
#include "ms2_extra.h"

void set_prime_ASE(void)
{
    PrimeP = (unsigned short)CW_table(outpc.clt,(int *)flash5.CWPrime, (int *)flash5.temp_table_p5);  // msx10
    AWEV = (unsigned short)CW_table(outpc.clt,(int *)flash5.CWAWEV, (int *)flash5.temp_table_p5);     // %
    AWC = (unsigned short)CW_table(outpc.clt,(int *)flash5.CWAWC, (int *)flash5.temp_table_p5);       // cycles
}

void set_EAE_lagcomp(void)
{
    EAEdivider = flash4.Divider * 100;
}

void main_init(void)
{
    int ix;
    long ltmp;
    unsigned char adctest, gpio1adctest, tmp_opt;

    tooth_init = 0;

    // initalize PLL - reset default is Oscillator clock
    // 8 MHz oscillator, PLL freq = 48 MHz, 24 MHz bus,
    //  divide by 16 for timer of 2/3 usec tic
    PLLCTL &= 0xBF;     // Turn off PLL so can change freq
    SYNR = 0x02;        // set PLL/ Bus freq to 48/ 24 MHz
    REFDV = 0x00;
    PLLCTL |= 0x40;     // Turn on PLL
    // wait for PLL lock
    while (!(CRGFLG & 0x08));
    CLKSEL = 0x80;      // select PLL as clock

    // wait for clock transition to finish
    for (ix = 0; ix < 60; ix++);

    // open flash programming capability
    Flash_Init();

    if((int)RamBurnPgm & 0x0001)	{   // odd address - cpy to even one
        (void)memcpy((void *)RamBurnPgm,NoOp,1);         // cpy noop to 1st location
        (void)memcpy((void *)&RamBurnPgm[1],SpSub,32);   // cpy flashburn core pgm to ram
    } else {
        (void)memcpy((void *)RamBurnPgm,SpSub,32);       // cpy flashburn core pgm to ram
    }

    page = 0; // on boot no pages in ram, may want to load page5 for AMC ??
    pg4_ptr = (page4_data *)&flash4;
    pg5_ptr = (page5_data *)&flash5;
    pg10_ptr = (page10_data *)&flash10;
    pg8_ptr = (page8_data *)&flash8;
    pg9_ptr = (page9_data *)&flash9;

    conf_err = 0; // no config errors yet
    flagbyte0 = 0; // must do these before ign_reset as it sets various bits
    flagbyte1 = 0;
    flagbyte2 = 0;
    flagbyte3 = 0;
    outpc.status1 = 0;
    outpc.status2 = 0;
    resetholdoff = 0;

    // set up i/o ports
    //    - port M2 is fast idle solenoid
    //    - port M3 is inj led
    //    - port M4 is accel led
    //    - port M5 is warmup led
    //    - port E0 is flex fuel sensor input
    //    - port E4 is fuel pump
    //    - port P5 is bootload pin (input)
    //    - port T6 is IAC Coil A
    //    - port T7 is IAC Coil B
    //    - port B4 is IAC Enable
    //    - port A0 isn't Knock Enable
    //    - port AD6 can be spark 5 (JS5)
    //    - port AD7 can be spark 6 (JS4)
    DDRM |= 0xFC;    // port M - all outputs, full drive by default
    DDRE |= 0x10;	   // port E4 - output, E0 is input
    DDRT |= 0xC0;    // port T6-7 - outputs
    DDRB |= 0x10;    // port B4 - output
    IRQCR &= ~0x40;	// remove External IRQ pins from interrupt logic
    // can be input (flex fuel) or output (misc port)  // check for clashes in a minute
    if (flash4.FlexFuel && (flash4.flexport == 0x1))  {
        DDRA &= 0xfe;    // port A0 - input
    } else {
        DDRA |= 0x01;    // port A0 - output
    }
    //  Set pointers to real port addresses
    for(ix = 0; ix < 8; ix++)  {
        pPTMpin[ix] = pPTM;
        pPTTpin[ix] = pPTT;
    }
    pPTApin0 = pPORTA;
    // reset those pointers to pins which are to be used as alternate outputs
    outpc.port_status = 0;
    for(ix = 0;ix < NPORT; ix++)  {
        if(flash4.spr_port[ix])  {
            // pin output from normal function goes to dumy reg in ram
            if (ix < 4) {
                pPTMpin[ix + 2] = &dummyReg;
            } else if (ix < 6) {
                if (ix == 4) {
                    pPTTpin[7] = &dummyReg;
                } else if (ix == 5) {
                    pPTTpin[6] = &dummyReg;
                } else {
                    pPTTpin[ix + 2] = &dummyReg;
                }
            } else {
                pPTApin0 = &dummyReg;
            }
            set_spr_port((char)ix, flash4.init_val[ix]);
            lst_pval[ix] = flash4.init_val[ix];
        }
    }

    // initialise num_cyl variable.
    if (flash4.EngStroke & 1) {
        num_cyl = flash4.no_cyl << 1; // two stroke so double it
    } else {
        num_cyl = flash4.no_cyl;
    }

    //calculate number of spark outputs once at startup and store in ram
    if ((flash4.spk_mode & 0x1e) == 2) { // basic trigger, trigger return
        if (flash4.ICIgnOption & 0x8) {
            num_spk = 2; // oddfire
        } else {
            num_spk = 1;
        }
    } else {
        switch (flash4.spk_mode & 0xc0 ) {
            case 0x40:
                num_spk = num_cyl >> 1;
                break;
            case 0x80:
                num_spk = num_cyl;
                break;
            case 0xc0:
                num_spk = 2;
                break;
            case 0:
            default:
                num_spk = 1;
                break;
        }
    }

#ifdef MICROSQUIRT
    if (num_spk > 2) {
        conf_err = 30;
    }
#endif

    if (flash10.RotarySplitMode & 0x20) {
        if (flash10.RotarySplitMode & ROTARY_SPLIT_RX8_MODE) {
            num_spk = 4;
        } else {
            num_spk = 3;
        }
    }

  // Turn off all spark outputs right away
#ifdef MICROSQUIRT
  FIRE_ALL_US;
#else
  FIRE_ALL;
#endif


#ifndef MICROSQUIRT
    if (flash4.spk_config & 0x01) {
        pPTMpin[3] = &dummyReg; //D14
    } else {
        pPTTpin[5] = &dummyReg; //JS10
    }
#else
    pPTTpin[5] = &dummyReg; //IGN1
#endif

    if (num_spk >=2) {
#ifndef MICROSQUIRT
        pPTMpin[4] = &dummyReg; // D16
#else
        pPTTpin[5] = &dummyReg; //IGN2
#endif
    }

    if (num_spk >=3) {
        pPTMpin[5] = &dummyReg; // D15
    }

    if (num_spk >=4) {
        pPTApin0 = &dummyReg; //PA0
    }


    if (((flash4.spk_mode & 0x1f) == 2) && (flash4.spk_conf2 & 1)) {
        // Grab end LED D16 as HEI bypass
        pPTMpin[4] = &dummyReg;
    }

    // these two test bytes get populated bit by bit as features use them, checking as
    // they go that nobody else set that bit first. If so then ERROR
    adctest = 0;
    gpio1adctest = 0;

    if (num_spk >= 5) {
        DDRAD |= 0x40; // enable pin AD06 as digital output
        adctest |= 0x40;
    }

    if (num_spk >= 6) {
        DDRAD |= 0x80; // enable pin AD07 as digital output
        adctest |= 0x80;
    }

    if (num_spk > 6) {
        conf_err = 37; // too many spark outputs
    }

// knock input pins
    if (flash4.knk_option & 0x03) {
        if (flash4.knk_option & 0x04) { // option AD6/JS5
            if (adctest & 0x40) {
                conf_err = 4;
            } else {
                adctest |= 0x40;
                DDRAD &= ~0x40; // ensure pin AD06 is input
                ATD0DIEN |= 0x40; // required despite what datasheet says
// pullup/down
                if ((flash4.knk_option & 0x60) != 0x20) {
                    PERAD |= 0x40;
                    if (flash4.knk_option & 0x40) { // choose polarity
                        if (flash4.knk_option & 0x20) {
                            PPSAD |= 0x40;
                        }
                    } else { // same as knock
                        if (!(flash4.knk_option & 0x10)) {
                            PPSAD |= 0x40;
                        }
                    }
                }
            }
        } else { // default AD7/JS4
            if (adctest & 0x80) {
                conf_err = 4;
            } else {
                adctest |= 0x80;
                DDRAD &= ~0x80; // enable pin AD06 as digital input
                ATD0DIEN |= 0x80;
// pullup/down
                if ((flash4.knk_option & 0x60) != 0x20) {
                    PERAD |= 0x80;
                    if (flash4.knk_option & 0x40) { // choose polarity
                        if (flash4.knk_option & 0x20) {
                            PPSAD |= 0x80;
                        }
                    } else { // same as knock
                        if (!(flash4.knk_option & 0x10)) {
                            PPSAD |= 0x80;
                        }
                    }
                }
            }
        }
    }

    // check for output clashes with code
    if (flash4.FlexFuel & 0x1) {
        if (flash4.flexport == 0) {
            // was old 2nd trig
        } else {
            if (pPTApin0 != &dummyReg) {  // alternate pin is PA0, check for clash
                conf_err = 5;
            }
        }
    }

    // adc clashes - (this bitwise and-ing isn't really going to work - port setting is 0,1,2,3 not 1,2,4,8 etc.)
    if (flash4.BaroOption == 2) {
        if (flash4.rtbaroport < 0x7) {
            if ( ((adctest & 0x80) & (flash4.rtbaroport == 7))
                    || ((adctest & 0x40) & (flash4.rtbaroport == 6)) ){
                conf_err = 3;
            } else {
                if (flash4.rtbaroport == 6) {
                    adctest |= 0x40;
                } else if (flash4.rtbaroport == 7) {
                    adctest |= 0x80;
                }
            }
        } else {
            if (gpio1adctest & flash4.rtbaroport & 0x7) {
                conf_err = 3;
            } else {
                gpio1adctest |= (flash4.rtbaroport & 0x7);
            }
        }
    }

    if((flash4.EgoOption == 2) || (flash4.EgoOption == 4))  {
        if (flash4.ego2port < 0x7) {
            if ( ((adctest & 0x80) & (flash4.ego2port == 7))
                    || ((adctest & 0x40) & (flash4.ego2port == 6)) ){
                conf_err = 2;
            } else {
                if (flash4.ego2port == 6) {
                    adctest |= 0x40;
                } else if (flash4.ego2port == 7) {
                    adctest |= 0x80;
                }
            }

        } else {
            if (gpio1adctest & flash4.ego2port & 0x7) {
                conf_err = 2;
            } else {
                gpio1adctest |= (flash4.rtbaroport & 0x7);
            }
        }
    }

    //check for tacho out conflicts
    if ((flash5.tacho_opt & 0x80) && (flash4.userlevel > 127)) {
        tmp_opt = flash5.tacho_opt & 0x3f;
        if (tmp_opt == 0) {
            if (pPTTpin[5] == &dummyReg) {
                conf_err = 6;
            } else {
                pPTTpin[5] = &dummyReg;
            }
        } else if (tmp_opt == 1) {
            if ((pPTTpin[7] == &dummyReg) || (flash4.IdleCtl == 2) || (flash4.IdleCtl == 3)
                    || (flash4.IdleCtl == 5)) {
                conf_err = 6; // pin already used or stepper idle on
            } else {
                pPTTpin[7] = &dummyReg;
            }
        } else if (tmp_opt == 2) {
            if ((pPTTpin[6] == &dummyReg) || (flash4.IdleCtl == 2) || (flash4.IdleCtl == 3)
                    || (flash4.IdleCtl == 5)) {
                conf_err = 6; // pin already used or stepper idle on
            } else {
                pPTTpin[6] = &dummyReg;
            }
        } else if (tmp_opt == 3) {
            if (pPTApin0 == &dummyReg) {
                conf_err = 6;
            } else {
                pPTApin0 = &dummyReg;
            }
        } else if (tmp_opt == 4) {
            if ((pPTMpin[2] == &dummyReg) || (flash4.IdleCtl == 1) || (flash4.IdleCtl == 4) ||
                    (flash4.IdleCtl == 6)) {
                conf_err = 6;
            } else {
                pPTMpin[2] = &dummyReg;
            }
        } else if (tmp_opt == 5) {
            if (pPTMpin[3] == &dummyReg) {
                conf_err = 6;
            } else {
                pPTMpin[3] = &dummyReg;
            }
        } else if (tmp_opt == 6) {
            if (pPTMpin[4] == &dummyReg) {
                conf_err = 6;
            } else {
                pPTMpin[4] = &dummyReg;
            }
        } else if (tmp_opt == 7) {
            if (pPTMpin[5] == &dummyReg) {
                conf_err = 6;
            } else {
                pPTMpin[5] = &dummyReg;
            }
        }
    }

    if (flash5.boost_ctl_settings & BOOST_CTL_ON) {
        if (flash5.boost_ctl_pins & BOOST_CTL_IACA) {
            if ((pPTTpin[7] == &dummyReg) || (flash4.IdleCtl == 2) || (flash4.IdleCtl == 3) || (flash4.IdleCtl == 5)) {
                conf_err = 27;
            } else {
                pPTTpin[7] = &dummyReg;
                boostport = pPTT;
                boostpin = 0x80;
            }
        } else if (flash5.boost_ctl_pins & BOOST_CTL_IACB) {
            if ((pPTTpin[6] == &dummyReg) || (flash4.IdleCtl == 2) || (flash4.IdleCtl == 3) || (flash4.IdleCtl == 5)) {
                conf_err = 27;
            } else {
                pPTTpin[6] = &dummyReg;
                boostport = pPTT;
                boostpin = 0x40;
            }
        } else if (flash5.boost_ctl_pins & BOOST_CTL_JS11) {
            if (pPTApin0 == &dummyReg) {
                conf_err = 27;
            } else {
                pPTApin0 = &dummyReg;
                boostport = pPORTA;
                boostpin = 0x01;
            }
        } else if (flash5.boost_ctl_pins & BOOST_CTL_IDLE) {
            if ((pPTMpin[2] == &dummyReg) || (flash4.IdleCtl == 1) || (flash4.IdleCtl == 4) ||
                    (flash4.IdleCtl == 6)) {
                conf_err = 27;
            } else {
                pPTMpin[2] = &dummyReg;
                boostport = pPTM;
                boostpin = 0x04;
            } 
        } else {
            conf_err = 27;
        }
    }

    //nitrous outputs on IACs or FIDLE+D15
    if (flash10.N2Oopt & 0x04) { // nitrous stage 1
        if (flash10.N2Oopt & 0x80) { // on FIDLE
            if ((pPTMpin[2] == &dummyReg) || (flash4.IdleCtl == 1) || (flash4.IdleCtl == 4) || (flash4.IdleCtl == 6)) {
                conf_err = 39;
            } else {
                pPTMpin[2] = &dummyReg;
            }
        } else { // on IAC1
            if ((pPTTpin[7] == &dummyReg) || (flash4.IdleCtl == 2) || (flash4.IdleCtl == 3) || (flash4.IdleCtl == 5)) {
                conf_err = 28;
            } else {
                pPTTpin[7] = &dummyReg;
            }
        }
        if (flash10.N2Oopt & 0x08) { // stage 2
            if (flash10.N2Oopt & 0x80) { // on D15
                if (pPTMpin[5] == &dummyReg) {
                    conf_err = 40;
                } else {
                    pPTMpin[5] = &dummyReg;
                }
            } else {  // on IAC2
                if ((pPTTpin[6] == &dummyReg) || (flash4.IdleCtl == 2) || (flash4.IdleCtl == 3) || (flash4.IdleCtl == 5)) {
                    conf_err = 28;
                } else {
                    pPTTpin[6] = &dummyReg;
                }
            }
        }
    }

    //check for launch in conflicts
    if ((flash10.launch_opt & 0x40) && (flash4.userlevel > 191)) {
        tmp_opt = flash10.launch_opt & 0x3f;
        // do similar checking to above, but xref against inputs and set pue, ddr if req'd
        /* 0 PE0
           1 PE1
           2 JS10 PT5
           3 PA0
           4 AD6
           5 AD7
         */
        if (tmp_opt == 0) {
            if (pPTEpin[0] == &dummyReg) {
                conf_err = 7;
            } else {
                pPTEpin[0] = &dummyReg;
            }
        } else if (tmp_opt == 1) {
            if (pPTEpin[1] == &dummyReg) {
                conf_err = 7;
            } else {
                pPTEpin[1] = &dummyReg;
            }
        } else if (tmp_opt == 2) {
            if (pPTTpin[5] == &dummyReg) {
                conf_err = 7;
            } else {
                pPTTpin[5] = &dummyReg;
                DDRT &= ~0x20;
                flagbyte0 |= flagbyte0_pt5ip;
                PERT |= 0x20;
                PPST &= ~0x20;
                //need to configure as input and disable interrupt
            }
        } else if (tmp_opt == 3) {
            if (pPTApin0 == &dummyReg) {
                conf_err = 7;
            } else {
                pPTApin0 = &dummyReg;
                DDRA &= ~0x01; /* configure as input. Pullup enabled later */
            }
        } else if (tmp_opt == 4) {
            if (adctest & 0x40) {
                conf_err = 7;
            } else {
                adctest |= 0x40;
                ATD0DIEN |= 0x40;
                DDRAD &= ~0x40;
                PPSAD &= ~0x40; // use pull UP
                PERAD |= 0x40; // enable a pull
            }
        } else if (tmp_opt == 5) {
            if (adctest & 0x80) {
                conf_err = 7;
            } else {
                adctest |= 0x80;
                ATD0DIEN |= 0x80;
                DDRAD &= ~0x80;
                PPSAD &= ~0x80; // use pull UP
                PERAD |= 0x80; // enable a pull
            }
        }
    }

    if (flash10.N2Oopt & 0x04) {
        tmp_opt = (flash10.N2Oopt & 0x70) >> 4;

        /* 0 PE0
           1 PE1
           2 JS10 PT5
           3 PA0
           4 AD6
           5 AD7
         */
        if (tmp_opt == 0) {
            if (pPTEpin[0] == &dummyReg) {
                conf_err = 7;
            } else {
                pPTEpin[0] = &dummyReg;
            }
        } else if (tmp_opt == 1) {
            if (pPTEpin[1] == &dummyReg) {
                conf_err = 7;
            } else {
                pPTEpin[1] = &dummyReg;
            }
        } else if (tmp_opt == 2) {
            if (pPTTpin[5] == &dummyReg) {
                conf_err = 7;
            } else {
                pPTTpin[5] = &dummyReg;
                DDRT &= ~0x20;
                flagbyte0 |= flagbyte0_pt5ip;
                PERT |= 0x20;
                PPST &= ~0x20;
                //need to configure as input and disable interrupt
            }
        } else if (tmp_opt == 3) {
            if (pPTApin0 == &dummyReg) {
                conf_err = 7;
            } else {
                pPTApin0 = &dummyReg;
                DDRA &= ~0x01; /* configure as input. Pullup enabled later*/
            }
        } else if (tmp_opt == 4) {
            if (adctest & 0x40) {
                conf_err = 7;
            } else {
                adctest |= 0x40;
                ATD0DIEN |= 0x40;
                DDRAD &= ~0x40;
                PPSAD &= ~0x40; // use pull UP
                PERAD |= 0x40; // enable a pull
            }
        } else if (tmp_opt == 5) {
            if (adctest & 0x80) {
                conf_err = 7;
            } else {
                adctest |= 0x80;
                ATD0DIEN |= 0x80;
                DDRAD &= ~0x80;
                PPSAD &= ~0x80; // use pull UP
                PERAD |= 0x80; // enable a pull
            }
        }
    }

    // check for valid cylinder counts
    if ((num_cyl == 7) || (num_cyl == 9) || (num_cyl == 11) || (num_cyl > 13)) {
        conf_err = 8; // might work in fuel-only though
    }

    if ((flash4.ICIgnOption & 0xa) == 0xa) {
        conf_err = 9; // trigret and oddfire not allowed
    }

    if (flash10.staged & 0x3) {
        if (!flash10.staged_pri_size || !flash10.staged_sec_size) {
            conf_err = 10;
        }

        if ((flash10.staged & 0x3) == ((flash10.staged & 0xc) >> 2)) {
            conf_err = 11;
        }

        if (flash10.staged_param_1 == 0) {
            conf_err = 12;
        }

        if ((flash10.staged & 0xc) && (!flash10.staged_param_2)) {
            conf_err = 13;
        }

        if ((flash10.staged & 0x10) && (!flash10.staged_transition_events)) {
            conf_err = 14;
        }

        if (flash4.Alternate & 0x1) {
            conf_err = 15;
        }
        if (flash4.dual_tble_optn) {
            conf_err = 26;
        }
    }

    if (flash4.dual_tble_optn && ((flash4.FuelAlgorithm & 0xF0) ||
                (flash4.IgnAlgorithm & 0xF0))) {
        conf_err = 16;
    }

    if (((flash4.spk_mode & 0x1f) == 2) || ((flash4.spk_mode & 0x1f) == 3)) {
        if (flash4.adv_offset < 0) {
            conf_err = 31;
        }
    }


    // see if we can enable ignition trigger led without conflict
    if ((pPTMpin[5] != &dummyReg) && (flash4.feature4_0 & 0x2) && ((flash4.spk_mode & 0x1f) == 3) ) {
        pPTMpin[5] = &dummyReg;
        flagbyte1 |= flagbyte1_igntrig;
    }

    // turn off fidle solenoid, leds
    *pPTMpin[2] &= ~0x04;
    *pPTMpin[3] &= ~0x08;
    *pPTMpin[4] &= ~0x10;
    *pPTMpin[5] &= ~0x20;
    PORTE &= ~0x10;            // turn off fuel pump
#ifndef MICROSQUIRT
    *pPTTpin[6] &= ~0xC0;      // turn off IAC coils
#endif

    if(flash4.IdleCtl == 2)  {
        PORTB |= 0x10;   // disable current to motor (set bit= 1)
    } else {    //  IdleCtl = 3, 5 or no stepper motor (set bit = 0)
        PORTB &= ~0x10;  // enable current to motor always(set bit= 0)
    }

    // set all unused (even unbonded) ports to   with pullups
    DDRA &= 0x01;
    DDRB &= 0x10;
    DDRE &= 0x10;
    PUCR |= 0x13;    // enable pullups for ports E, B and A
    DDRP = 0x00;
    PERP = 0xFF;     // enable pullup resistance for port P
    DDRJ &= 0x3F;
    PERJ |= 0xC0;    // enable pullup resistance for port J6,7
    DDRS &= 0xF3;
    PERS |= 0x0C;    // enable pullup resistance for port S2,3

    // set up CRG RTI Interrupt for .128 ms clock. CRG from 8MHz oscillator.
    mms = 0;        // .128 ms tics
    millisec = 0;   // 1.024 ms clock (8 tics) for adcs
    lmms = 0;
    cansendclk = 7812;
    ltch_lmms = 0;
    outpc.seconds = 0;   // (1.0035) secs
    RTICTL = 0x10;   // load timeout register for .128 ms (smallest possible)
    CRGINT |= 0x80;  // enable interrupt
    CRGFLG = 0x80;   // clear interrupt flag (0 writes have no effect)
    //  COPCTL = 0x44; // Enable long C.O.P. timeout 2^20 ~0.125s   XXXX disabled

    // Set up SCI (rs232): SCI BR reg= BusFreq(=24MHz)/16/baudrate
    SCI0BDL = (unsigned char)(1500000/flash4.baud);
    ltmp = (150000000/flash4.baud) - ((long)SCI0BDL*100);
    if(ltmp > 50) {
        SCI0BDL++;   // round up
    }
    SCI0CR1 = 0x00;
    SCI0CR2 = 0x24;   // TIE=0,RIE = 1; TE=0,RE =1
    txcnt = 0;
    rxcnt = 0;
    txmode = 0;
    txgoal = 0;
    rcv_timeout = 0xFFFFFFFF;


    smallest_tooth_crk = 0;
    smallest_tooth_cam = 0;
    false_mask_crk = 0;
    false_mask_cam = 0;
    false_period_crk_tix = 0;
    false_period_cam_tix = 0;
    if ((flash4.spk_mode & 0x1f) > 1 ) {
        ign_wheel_init();
        // need to do this here to set the various flagbyte5 bits
    }

    //  Initialize timers:
    // Megasquirt timer uses
    //   Note: Inj OC and PWM are Nanded.
    //    -when turn on inj1 i/o, also enable pwm1 @ 100 % duty &
    //      set pwm1 timer = 0 (.1 ms units).
    //    -When pwm1 timer = InjPWMTim, set duty cycle to InjPWMDty.
    //    -when done injecting, turn off inj1 i/o and pwm1.
    //   TC0: Input capture (tach) - no pullup (default) for MSII
    //   TC1: Output compare for injector output - bank 1
    //   TC2: PWM2 for injector bank 1 / Timer for bit bash spark output
    //   TC3: Output compare for injector output - bank 2
    //   TC4: PWM4 for injector bank 2 / Rotary Spark
    //   TC5: Output compare for EDIS output / 2nd trigger input
    //   TC6: Dwell timer
    //   TC7: Rotary dwell timer

    // Microquirt timer uses
    //   No PWM used.
    //   TC0: Input capture (tach) - no pullup (default) for MSII
    //   TC1: Output compare for injector output - bank 1
    //   TC2: 2nd trigger input
    //   TC3: Output compare for injector output - bank 2
    //   TC4: Rotary Spark / pin used for bit bashed spark B
    //   TC5: Output compare for EDIS output / spark timer / pin used for bit bashed spark A
    //   TC6: Dwell timer
    //   TC7: Rotary dwell timer

    //SPK,CHG only used by EDIS. Want to get rid of them
    if (flash4.ICIgnOption & 0x10) {
        SPK = 0;
    } else {
        SPK = 1;
    }                               // 0=spk low, but inverted logic
    CHG = 1 - SPK;                  // after transistor
    TIOS |= 0xFE; // Timer ch 0 = IC, ch 1-5 = OC & PWM,
    // ch 6,7 = I/O output
    // Set prescaler to 16. This divides bus clk (= PLLCLK/2 = 24 MHz)
    //   by 16. This gives 1.5 MHz timer, 1 tic = 2/3 us.
    TSCR2 = 0x84;    // setup timer, enable overflow int
    TCTL2 |= 0x88;   // bit OM1,3,5 = 1. OC output line high or
    // low iaw OL1,3,5 (not toggle or disable)
    // Only set up for OC directly controlling output pin when not in wasted spk
    // mode.

    if ((flash4.spk_mode & 0x1e) == 0) { // EDIS only
        TCTL1 |= 0x08;
        TCTL1 = (TCTL1 & 0xFB) | (SPK << 2);  // set OC o/p in OL5
        CFORC |= 0x20;           // force output in OL5 onto OC pin
        IgnOCpinstate = SPK;
    } else if (((flash4.spk_mode & 0x1f) == 4) && (flash4.spk_config & 0x08)) { // trigger wheel and 2nd trig, set active IC edges
        unsigned char ctmp;
        ctmp = flash4.spk_config & 0x30;
#ifndef MICROSQUIRT
        ctmp = ctmp >>2;
        if (flash4.secondtrigopts & NOISE_FILTER_ONLY) {
            ctmp = 0xc;
        }
        TCTL3 = (TCTL3 & 0xf3) | ctmp;
#else
        if (flash4.secondtrigopts & NOISE_FILTER_ONLY) {
            ctmp = 0x30;
        }
        TCTL4 = (TCTL4 & 0xcf) | ctmp;
#endif
    } else if ( flagbyte5 & FLAGBYTE5_CAM ) { // other modes that use the cam
        if ((flash4.spk_mode & 0x1f) == 14) {
            flagbyte2 |= flagbyte2_twintrig; // set this quick flag
        }
#ifndef MICROSQUIRT
        TCTL3 = TCTL3 & 0xf3;
        if (flash4.ICIgnOption & 0x01) { // 2nd is same polarity as primary trigger input
            TCTL3 |= 0x04;
        } else {
            TCTL3 |= 0x08;
        }
#else
        TCTL4 = TCTL4 & 0xcf;
        if (flash4.ICIgnOption & 0x01) { // 2nd is same polarity as primary trigger input
            TCTL4 |= 0x10;
        } else {
            TCTL4 |= 0x20;
        }
#endif
    } else { // not using cam
#ifndef MICROSQUIRT
        TCTL3 &= 0xf3; //TC5 disconnected from IC logic
#else
        TCTL4 &= 0xcf; //TC2 disconnected from IC logic
#endif
    }

    flagbyte5 &= ~(FLAGBYTE5_CAM_NOISE | FLAGBYTE5_CAM_POLARITY | FLAGBYTE5_CAM_BOTH | FLAGBYTE5_CRK_BOTH); // ensure all off to start

    if (flagbyte5 & FLAGBYTE5_CAM) {
        if ((flagbyte5 & FLAGBYTE5_CAM_DOUBLE) == 0) { // disabled if double (presently only rising and falling)
            if (flash4.secondtrigopts & 0x01) { // noise filter
                flagbyte5 |= FLAGBYTE5_CAM_BOTH;
                flagbyte5 |= FLAGBYTE5_CAM_NOISE;
            } else if (flash4.secondtrigopts & 0x08) { //polarity check
                flagbyte5 |= FLAGBYTE5_CAM_POLARITY;
            }
        }
#ifndef MICROSQUIRT
        TCTL1 &= 0xf3; // not OC
        DDRT &= ~TFLG_trig2; // ensure PTT5 = input (already done above)
#else
        TCTL2 &= 0xcf; // not OC
#endif
        TIOS &= ~TFLG_trig2; // set as input capture
        TIE |= TFLG_trig2; //enable IC interrupts
#ifndef MICROSQUIRT
    } else if (!(flagbyte0 & flagbyte0_pt5ip)) { // only if not an input
        DDRT |= TFLG_trig2; // set PTT5 as output
#endif
    }

#ifdef MICROSQUIRT
    DDRT = 0xfa; // injector and ign as outputs, two tach inputs. Simpler hardware, less choices.
#endif

    // the single/double edge trigger flags are set in ign_wheel based on the mode

    // Presently, if the wheel already uses both edges, then we cannot enable the noise filter

    if ( flagbyte5 & FLAGBYTE5_CRK_DOUBLE ) { // crank is double edge triggered
        flagbyte1 &= ~flagbyte1_noisefilter;  // disable noise filter
        flagbyte5 |= FLAGBYTE5_CRK_BOTH;
        TCTL4 |= 0x03;
    } else if (flash4.NoiseFilterOpts & 0x01) {
        flagbyte1 |= flagbyte1_noisefilter; // permit noise filter
        flagbyte5 |= FLAGBYTE5_CRK_BOTH;
        TCTL4 |= 0x03;
    } else {
        flagbyte1 &= ~flagbyte1_noisefilter; // disable noise filter
        TCTL4 &= ~0x03;
        if (flash4.ICIgnOption & 0x01) {
            TCTL4 |= 0x01;
        } else {
            TCTL4 |= 0x02;
        }
    }

    OC7M = 0; // don't want to use OC7 feature
#ifndef MICROSQUIRT
    // Set up injector PWMs - PWM2, 4
    MODRR = 0x14;     // Make Port T pins 2,4 be PWM
    PWME = 0;         // disable pwms initially
    PWMPOL = 0x14;    // polarity = 1, => go hi when start
    PWMCLK = 0x14;    // select scaled clocks SB, SA
    PWMPRCLK = 0x00;  // prescale A,B clocks = bus = 24 MHz
    PWMSCLA = 0x0C;   // pwm clk = SA clk/(2*SCLA) = 24MHz/24 = 1 us clk
    PWMSCLB = 0x0C;   // pwm clk = SB clk/(2*SCLB) = 24MHz/24 = 1 us clk
    PWMCAE = 0x00;    // standard left align pulse: -----
    //                           |     |______
    //                             duty
    //                           <---period--->
    PWMPER2 = flash4.InjPWMPd;   // set PWM period (us)
    if (flash4.ICIgnOption & 0x20) {
        PWMPER4 = flash4.InjPWMPd2;   // set PWM period (us)
    } else {
        PWMPER4 = flash4.InjPWMPd;   // set PWM period (us)
    }
#endif
    ign_reset();

    flagbyte4 |= flagbyte4_first_edis;

    // IACStart = enough steps to set IAC wide open.
    //  Set current IAC position to IACStart (all way closed), then move
    //  to the 0 position (wide open - fast idle) and zero out. After
    //  this all subsequent IAC commands will gradually close air passage
    //  as clt temp rises.
    //  Note: Ignore all move commands until finished current move.
    IdleCtl = flash4.IdleCtl;
    flagbyte3 |= flagbyte3_firstIAC;
    IAC_moving = 0;
    motor_step = -1;

    pwmidle_reset = 4;
    IACmotor_reset = 0;

    outpc.iacstep = flash4.IACStart;  // set current motor step position

#ifndef MICROSQUIRT
    if ((IdleCtl == 2) || (IdleCtl == 3) ||
	(IdleCtl == 5) || (IdleCtl == 7) ||
        (IdleCtl == 8)) {
        IACmotor_pos = 0;
        (void)move_IACmotor();
    }
#endif
    last_iacclt = -3200;
    iacpwmctr = 0;

    // set up ADC processing
    // ATD0
    //    - AN0 is MAP
    //    - AN1 is MAT
    //    - AN2 is CLT
    //    - AN3 is TPS
    //    - AN4 is BAT
    //    - AN5 is EGO1 (NB or WB)
    //    - AN6 is Spare or BARO or KNOCK or spark(BaroOption =2) or EGO2 (EgoOption = 2 or 4)
    //    - AN7 is Spare or KNOCK or spark
    // Set up ADCs so they continuously convert, then read result registers
    //  every millisecond
    next_adc = 0;	   	// specifies next adc channel to be read
    ATD0CTL2 = 0x40;  // leave interrupt disabled, set fast flag clear
    ATD0CTL3 = 0x00;  // do 8 conversions/ sequence
    ATD0CTL4 = 0x67;  // 10-bit resoln, 16 tic cnvsn (max accuracy),
    // prescaler divide by 16 => 2/3 us tic x 18 tics
    ATD0CTL5 = 0xB0;  // right justified,unsigned, continuous cnvsn,
    // sample 8 channels starting with AN0
    ATD0CTL2 |= 0x80;  // turn on ADC0
    // wait for ADC engine charge-up or P/S ramp-up
    for(ix = 0; ix < 160; ix++)  {
        while(!(ATD0STAT0 >> 7));	 // wait til conversion complete
        ATD0STAT0 = 0x80;
    }
    // get all adc values
    first_adc = 1;
    get_adc(0,7);
    first_adc = 0;
    if(flash4.BaroOption < 2) {
        if ((flash4.BaroOption == 1) && (outpc.map < flash4.baro_upper) && (outpc.map > flash4.baro_lower)) {
            outpc.baro = outpc.map;    // If within range use the initial sensor value
        } else {
            if ((flash4.baro_default > 600) && (flash4.baro_default < 1050)) { // hardcoded limits
                outpc.baro = flash4.baro_default;    // Use entered value if it seems sensible kPa x 10
            } else {
                outpc.baro = 1000;         // failsafe 100 kPa
            }
        }
    }
    adc_lmms = lmms;
    // Initialize variables
    flocker = 0;
    Rpm_Coeff = 180000000 / num_cyl;
    pwcalc1 = 0;    // us
    outpc.pw1 = pwcalc1;
    pwcalc2 = 0;    // us
    outpc.pw2 = pwcalc2;
    outpc.adv_deg = 0;    // crank deg x 10
    coil_dur = flash4.max_coil_dur;   // msx10
    coil_dur_set = coil_dur * 100;    // us
    outpc.coil_dur = (int)(coil_dur_set / 100);   // msx10
    if (flash4.userlevel > 191) {
        PulseTol = flash4.CrnkTol;
    } else {
        PulseTol = 50;
    }
    outpc.fuelload = 1000;  // kPa x 10
    outpc.ignload = 1000;
    last_tps = outpc.tps; // % x 10
    last_map = outpc.map;       // kPa x 10
    outpc.afrtgt1 = 147;  // afr x 10
    outpc.afrtgt2 = outpc.afrtgt1;
    outpc.aircor = 100;
    outpc.vecurr1 = 100;
    outpc.vecurr2 = outpc.vecurr1;
    outpc.barocor = 100;
    outpc.warmcor = 100;
    outpc.cold_adv_deg = 0;  // crank deg x 10
    outpc.wbo2_en1 = 1;
    outpc.wbo2_en2 = 1;
    outpc.egocor1 = 1000;
    outpc.egocor2 = 1000;
    outpc.tpsfuelcut = 100;
    outpc.gammae = 100;
    outpc.tpsaccel = 0;
    tcrank_done = 0xFFFF;
    tcold_pos = 0xFFFF;
    FSensStat = 0;
    FSens_Pd = 0;
    outpc.fuelcor = 100;    // %
    ffspkdel = 0;           // degx10
    bad_ego_flag = 0;
    first_clt = 1;
    idle_advance_timer = 0;
    if (flash4.EAEOption) {
        WF1 = 0;
        WF2 = 0;
        AWA1 = 0;
        AWA2 = 0;
        SOA1 = 0;
        SOA2 = 0;
    }

    if (flash4.EAEOption == 3) {
        set_EAE_lagcomp();
        injtime_EAElagcomp = 0;
    }

    
    injtime = 0;
    inj1cntdown = 0;
    inj2cntdown = 0;

    /* Initialize CAN comms */
    // can_reset flag set above when flagbyte3 cleared
    CanInit();

    // make IC highest priority interrupt
    HPRIO = 0xEE;

    // enable global interrupts
    ENABLE_INTERRUPTS;

        // Prime Pulse - shoot 1 prime pulse of length PrimeP ms x 10
        start_clt = outpc.clt;
    set_prime_ASE();

    if (flash5.boost_ctl_settings & BOOST_CTL_ON) {
        boost_ctl_init();
    }

    if ((flash4.IdleCtl == 4) || (flash4.IdleCtl == 6)) {
        idle_ctl_init();
    }

    ego_init();

    if(PrimeP)  {
        if (PrimeP > 436) {
            outpc.pw1 = 65535; // max is 43ms, so can't overflow
        } else {
            outpc.pw1 = PrimeP * 150;       // ticks
        }
        outpc.pw2 = outpc.pw1;
        // Turn on fuel pump
        PORTE |= 0x10;
        // Turn On injectors & PWMs

        TCTL2 |= 0x04;
        CFORC |= 0x02;   // force high
#ifndef MICROSQUIRT
        // set PWM duty (on time) to 100 %
        PWMDTY2 = PWMPER2;
        pwm1_on = 0;
        PWMCNT2 = 0x00;
        PWME |= 0x4;     // enable PWM
#endif
        // Set up to turn Off injectors when get to pw us
        TCTL2 &= ~0x04;   // set outputs lo in OL1
        TC1 = TCNT + outpc.pw1; // load OC compare register
        TIE |= 0x02;

        /* INJ2 prime pulse... seperated for staged injection */
        if(!(flash10.staged & 0x03)) {
            TCTL2 |= 0x40;
            CFORC |= 0x8;
#ifndef MICROSQUIRT
            PWMDTY4 = PWMPER4;
            pwm2_on = 0;
            PWMCNT4 = 0x00;
            PWME |= 0x10;
#endif
            TCTL2 &= ~0x40;
            TC3 = TC1;
            TIE |= 0x08;
        }

        // turn on inj led
        *pPTMpin[3] |= 0x08;
        outpc.squirt |= 0x03;   // both injectors squirting
        //outpc.engine |= 0x01;   // engine in ready to run status
    }

    stall_timeout = 18750/num_cyl; // calculate stall timeout once
    fc_counter = 0xff;
    adc_ctr = 0;
    lowres=0;
    lowres_ctr=0;
    tacho_targ=0;
    spk_cutx =0;
    spk_cuty =0;

    if (flash10.staged & 0x7) {
        setup_staging();
    }
    if ( ((flash4.spk_mode & 0x1f) == 3) && (flash4.spk_conf2 & 0x2)
            && (flash4.dwellmode == 1) ) {
        // if trig ret, TFI, fixed duty then must be push start (not actually used!)
        flagbyte2 |= flagbyte2_tfi_ps;
    }

    wheeldec_ovflo = 0;
    rtsci = 0;
    bl_timer = 0;
    n2o_act_timer = 0;
    n2o2_act_timer = 0;
    n2o_addfuel = 0;
    fc_off_time = 0xfe;

    if (flash4.RevLimOption & 0x8) {
        RevLimRpm1 = flash4.RevLimNormal1;
        RevLimRpm2 = flash4.RevLimNormal2;
    } else {
        RevLimRpm1 = flash4.RevLimTPSbypassRPM;
        RevLimRpm2 = RevLimRpm1 + flash4.RevLimRpm2;
    }

    outpc.gpioadc[0] = 0;
    outpc.gpioadc[1] = 0;
    outpc.gpioadc[2] = 0;
    outpc.gpioadc[3] = 0;
    outpc.gpioadc[4] = 0;
    outpc.gpioadc[5] = 0;
    outpc.gpioadc[6] = 0;
    outpc.gpioadc[7] = 0;

    outpc.syncreason = 0;

/* 'user defined'                                                           *  
 * Here are some variables defined to help the new programmer get started   *
 * search for 'user defined' in ms2_extra_main.c for more notes             *
 *                                                                          *
 * Initialisation                                                           */
user_ulong = 0;
user_uint = 0;
user_uchar = 0;
/* end user defined section                                                 */

    return;
}
