/* $Id: ms2_extra_ign_wheel.c,v 1.34.6.60 2009/06/11 17:43:01 jsmcortina Exp $ */
#include "ms2_extra.h"

unsigned char decode_errs;

void ign_wheel_init(void)
{
    char trig_tooth, trig_missing, miss_teeth;
    unsigned int j, tmp_deg_per_tooth;
    void *dummy;
    unsigned char teeth_per_trig;
    int tmp_offset;

    /* figure out any necessary parameters for the wheel decoder init */
    wheeldec_ovflo = 0; // do this in global init as well

    dummy = memset((void *)dwell_events_a, 0, sizeof(dwell_events_a));
    dummy = memset((void *)spark_events_a, 0, sizeof(spark_events_a));
    dummy = memset((void *)dwell_events_b, 0, sizeof(dwell_events_b));
    dummy = memset((void *)spark_events_b, 0, sizeof(spark_events_b));

    dwell_events = dwell_events_a;
    spark_events = spark_events_a;

    if (flash4.adv_offset < -200) {
        tmp_offset = -200;
    } else if (flash4.adv_offset > 200) {
        tmp_offset = 200;
    } else {
        tmp_offset = flash4.adv_offset;
    }

    // initially set bits to zero. Means single edge on 
    flagbyte5 &= ~(FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH | FLAGBYTE5_CAM | FLAGBYTE5_CAM_DOUBLE | FLAGBYTE5_CAM_BOTH);

    /* ----------------------  420A/NEON MODE ------------------------*/
    if ((flash4.spk_mode & 0x1f) == 5) {
        flagbyte5 |= FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH;

        deg_per_tooth[0] =  200;
        deg_per_tooth[1] =  200;
        deg_per_tooth[2] =  200;
        deg_per_tooth[3] = 1200;
        deg_per_tooth[4] =  200;
        deg_per_tooth[5] =  200;
        deg_per_tooth[6] =  200;
        deg_per_tooth[7] = 1200;

        smallest_tooth_crk = 60; // now 6.0 deg, was 20.0 deg, but lost sync above 2250rpm with false trig method
        smallest_tooth_cam = 150;
        trigger_teeth[0] = 5;
        trig_angs[0] = -1110 + tmp_offset; // 69 BTDC (on next event) = 111ATDC
        trig_angs[1] = -1110 + tmp_offset; // 69 BTDC (on next event) = 111ATDC

        if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) {  //if COP mode or use cam then double up pattern
            flagbyte5 |= FLAGBYTE5_CAM;
            deg_per_tooth[8] =  200;
            deg_per_tooth[9] =  200;
            deg_per_tooth[10]=  200;
            deg_per_tooth[11]= 1200;
            deg_per_tooth[12]=  200;
            deg_per_tooth[13]=  200;
            deg_per_tooth[14]=  200;
            deg_per_tooth[15]= 1200;

            trigger_teeth[1] = 9;
            trigger_teeth[2] = 13;
            trigger_teeth[3] = 1;
            trig_angs[2] = -1110 + tmp_offset; // 69 BTDC (on next event) = 111ATDC
            trig_angs[3] = -1110 + tmp_offset; // 69 BTDC (on next event) = 111ATDC
            no_triggers = 4;
            no_teeth = 16;
        } else {
            trigger_teeth[1] = 1;
            no_triggers = 2;
            no_teeth = 8;
        }
        last_tooth = no_teeth;

        if (num_cyl !=4) {
            conf_err = 17;
        }

        /* ----------------------  36-2+2 ------------------------*/

    } else if ((flash4.spk_mode & 0x1f) == 6) {
        flagbyte5 |= FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH;
        no_teeth = 32;
        last_tooth = no_teeth;
        deg_per_tooth[0] =  100;
        deg_per_tooth[1] =  100;
        deg_per_tooth[2] =  100;
        deg_per_tooth[3] =  100;
        deg_per_tooth[4] =  100;
        deg_per_tooth[5] =  100;
        deg_per_tooth[6] =  100;
        deg_per_tooth[7] =  100;
        deg_per_tooth[8] =  100;
        deg_per_tooth[9] =  100;
        deg_per_tooth[10] = 100;
        deg_per_tooth[11] = 100;
        deg_per_tooth[12] = 100;
        deg_per_tooth[13] = 100;
        deg_per_tooth[14] = 100;
        deg_per_tooth[15] = 300;

        deg_per_tooth[16] = 100;
        deg_per_tooth[17] = 100;
        deg_per_tooth[18] = 100;
        deg_per_tooth[19] = 100;
        deg_per_tooth[20] = 100;
        deg_per_tooth[21] = 100;
        deg_per_tooth[22] = 100;
        deg_per_tooth[23] = 100;
        deg_per_tooth[24] = 100;
        deg_per_tooth[25] = 100;
        deg_per_tooth[26] = 100;
        deg_per_tooth[27] = 100;
        deg_per_tooth[28] = 100;
        deg_per_tooth[29] = 100;
        deg_per_tooth[30] = 100;
        deg_per_tooth[31] = 300;

        smallest_tooth_crk = 100;
        smallest_tooth_cam = 360;

        if (num_cyl == 4) {
            no_triggers = 2;
            trigger_teeth[0] = 17;
            trigger_teeth[1] = 1;
            trig_angs[0] = -300 + tmp_offset; // 30 ATDC (on next event)
            trig_angs[1] = -300 + tmp_offset; // 30 ATDC (on next event)
        } else if (num_cyl == 6) {
            // these triggers should give rpm but are fictional
            no_triggers = 3;
            trigger_teeth[0] = 23;
            trigger_teeth[1] = 1;
            trigger_teeth[2] = 13;
            trig_angs[0] = -300 + tmp_offset; // 30 ATDC (on next event)
            trig_angs[1] = -300 + tmp_offset; // 30 ATDC (on next event)
            trig_angs[2] = -300 + tmp_offset; // 30 ATDC (on next event)
        } else if (num_cyl == 8) {
            // these triggers should give rpm but are fictional
            trigger_teeth[0] = 17;
            trigger_teeth[1] = 26;
            trigger_teeth[2] = 1;
            trigger_teeth[3] = 10;
            trig_angs[0] = -300 + tmp_offset; // 30 ATDC (on next event)
            trig_angs[1] = -300 + tmp_offset; // 30 ATDC (on next event)
            trig_angs[2] = -300 + tmp_offset; // 30 ATDC (on next event)
            trig_angs[3] = -300 + tmp_offset; // 30 ATDC (on next event)
            no_triggers = 4;
        } else {
            conf_err = 1;
        }

        /* ----------------------  36-2-2-2 ------------------------*/

    } else if ((flash4.spk_mode & 0x1f) == 7) {
        no_teeth = 30;
        last_tooth = no_teeth;
        no_triggers = 2;
        deg_per_tooth[0] =  100;
        deg_per_tooth[1] =  100;
        deg_per_tooth[2] =  100;
        deg_per_tooth[3] =  100;
        deg_per_tooth[4] =  100;
        deg_per_tooth[5] =  100;
        deg_per_tooth[6] =  100;
        deg_per_tooth[7] =  100;
        deg_per_tooth[8] =  100;
        deg_per_tooth[9] =  100;
        deg_per_tooth[10] = 100;
        deg_per_tooth[11] = 100;
        deg_per_tooth[12] = 100;
        deg_per_tooth[13] = 100;
        deg_per_tooth[14] = 100;
        deg_per_tooth[15] = 300;
        //second 180deg
        deg_per_tooth[16] = 300;
        deg_per_tooth[17] = 100;
        deg_per_tooth[18] = 100;
        deg_per_tooth[19] = 100;
        deg_per_tooth[20] = 100;
        deg_per_tooth[21] = 100;
        deg_per_tooth[22] = 100;
        deg_per_tooth[23] = 100;
        deg_per_tooth[24] = 100;
        deg_per_tooth[25] = 100;
        deg_per_tooth[26] = 100;
        deg_per_tooth[27] = 100;
        deg_per_tooth[28] = 100;
        deg_per_tooth[29] = 300;

        smallest_tooth_crk = 100;
        smallest_tooth_cam = 0;

        //based on data from Ken, 1 is at 5BTDC
        trigger_teeth[0] = 20;
        trigger_teeth[1] = 6;
        trig_angs[0] = -150 + tmp_offset; // 15 ATDC
        trig_angs[1] = -150 + tmp_offset; // 15 ATDC

        /* ----------------------  Subaru 6/7 ------------------------*/

    } else if ((flash4.spk_mode & 0x1f) == 8) {
        flagbyte5 |= FLAGBYTE5_CAM;
        no_teeth = 6;  // for w/s
        last_tooth = no_teeth;
        no_triggers = 2;
        deg_per_tooth[0] =  320;
        deg_per_tooth[1] =  550;
        deg_per_tooth[2] =  930;
        deg_per_tooth[3] =  320;
        deg_per_tooth[4] =  550;
        deg_per_tooth[5] =  930;

        smallest_tooth_crk = 320;
        smallest_tooth_cam = 50; // (unsure)

        trigger_teeth[0] = 1;
        trigger_teeth[1] = 4;
        trig_angs[0] = -830 + tmp_offset; // 83 ATDC
        trig_angs[1] = -830 + tmp_offset; // 83 ATDC

        /* ----------------------  99-00 Miata  ------------------------*/
        // 4 on crank 1, 2 on cam
    } else if ((flash4.spk_mode & 0x1f) == 9) {
        flagbyte5 |= FLAGBYTE5_CAM;
        no_teeth = 8;
        last_tooth = no_teeth;
        no_triggers = 4;
        deg_per_tooth[0] =  700;
        deg_per_tooth[1] = 1100;
        deg_per_tooth[2] =  700;
        deg_per_tooth[3] = 1100;
        deg_per_tooth[4] =  700;
        deg_per_tooth[5] = 1100;
        deg_per_tooth[6] =  700;
        deg_per_tooth[7] = 1100;

        smallest_tooth_crk = 700;
        smallest_tooth_cam = 50; // (unsure)

        trigger_teeth[0] = 1;
        trigger_teeth[1] = 3;
        trigger_teeth[2] = 5;
        trigger_teeth[3] = 7;
        // no idea on this - need data
        trig_angs[0] = -1100 + tmp_offset; // 70 ATDC
        trig_angs[1] = -1100 + tmp_offset; // 70 ATDC
        trig_angs[2] = -1100 + tmp_offset; // 70 ATDC
        trig_angs[3] = -1100 + tmp_offset; // 70 ATDC
        if (num_cyl !=4) {
            conf_err = 18; // needs 4 cyl
        }

        /* ----------------------  Mitsubishi 6G72 ------------------------*/

    } else if ((flash4.spk_mode & 0x1f) == 10) {
        flagbyte5 |= FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH | FLAGBYTE5_CAM;
        no_teeth = 12;
        last_tooth = no_teeth;
        no_triggers = 6;
        deg_per_tooth[0] =  700;
        deg_per_tooth[1] =  500;
        deg_per_tooth[2] =  700;
        deg_per_tooth[3] =  500;
        deg_per_tooth[4] =  700;
        deg_per_tooth[5] =  500;
        deg_per_tooth[6] =  700;
        deg_per_tooth[7] =  500;
        deg_per_tooth[8] =  700;
        deg_per_tooth[9] =  500;
        deg_per_tooth[10] =  700;
        deg_per_tooth[11] =  500;

        smallest_tooth_crk = 500;
        smallest_tooth_cam = 400;

        trigger_teeth[0] = 1;
        trigger_teeth[1] = 3;
        trigger_teeth[2] = 5;
        trigger_teeth[3] = 7;
        trigger_teeth[4] = 9;
        trigger_teeth[5] = 11;
        trig_angs[0] = -450 + tmp_offset; // 45 ATDC
        trig_angs[1] = -450 + tmp_offset; // 45 ATDC
        trig_angs[2] = -450 + tmp_offset; // 45 ATDC
        trig_angs[3] = -450 + tmp_offset; // 45 ATDC
        trig_angs[4] = -450 + tmp_offset; // 45 ATDC
        trig_angs[5] = -450 + tmp_offset; // 45 ATDC
        if (num_cyl !=6) {
            conf_err = 19;
        }

        /* ----------------------  IAW Weber-Marelli ------------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 11) {
        flagbyte5 |= FLAGBYTE5_CAM;
        no_teeth = 8;
        last_tooth = no_teeth;
        no_triggers = 4;
        deg_per_tooth[0] =  900;
        deg_per_tooth[1] =  900;
        deg_per_tooth[2] =  900;
        deg_per_tooth[3] =  900;
        deg_per_tooth[4] =  900;
        deg_per_tooth[5] =  900;
        deg_per_tooth[6] =  900;
        deg_per_tooth[7] =  900;

        smallest_tooth_crk = 900;
        smallest_tooth_cam = 1800;

        trigger_teeth[0] = 1;
        trigger_teeth[1] = 3;
        trigger_teeth[2] = 5;
        trigger_teeth[3] = 7;

        trig_angs[0] = -950 + tmp_offset; // 95 ATDC - per forum feedback
        trig_angs[1] = -950 + tmp_offset; 
        trig_angs[2] = -950 + tmp_offset;
        trig_angs[3] = -950 + tmp_offset;
        if (num_cyl !=4) {
            conf_err = 24;
        }

        /* ----------------------  CAS 4/1 ------------------------*/
        // This slightly generic mode used for mitsi, Miata type wheels
        // Allows flexibility for user generated similar wheels.
    } else if ((flash4.spk_mode & 0x1f) == 12) {
        flagbyte5 |= FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH | FLAGBYTE5_CAM;
        no_teeth = 8;
        tmp_deg_per_tooth = (((unsigned int)7200 / (char)num_cyl)); // degx10 between main teeth
        if (tmp_deg_per_tooth != 1800) {
            conf_err = 1;
        }

        for (j = 1; j <= no_teeth; j++) {
            unsigned int jtmp1;
            if (j & 1) {   // these might be transposed
                jtmp1 = flash4.trigret_ang;  // main trigger -> return
            } else {
                jtmp1 = tmp_deg_per_tooth - flash4.trigret_ang; // return -> next main trigger
            }
            deg_per_tooth[j-1] = jtmp1;
        }

        if (tmp_deg_per_tooth < flash4.trigret_ang) {
            smallest_tooth_crk = tmp_deg_per_tooth;
        } else {
            smallest_tooth_crk = flash4.trigret_ang;
        }
        smallest_tooth_cam = 7200;

        // user enters angle of start of slot e.g. 10deg. Convert to ATDC
        trig_angs[0] = flash4.adv_offset - 1800;
        trig_angs[1] = flash4.adv_offset - 1800;
        trig_angs[2] = flash4.adv_offset - 1800;
        trig_angs[3] = flash4.adv_offset - 1800;

        goto com_cas;  // common section a little below
        /* ----------------------  4G63 ------------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 13) {
        flagbyte5 |= FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH | FLAGBYTE5_CAM;
        no_teeth = 8;

        deg_per_tooth[0] =  700;
        deg_per_tooth[1] = 1100;
        deg_per_tooth[2] =  700;
        deg_per_tooth[3] = 1100;
        deg_per_tooth[4] =  700;
        deg_per_tooth[5] = 1100;
        deg_per_tooth[6] =  700;
        deg_per_tooth[7] = 1100;

        smallest_tooth_crk = 700;
        smallest_tooth_cam = 3000;

        // user enters angle of start of slot e.g. 10deg. Convert to ATDC
        trig_angs[0] = -1030 + tmp_offset; // 103 ATDC (per md95)
        trig_angs[1] = -1030 + tmp_offset;
        trig_angs[2] = -1030 + tmp_offset;
        trig_angs[3] = -1030 + tmp_offset;
        if (num_cyl !=4) {
            conf_err = 18;
        }

com_cas:
        no_triggers = 4;
        last_tooth = no_teeth;
        trigger_teeth[0] = 1;
        trigger_teeth[1] = 3;
        trigger_teeth[2] = 5;
        trigger_teeth[3] = 7;

        /* ----------------------  twin trigger  ------------------------*/
        // two independant crank triggers (e.g. 4 cyl bike)
        // we'll feed them into one control routine though
    } else if ((flash4.spk_mode & 0x1f) == 14) {
        flagbyte5 |= FLAGBYTE5_CAM; // strange one this. Although cam IC is used, shares crank ISR
        no_teeth = 2;
        last_tooth = no_teeth;
        no_triggers = 2;
        if (flash4.ICIgnOption & 0x8) { // oddfire
            deg_per_tooth[0] =  flash4.OddFireang;
            deg_per_tooth[1] =  3600 - flash4.OddFireang;
            trig_angs[0] = flash4.adv_offset - flash4.OddFireang;
            trig_angs[1] = flash4.adv_offset - (3600 - flash4.OddFireang);
            if (flash4.OddFireang < (3600 - flash4.OddFireang)) {
                smallest_tooth_crk = flash4.OddFireang;
                smallest_tooth_cam = flash4.OddFireang;
            } else {
                smallest_tooth_crk = 3600 - flash4.OddFireang;
                smallest_tooth_cam = 3600 - flash4.OddFireang;
            }
        } else {
            smallest_tooth_crk = 1800;
            smallest_tooth_cam = 1800;

            deg_per_tooth[0] = 1800;
            deg_per_tooth[1] = 1800;
            trig_angs[0] = flash4.adv_offset - 1800;
            trig_angs[1] = flash4.adv_offset - 1800;
        }

        trigger_teeth[0] = 2;
        trigger_teeth[1] = 1;

        if ((num_cyl !=4) || ((flash4.spk_mode & 0xc0) != 0x40)) {
            conf_err = 29;
        }
        /* ----------------------  Chrysler 2.2/2.5 ------------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 15) {
        flagbyte5 |= FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH | FLAGBYTE5_CAM;
        no_teeth = 10;
        last_tooth = no_teeth;
        no_triggers = 4;
        deg_per_tooth[0] =  206;
        deg_per_tooth[1] = 1082;
        deg_per_tooth[2] =  718;
        deg_per_tooth[3] = 1082;
        deg_per_tooth[4] =  718;
        deg_per_tooth[5] = 1082;
        deg_per_tooth[6] =  718;
        deg_per_tooth[7] = 1082;
        deg_per_tooth[8] =  206;
        deg_per_tooth[9] =  306;

        smallest_tooth_crk = 206;
        smallest_tooth_cam = 206;

        trigger_teeth[0] = 3;
        trigger_teeth[1] = 5;
        trigger_teeth[2] = 7;
        trigger_teeth[3] = 9;
        // no idea on this
        trig_angs[0] = -982 + tmp_offset; // 98.2 ATDC - unit fires at 10BTDC during cranking, so asssume??
        trig_angs[1] = -982 + tmp_offset; // 98.2 ATDC
        trig_angs[2] = -982 + tmp_offset; // 98.2 ATDC
        trig_angs[3] = -982 + tmp_offset; // 98.2 ATDC
        if (num_cyl !=4) {
            conf_err = 17;
        }
        /* ----------------------  Renix 44-2-2 ------------------------*/

    } else if ((flash4.spk_mode & 0x1f) == 16) {
        no_teeth = 20;  // for single coil
        last_tooth = no_teeth;
        no_triggers = 1;
        deg_per_tooth[0] =  82; // bizarre 8.18 degrees per tooth??!
        deg_per_tooth[1] =  82;
        deg_per_tooth[2] =  82;
        deg_per_tooth[3] =  82;
        deg_per_tooth[4] =  82;
        deg_per_tooth[5] =  82;
        deg_per_tooth[6] =  82;
        deg_per_tooth[7] =  82;
        deg_per_tooth[8] =  82;
        deg_per_tooth[9] =  82;
        deg_per_tooth[10] =  82;
        deg_per_tooth[11] =  82;
        deg_per_tooth[12] =  82;
        deg_per_tooth[13] =  82;
        deg_per_tooth[14] =  82;
        deg_per_tooth[15] =  82;
        deg_per_tooth[16] =  82;
        deg_per_tooth[17] =  82;
        deg_per_tooth[18] =  82;
        deg_per_tooth[19] =  246; // double missing tooth = time * 3

        smallest_tooth_crk = 82;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 14;
        trig_angs[0] = -164 + tmp_offset; // 16.4 ATDC

        /* ----------------------  Suzuki swift ------------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 17) {
        no_teeth = 6;
        last_tooth = no_teeth;
        no_triggers = 2;
        deg_per_tooth[0] =  300;
        deg_per_tooth[1] =  550;
        deg_per_tooth[2] =  950;
        deg_per_tooth[3] =  300;
        deg_per_tooth[4] =  550;
        deg_per_tooth[5] =  950;

        smallest_tooth_crk = 300;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 1;
        trigger_teeth[1] = 4;
        trig_angs[0] = -890 + tmp_offset; // 89 ATDC
        trig_angs[1] = -890 + tmp_offset; // 89 ATDC
        if (num_cyl !=4) {
            conf_err = 23;
        }

        /* ----------------------  Suzuki Vitara 2.0 ------------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 18) {
        no_teeth = 11;
        last_tooth = no_teeth;
        no_triggers = 4;
        deg_per_tooth[0] =  700;
        deg_per_tooth[1] =  300;
        deg_per_tooth[2] =  800;
        deg_per_tooth[3] =  700;
        deg_per_tooth[4] =  800;
        deg_per_tooth[5] =  300;
        deg_per_tooth[6] =  700;
        deg_per_tooth[7] = 1100;
        deg_per_tooth[8] =  700;
        deg_per_tooth[9] =  800;
        deg_per_tooth[10]=  300;

        smallest_tooth_crk = 300;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 4;
        trigger_teeth[1] = 7;
        trigger_teeth[2] = 9;
        trigger_teeth[3] = 1;
        trig_angs[0] = -1100 + tmp_offset; // 90 ATDC
        trig_angs[1] = -1100 + tmp_offset; // 90 ATDC
        trig_angs[2] = -1100 + tmp_offset; // 90 ATDC
        trig_angs[3] = -1100 + tmp_offset; // 90 ATDC
        if (num_cyl !=4) {
            conf_err = 22;
        }

        /* ----------------------  Daihatsu 3cyl ------------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 19) {
        no_teeth = 4;
        last_tooth = no_teeth;
        no_triggers = 3;
        deg_per_tooth[0] = 2100;
        deg_per_tooth[1] = 2400;
        deg_per_tooth[2] = 2400;
        deg_per_tooth[3] =  300;

        smallest_tooth_crk = 300;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 3;
        trigger_teeth[1] = 4;
        trigger_teeth[2] = 2;
        trig_angs[0] = -2400 + tmp_offset; // 240 ATDC
        trig_angs[1] = -2400 + tmp_offset; // 240 ATDC
        trig_angs[2] = -2400 + tmp_offset; // 240 ATDC
        if (num_cyl !=3) {
            conf_err = 20;
        }

        /* ----------------------  Daihatsu 4cyl ------------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 20) {
        no_teeth = 5;
        last_tooth = no_teeth;
        no_triggers = 4;
        deg_per_tooth[0] = 1500;
        deg_per_tooth[1] = 1800;
        deg_per_tooth[2] = 1800;
        deg_per_tooth[3] = 1800;
        deg_per_tooth[4] =  300;

        smallest_tooth_crk = 300;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 3;
        trigger_teeth[1] = 4;
        trigger_teeth[2] = 5;
        trigger_teeth[3] = 2;
        trig_angs[0] = -1800 + tmp_offset; // 180 ATDC
        trig_angs[1] = -1800 + tmp_offset; // 180 ATDC
        trig_angs[2] = -1800 + tmp_offset; // 180 ATDC
        trig_angs[3] = -1800 + tmp_offset; // 180 ATDC
        if (num_cyl !=4) {
            conf_err = 21;
        }

        /* ----------------------  Honda VTR1000 V-twin ------------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 21) {
        // runs in wasted spark at the moment using only crank sensor
        // user must set "odd fire" to get stable rpms
        no_teeth = 9;
        last_tooth = no_teeth;
        no_triggers = 2;
        deg_per_tooth[0] = 300;
        deg_per_tooth[1] = 300;
        deg_per_tooth[2] = 300;
        deg_per_tooth[3] = 300;
        deg_per_tooth[4] = 300;
        deg_per_tooth[5] = 300;
        deg_per_tooth[6] = 300;
        deg_per_tooth[7] = 300;
        deg_per_tooth[8] =1200; // 3 missing teeth = 4 x 30deg

        smallest_tooth_crk = 300;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 1;
        trigger_teeth[1] = 7;
        trig_angs[0] = -1200 + tmp_offset; // front cyl TDC is tooth no. 9 
        trig_angs[1] =  -600 + tmp_offset; // rear  cyl TDC is tooth no. 6

        if ( /*(num_cyl !=2 ) || */(!(flash4.ICIgnOption & 0x08)) || ((flash4.spk_mode & 0xc0) != 0x40) ) {
            conf_err = 34; // error if not 2 cyl OR not oddfire OR not wasted spark
        }

        /* ----------------------  Rover 36-1-1 ------------------------*/

    } else if ((flash4.spk_mode & 0x1f) == 22) {
        no_teeth = 17;  // for single coil
        last_tooth = no_teeth;
        no_triggers = 1;
        deg_per_tooth[0] =  100;
        deg_per_tooth[1] =  100;
        deg_per_tooth[2] =  100;
        deg_per_tooth[3] =  100;
        deg_per_tooth[4] =  100;
        deg_per_tooth[5] =  100;
        deg_per_tooth[6] =  100;
        deg_per_tooth[7] =  100;
        deg_per_tooth[8] =  100;
        deg_per_tooth[9] =  100;
        deg_per_tooth[10] =  100;
        deg_per_tooth[11] =  100;
        deg_per_tooth[12] =  100;
        deg_per_tooth[13] =  100;
        deg_per_tooth[14] =  100;
        deg_per_tooth[15] =  100;
        deg_per_tooth[16] =  200;

        smallest_tooth_crk = 100;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 1;
        trig_angs[0] = -100 + tmp_offset; // to be determined 
        if ((num_cyl !=4) || ((flash4.spk_mode & 0xc0) == 0x40)) {
            conf_err = 35;
        }

        /* ----------------------  Rover 36-1-1-1-1 type '2' (EU3) --------------------*/
        // this one has 2 and 3 teeth between the gaps
    } else if ((flash4.spk_mode & 0x1f) == 23) {
        deg_per_tooth[0] =   100;
        deg_per_tooth[1] =   100;
        deg_per_tooth[2] =   100;
        deg_per_tooth[3] =   100;
        deg_per_tooth[4] =   100;
        deg_per_tooth[5] =   100;
        deg_per_tooth[6] =   100;
        deg_per_tooth[7] =   100;
        deg_per_tooth[8] =   100;
        deg_per_tooth[9] =   100;
        deg_per_tooth[10] =  100;
        deg_per_tooth[11] =  100;
        deg_per_tooth[12] =  100;
        deg_per_tooth[13] =  200;
        deg_per_tooth[14] =  100;
        deg_per_tooth[15] =  100;
        deg_per_tooth[16] =  200;
        deg_per_tooth[17] =  100;
        deg_per_tooth[18] =  100;
        deg_per_tooth[19] =  100;
        deg_per_tooth[20] =  100;
        deg_per_tooth[21] =  100;
        deg_per_tooth[22] =  100;
        deg_per_tooth[23] =  100;
        deg_per_tooth[24] =  100;
        deg_per_tooth[25] =  100;
        deg_per_tooth[26] =  100;
        deg_per_tooth[27] =  100;
        deg_per_tooth[28] =  100;
        deg_per_tooth[29] =  200;
        deg_per_tooth[30] =  100;
        deg_per_tooth[31] =  200;

        smallest_tooth_crk = 100;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 28; // changed from 29 per JB
        trig_angs[0] = -100 + tmp_offset; // to be confirmed
        trig_angs[1] = -100 + tmp_offset; // to be confirmed 

        if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) { // COP or use-cam
            flagbyte5 |= FLAGBYTE5_CAM;
            deg_per_tooth[32] =  100;
            deg_per_tooth[33] =  100;
            deg_per_tooth[34] =  100;
            deg_per_tooth[35] =  100;
            deg_per_tooth[36] =  100;
            deg_per_tooth[37] =  100;
            deg_per_tooth[38] =  100;
            deg_per_tooth[39] =  100;
            deg_per_tooth[40] =  100;
            deg_per_tooth[41] =  100;
            deg_per_tooth[42] =  100;
            deg_per_tooth[43] =  100;
            deg_per_tooth[44] =  100;
            deg_per_tooth[45] =  200;
            deg_per_tooth[46] =  100;
            deg_per_tooth[47] =  100;
            deg_per_tooth[48] =  200;
            deg_per_tooth[49] =  100;
            deg_per_tooth[50] =  100;
            deg_per_tooth[51] =  100;
            deg_per_tooth[52] =  100;
            deg_per_tooth[53] =  100;
            deg_per_tooth[54] =  100;
            deg_per_tooth[55] =  100;
            deg_per_tooth[56] =  100;
            deg_per_tooth[57] =  100;
            deg_per_tooth[58] =  100;
            deg_per_tooth[59] =  100;
            deg_per_tooth[60] =  100;
            deg_per_tooth[61] =  200;
            deg_per_tooth[62] =  100;
            deg_per_tooth[63] =  200;

            trigger_teeth[1] = 44;
            trigger_teeth[2] = 60;
            trigger_teeth[3] = 12;
            no_teeth = 64;  // using cam signal
            no_triggers = 4;
        } else {
            no_teeth = 32;  // for single coil or wasted spark
            no_triggers = 2;
            trigger_teeth[1] = 12;
        }
        last_tooth = no_teeth;

        if (num_cyl !=4) {
            conf_err = 17;
        }

        /* ----------------------  Rover 36-1-1-1-1 type '3' (??) --------------------*/
        // this one has 4 and 5 teeth between the gaps
    } else if ((flash4.spk_mode & 0x1f) == 24) {
        no_teeth = 32;  // for single coil or wasted spark
        last_tooth = no_teeth;
        no_triggers = 2;
        deg_per_tooth[0] =   100;
        deg_per_tooth[1] =   100;
        deg_per_tooth[2] =   100;
        deg_per_tooth[3] =   100;
        deg_per_tooth[4] =   100;
        deg_per_tooth[5] =   100;
        deg_per_tooth[6] =   100;
        deg_per_tooth[7] =   100;
        deg_per_tooth[8] =   100;
        deg_per_tooth[9] =   100;
        deg_per_tooth[10] =  200;
        deg_per_tooth[11] =  100;
        deg_per_tooth[12] =  100;
        deg_per_tooth[13] =  100;
        deg_per_tooth[14] =  100;
        deg_per_tooth[15] =  200;
        deg_per_tooth[16] =  100;
        deg_per_tooth[17] =  100;
        deg_per_tooth[18] =  100;
        deg_per_tooth[19] =  100;
        deg_per_tooth[20] =  100;
        deg_per_tooth[21] =  100;
        deg_per_tooth[22] =  100;
        deg_per_tooth[23] =  100;
        deg_per_tooth[24] =  100;
        deg_per_tooth[25] =  100;
        deg_per_tooth[26] =  100;
        deg_per_tooth[27] =  200;
        deg_per_tooth[28] =  100;
        deg_per_tooth[29] =  100;
        deg_per_tooth[30] =  100;
        deg_per_tooth[31] =  200;

        smallest_tooth_crk = 100;
        smallest_tooth_cam = 0;

        trigger_teeth[0] = 6;
        trigger_teeth[1] = 23;
        trig_angs[0] = -100 + tmp_offset; // to be determined 
        trig_angs[1] = -100 + tmp_offset; // to be determined 
        if (num_cyl !=4) {
            conf_err = 17;
        }

        /* ----------------------  GM 7X reluctor natively --------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 25) {
        no_teeth = 7;  // for single coil or wasted spark
        last_tooth = no_teeth;
        deg_per_tooth[0] =   600;
        deg_per_tooth[1] =   600;
        deg_per_tooth[2] =   600;
        deg_per_tooth[3] =   600;
        deg_per_tooth[4] =   600;
        deg_per_tooth[5] =   100;
        deg_per_tooth[6] =   500;

        smallest_tooth_crk = 100;
        smallest_tooth_cam = 0;

        if (num_cyl == 4) {
            no_triggers = 2;
            trigger_teeth[0] = 6;
            trigger_teeth[1] = 3;
            trig_angs[0] = -450 + tmp_offset;
            trig_angs[1] = -450 + tmp_offset; 
        } else if (num_cyl == 6) {
            no_triggers = 3;
            trigger_teeth[0] = 5;
            trigger_teeth[1] = 1;
            trigger_teeth[2] = 3;
            trig_angs[0] = -450 + tmp_offset;
            trig_angs[1] = -450 + tmp_offset;
            trig_angs[2] = -450 + tmp_offset;
        } else { 
           conf_err = 1;
        }

        /* ----------------------  Nissan CAS --------------------*/
 /* should be able to share a lot of code with Optispark, hence having adjacent numbers
    } else if ((flash4.spk_mode & 0x1f) == 26) { */ 
// Nissan also uses mode 27
        /* ----------------------  GM Optispark (incomplete)--------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 28) {
        flagbyte5 |= FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH | FLAGBYTE5_CAM;
        no_teeth = 8;  // for single coil or wasted spark (or COP on MS3)
        last_tooth = no_teeth;
        deg_per_tooth[0] =   900;
        deg_per_tooth[1] =   900;
        deg_per_tooth[2] =   900;
        deg_per_tooth[3] =   900;
        deg_per_tooth[4] =   900;
        deg_per_tooth[5] =   900;
        deg_per_tooth[6] =   900;
        deg_per_tooth[7] =   900;

        smallest_tooth_crk = 900;
        smallest_tooth_cam = 2;

        no_triggers = 8;
        trigger_teeth[0] = 1;
        trigger_teeth[1] = 2;
        trigger_teeth[2] = 3;
        trigger_teeth[3] = 4;
        trigger_teeth[4] = 5;
        trigger_teeth[5] = 6;
        trigger_teeth[6] = 7;
        trigger_teeth[7] = 8;
        trig_angs[0] = -100 + tmp_offset;
        trig_angs[1] = -100 + tmp_offset; 
        trig_angs[2] = -100 + tmp_offset;
        trig_angs[3] = -100 + tmp_offset; 
        trig_angs[4] = -100 + tmp_offset;
        trig_angs[5] = -100 + tmp_offset; 
        trig_angs[6] = -100 + tmp_offset;
        trig_angs[7] = -100 + tmp_offset; 

        /* ----------------------  Honda RC-51  --------------------*/
    } else if ((flash4.spk_mode & 0x1f) == 29) {
        flagbyte5 |= FLAGBYTE5_CAM;
        no_teeth = 24; 
        last_tooth = no_teeth;
        deg_per_tooth[0] =   150;
        deg_per_tooth[1] =   150;
        deg_per_tooth[2] =   150;
        deg_per_tooth[3] =   150;
        deg_per_tooth[4] =   150;
        deg_per_tooth[5] =   150;
        deg_per_tooth[6] =   150;
        deg_per_tooth[7] =   150;
        deg_per_tooth[8] =   150;
        deg_per_tooth[9] =   150;
        deg_per_tooth[10] =  150;
        deg_per_tooth[11] =  150;
        deg_per_tooth[12] =  150;
        deg_per_tooth[13] =  150;
        deg_per_tooth[14] =  150;
        deg_per_tooth[15] =  150;
        deg_per_tooth[16] =  150;
        deg_per_tooth[17] =  150;
        deg_per_tooth[18] =  150;
        deg_per_tooth[19] =  150;
        deg_per_tooth[20] =  150;
        deg_per_tooth[21] =  150;
        deg_per_tooth[22] =  150;
        deg_per_tooth[23] =  150;

        smallest_tooth_crk = 150;
        smallest_tooth_cam = 300;

        no_triggers = 2;
        trigger_teeth[0] = 2;
        trigger_teeth[1] = 11;
        trig_angs[0] = -150 + tmp_offset;
        trig_angs[1] = -150 + tmp_offset; 

        if (!(flash4.ICIgnOption & 0x8)) {
            conf_err = 41; // oddfire required
        } 

    } else { // dizzy or wheel
        char odd_trig_tooth_offset = 0;
        int odd_trig_ang = 0;
        unsigned char err_count;

        /* ----------------------  DIZZY MODE or Fuel only ------------------------*/
        if (((flash4.spk_mode & 0x1e) == 2) || ((flash4.spk_mode & 0x1f) == 31)) { // dizzy (options 2,3) + fuel only
            if (num_cyl & 1) {
                no_triggers = num_cyl;  // (for 3, 5 cyl)
            } else {
                no_triggers = num_cyl >> 1; // even no. cylinders
            }

            trig_ang = flash4.adv_offset;

            /*********** trigger return (even) dizzy ****************/
            if ((flash4.spk_mode & 0x1f) == 3) {
                flagbyte5 |= FLAGBYTE5_CRK_DOUBLE | FLAGBYTE5_CRK_BOTH;
                no_teeth = no_triggers<<1; // ok up to 5cyl with 10 trigger points
                last_tooth = no_teeth;
                tmp_deg_per_tooth = (((unsigned int)7200 / (char)num_cyl)); // degx10 between main teeth
                for (j = 1; j <= no_teeth; j++) {
                    unsigned int jtmp1;
                    if (j & 1) {   // these might be transposed
                        jtmp1 = flash4.trigret_ang;  // main trigger -> return
                    } else {
                        jtmp1 = tmp_deg_per_tooth - flash4.trigret_ang; // return -> next main trigger
                    }
                    deg_per_tooth[j-1] = jtmp1;
                }

                teeth_per_trig = 2;

                if (flash4.trigret_ang < (tmp_deg_per_tooth - flash4.trigret_ang)) {
                    smallest_tooth_crk = flash4.trigret_ang;
                } else {
                    smallest_tooth_crk = tmp_deg_per_tooth - flash4.trigret_ang;
                }
                smallest_tooth_cam = 0;

                /*********** oddfire dizzy (trigret not allowed) ********/
            } else if ((flash4.ICIgnOption & 0x8) && ((flash4.spk_mode & 0x1f) == 2)) {
                no_triggers = num_cyl; // oddfire needs to trigger on each one
                no_teeth = no_triggers;
                last_tooth = no_teeth;
                tmp_deg_per_tooth = (((unsigned int)14400 / (char)num_cyl)); // degx10 between tooth 1 & 3
                for (j = 1; j <= no_teeth; j++) {
                    unsigned int jtmp1;
                    if (j & 1) {   // these might be transposed
                        jtmp1 = flash4.OddFireang; // short gap
                    } else {
                        jtmp1 = tmp_deg_per_tooth - flash4.OddFireang; // long gap
                    }
                    deg_per_tooth[j-1] = jtmp1;
                }

                teeth_per_trig = 1;

                if (flash4.OddFireang < (tmp_deg_per_tooth - flash4.OddFireang)) {
                    smallest_tooth_crk = flash4.OddFireang;
                } else {
                    smallest_tooth_crk = tmp_deg_per_tooth - flash4.OddFireang;
                }
                smallest_tooth_cam = 0;

                /*********** oddfire fuel only ***********/
            } else if ((flash4.ICIgnOption & 0x8) && ((flash4.spk_mode & 0x1f) == 2)) {
                smallest_tooth_crk = flash4.OddFireang;
                smallest_tooth_cam = 0;
                tmp_deg_per_tooth = (((unsigned int)14400 / (char)num_cyl)); // degx10 between tooth 1 & 3
                teeth_per_trig = 1;

                /*********** non- trigger return (even) dizzy ***********/
            } else {
                no_teeth = no_triggers;
                last_tooth = no_triggers;

                tmp_deg_per_tooth = (((unsigned int)7200 / (char)num_cyl));
                for (j = 1; j <= no_triggers; j++) {
                    deg_per_tooth[j-1] = tmp_deg_per_tooth;
                }
                teeth_per_trig = 1;

                smallest_tooth_crk = tmp_deg_per_tooth;
                smallest_tooth_cam = 0;

            }
            /* ----------------------  EVEN WHEEL MODE ------------------------*/
        } else {     // real wheel mode
            
            if ( ((flash4.spk_mode & 0xc0) == 0x80) // COP selected 
                    || ((flash4.spk_config & 0x0c) == 0x0c) //  or 2nd trig+missing
                    || ( ((flash4.spk_config & 0x0c) == 0x04) && (flash4.spk_config & 0x02) ) //  or cam speed missing tooth wheel
                    || ( ((flash4.spk_config & 0x0c) == 0x08) &&  (!(flash4.spk_config & 0x40)) ) //  or non missing dual wheel with cam speed 2nd trig
               ) {
                no_triggers = num_cyl; // same triggers as COP i.e. cover 720 crank degrees
            } else {
                no_triggers = num_cyl >> 1; // triggers cover 360 crank degrees all larger engines
            }
            // we also need to calc the no. teeth we see - do this a little lower

            // check COP validity
            if ((flash4.spk_mode & 0xc0) == 0x80) {  // if COP
                if ( ((flash4.spk_config & 0xc) == 0x8) && (flash4.spk_config & 0x40) ) {
                    conf_err = 32; // dual wheel and COP not allowed with only crank speed 2nd trigger (no phase info)
                } else if ( ((flash4.spk_config & 0xc) == 0x4) && ((flash4.spk_config & 2) == 0) ) {
                    conf_err = 38; // single wheel and COP not allowed at crank speed (no phase info)
                }
            }

            // using cam ?
            if ((flash4.spk_config & 0x08) == 0x08) { // dual wheel or 2nd trig+missing
                flagbyte5 |= FLAGBYTE5_CAM;
                if ((flash4.spk_config & 0x60) == 0x60) { // rising and falling
                        flagbyte5 |= FLAGBYTE5_CAM_DOUBLE | FLAGBYTE5_CAM_BOTH;
                }
            }

            /* Now figure out how many degrees there are per tooth */
            /* only for even wheels, for uneven use special mode*/

            //	    if(flash4.spk_config & 0x02) { // cam or crank speed
            //		tmp_deg_per_tooth = (unsigned int)(((unsigned int)7200 / (unsigned char)flash4.No_Teeth));
            //	    } else {
            //		tmp_deg_per_tooth = (unsigned int)(((unsigned int)3600 / (unsigned char)flash4.No_Teeth));
            //	    }

            // Do selective division and check remainder for config error

            __asm__ __volatile__ (
                    "ldd  %1\n"
                    "cpd  #127\n"
                    "bhi  tdptno\n"
                    "tfr   d,x\n"
                    "brclr %2, #0x2, tdptcam\n"
                    "ldd   #7200\n"
                    "bra   tdptcom\n"
                    "tdptcam:\n"
                    "ldd   #3600\n"
                    "tdptcom:\n"
                    "idiv\n"
                    "tbeq d, tdptok\n"
                    "tdptno:\n"
                    "movb #1,%3\n"
                    "tdptok:\n"
                    : "=x" (tmp_deg_per_tooth)
                    : "m" (flash4.No_Teeth),
                    "m" (flash4.spk_config),
                    "m" (conf_err)
                    );

            trig_ang = flash4.Miss_ang + tmp_offset;

            if ((flash4.spk_config & 0xc) == 0x8) {  // dual wheel
                if (flash4.spk_config & 0x02) {      // cam speed
                    if ((flash4.spk_config & 0x40) == 0x40) {
                        no_teeth = flash4.No_Teeth >> 1;  //  2nd trig every crank rev
                    } else {
                        no_teeth = flash4.No_Teeth; // 2nd trig every cam rev
                    }
                } else {                             // crank speed
                    if ((flash4.spk_config & 0x40) == 0x40) {
                        no_teeth = flash4.No_Teeth;  //  2nd trig every crank rev
                    } else {
                        no_teeth = flash4.No_Teeth << 1; // 2nd trig every cam rev
                    }
                }
                miss_teeth = 0;
            } else {
                if ((flash4.spk_config & 0xc) == 0xc) {
                    /* missing + extra */
                    no_teeth = flash4.No_Teeth << 1;
                } else {
                    no_teeth = flash4.No_Teeth;
                }
                miss_teeth = flash4.No_Miss_Teeth;
            }

            teeth_per_trig = no_teeth / no_triggers;
            if (no_teeth % no_triggers) {
                conf_err = 1;
            }

            // store degrees per tooth
            if ((flash4.spk_config & 0x0c) == 0x08) {
                last_tooth = no_teeth;  // if 2nd trig only then ignore missing teeth field

                /* Fill in array of tooth sizes for even wheels*/
                for (j = 1; j <= no_teeth ; j++) {
                    deg_per_tooth[j-1] = tmp_deg_per_tooth;
                }

            } else {
                mid_last_tooth = flash4.No_Teeth - flash4.No_Miss_Teeth;
                last_tooth = no_teeth - flash4.No_Miss_Teeth;

                /* Fill in array of tooth sizes for even wheels*/
                for (j = 1; j <= mid_last_tooth ; j++) {
                    deg_per_tooth[j-1] = tmp_deg_per_tooth;
                }
                deg_per_tooth[mid_last_tooth -1] = tmp_deg_per_tooth * (1+flash4.No_Miss_Teeth);
                deg_per_tooth[mid_last_tooth ] = 0; // tooth doesn't exist

                if (no_teeth != flash4.No_Teeth) {
                    // must be 2nd + missing, go around again
                    for (j = flash4.No_Teeth+1; j <= last_tooth ; j++) {
                        deg_per_tooth[j-1] = tmp_deg_per_tooth;
                    }
                    deg_per_tooth[last_tooth -1] = tmp_deg_per_tooth * (1+flash4.No_Miss_Teeth);
                }
            }
        }
        // common to dizzy and wheel - setup trigger teeth
        /* figure out trigger angle... get as close to -10 as possible.
         * calcs will count back from this tooth to get spark/dwell
         */


        trig_tooth = 1;
        while (trig_ang > -100) {  // 10ATDC
            trig_ang -= deg_per_tooth[trig_tooth-1];
            trig_tooth++;
        }

        if (flash4.ICIgnOption & 0x8) { // oddfire
            odd_trig_tooth_offset = trig_tooth;
            odd_trig_ang = trig_ang + flash4.OddFireang;

            while (odd_trig_ang > -100) {  // 10ATDC
                odd_trig_ang -= deg_per_tooth[odd_trig_tooth_offset-1];
                odd_trig_tooth_offset++;
            }
            odd_trig_tooth_offset -= trig_tooth;
        }

        /* at this point I have my 1st trigger tooth, and my trigger angle,
         * so I'll go ahead and set the rest of my trigger teeth
         */

        err_count = 0;

WHEEL_TOOTH_CALC:
        trig_missing = 0;

        for (j = 0; j < no_triggers; j++) {
            if ((j & 1) && (flash4.ICIgnOption & 0x8) && (!(flash4.spk_conf2 & 0x10))) { // oddfire alternating
				if ((flash4.spk_mode & 0x1f) == 2) { // oddfire dizzy
                    trig_angs[j] = trig_ang + deg_per_tooth[0] - deg_per_tooth[1]; // this is the odd short period
                    trigger_teeth[j] = trig_tooth;
                } else { // oddfire on an even wheel
                    trig_angs[j] = odd_trig_ang;
                    trigger_teeth[j] = trig_tooth - teeth_per_trig + odd_trig_tooth_offset;
                }
            } else if ((j & 2) && (flash4.ICIgnOption & 0x8) && (flash4.spk_conf2 & 0x10)) { // oddfire paired
                // for V-max or similar where two cylinders are paired and offset. This applies to cyl3+4
                    trig_angs[j] = odd_trig_ang;
                    trigger_teeth[j] = trig_tooth - teeth_per_trig + odd_trig_tooth_offset;
            } else {
                trig_angs[j] = trig_ang;
                trigger_teeth[j] = trig_tooth;
            }
            trig_tooth += teeth_per_trig;
            if (((flash4.spk_config & 0xc) == 0xc) && ((flash4.spk_mode & 0x1f)==4)) { // even wheel
                if ((trig_tooth > mid_last_tooth) &&
                        trig_tooth <= flash4.No_Teeth) {
                    trig_missing = flash4.No_Teeth - trig_tooth;
                }
            }
            if ((trig_tooth > last_tooth) &&
                    trig_tooth <= no_teeth) {
                /* not good, need to adjust all teeth... set a flag
                 * to tell us to do that later
                 */
                trig_missing = no_teeth - trig_tooth + 1;
            } else if (trig_tooth > no_teeth) {
                trig_tooth -= no_teeth;
            }
        }

        if (trig_missing) {
            err_count++;
            if (err_count > flash4.No_Teeth) {
                conf_err = 25; // failed to calc teeth
                return;
            }
            trig_ang -= (tmp_deg_per_tooth * trig_missing);
            trig_tooth++;
            if (trig_tooth > flash4.No_Teeth) {
                trig_tooth = 1;
            }
            goto WHEEL_TOOTH_CALC; // try again
        }

        smallest_tooth_crk = tmp_deg_per_tooth;
        if (flash4.spk_config & 0x08) { // dual or dual+missing
            if (flash4.spk_config & 0x40) {
                smallest_tooth_cam = 3600; // crank speed
            } else {
                smallest_tooth_cam = 7200; // cam speed
            }
        } 
    }  // end real wheel mode

    // fill in rest of array with zeros
    for (j = no_teeth ; j < MAXNUMTEETH ; j++) {
        deg_per_tooth[j] = 0;
    }

    if (flash10.feature3 & 0x08) {
        tooth_init = trigger_teeth[flash10.trig_init - 1];
    }

}
