/* $Id: ms2_extra_ign_in.c,v 1.101.6.105 2009/06/23 00:27:27 culverk Exp $ */
#include "ms2_extra.h"

// fire/dwell coils and syncfirst now in ign.c and section text

INTERRUPT void ISR_Ign_TimerIn(void)
{
    static unsigned long dt2,dt3;
    static unsigned long tooth_time1, tooth_time2;
    long ddt2,ddt3;
    static unsigned long dtpred_old;
    static char missed_pulse;
    unsigned int sched_both, TC0this;
    unsigned long ltmp1;
    long coil_dur_calc = 0;
    unsigned char thistoothevents = 0, next, edge, edge2, portt_save, spkmode=0;
    unsigned long temp1, TC0_32bits;
    static unsigned int swtimer_last;
    static unsigned long NoiseFilter1;
    static unsigned char tmp_coil;

#define SPARK 0x1
#define DWELL 0x2
#define FUEL 0x4
#define ROTARY_SPK 0x8
#define ROTARY_DWL 0x10
    if (flagbyte2 & flagbyte2_twintrignow) {  // use TC5/2 data for 2nd trig
        TC0this = TC_trig2;
//        flagbyte2 &= ~flagbyte2_twintrignow; // moved to lower down
        flagbyte4 |= flagbyte4_tach2;
    } else { // normal use this IC timer
        TFLG1 = 0x01;	             // clear IC interrupt flag
        TIE |= 0x01;		     // re-enable IC interrupt
        TC0this = TC0;
        flagbyte4 &= ~flagbyte4_tach2;
    }

    portt_save = PORTT;   // grab it asap to ensure it doesn't change

    // if we triggered a config error then stop! No running, report false data
    // in test mode we ignore IC ISR as well
    if ((conf_err) || (flagbyte1 & flagbyte1_tstmode)) {
        return;
    }

    TC0_32bits = ((unsigned long)swtimer<<16) | TC0this;
    if ((flagbyte1 & flagbyte1_ovfclose) && ((TC0this < 0x1000) ||
                ((TC0this < TC0_last) && (swtimer == swtimer_last)))) {
        TC0_32bits += 0x10000;
    }

    TC0_last = TC0this;
    swtimer_last = swtimer;

    //Figure out which edge of input signal we are on if rising and falling enabled
    edge = 1;
    edge2 = 1; // doesn't get reset if single edge trigger on primary
    /* first figure out which edge we care about right now */
    // used by noise filter, dizzy with trigret and some spark modes
    if (flagbyte5 & FLAGBYTE5_CRK_BOTH) {
        if (flash4.ICIgnOption & 0x01) {
            if (!(portt_save & 0x01)) {
                /* this wasn't rise, don't store current timecounter value */
                edge = 0;
            }
            if (!(portt_save & TFLG_trig2)) {
                edge2 = 0;
            }
        } else {
            if (portt_save & 0x01) {
                /* This wasn't the falling edge, don't store timecounter value */
                edge = 0;
            }
            if (portt_save & TFLG_trig2) {
                edge2 = 0;
            }
        }
        // Ignition trigger LED, only works at present if using both edges
        if (flagbyte1 & flagbyte1_igntrig) {
            if (edge) {
                PTM |= 0x20; // D15
            } else {
                PTM &= ~0x20;
            }
        }
    }

// composite tooth logger - captures everything including noise
// logs are in comms page 0xf2, data actually stored in ram_data
// consists of 341 * 3 byte packets in the 1024 byte space
// 1024th byte (ramdata+0x3ff) now stores the logger format version.
// Hardcoded here AND in the isr_ign version of this code!


    if (flagbyte0 & flagbyte0_complog) {
        do_complog_pri(TC0_32bits); // re-written in assembler because gcc makes SUCH A MESS of it
        IC_last = TC0_32bits;
    }


    if (pulse_no == 0)  {  // 1st input pulse
        pulse_no++;
        if (flash4.no_skip_pulses > 0) {
            tooth_no = flash4.no_skip_pulses - 1; // start down count of skip pulses
        } else {
            tooth_no = 0;
        }
        dt2 = 0;
        dt3 = 0;       // time difference between pulses, us
        outpc.dt3 = (int)dt3;				// for HP calculations
        ddt2 = 0;      // derivative of time difference
        ddt3 = 0;      // derivative of time difference
        dtpred = dt3;  // predicted time difference for next pulse
        missed_pulse = 0;
        tooth_time1 = TC0_32bits;
        tooth_time2 = 0;
        tooth_diff_this = 0;
        tooth_diff_last = 0;
        tooth_diff_last_1 = 0;
        tooth_diff_last_2 = 0;
        fuel_cntr = 0;
        firstsync_iter = 0;
        flagbyte4 &= ~flagbyte4_found_miss;
        flagbyte0 &= ~flagbyte0_foundfirst;
        NoiseFilter1 = 0;
        t_enable_IC = 0xFFFFFFFF;
        EAElagcomp_squirts = 0;
        EAElag_squirting = 0;
        return;
    }

    /* The sequence for noise filtering is as follows (all can be enabled/disabled)
     * 1. if crank tach masking is enabled, we might not even have reached this ISR
     * (composite tooth logger happens here)
     * 2. noise filter
     * 3. if noise filter off, polarity check
     * 4. crank period filtering
     * (basic tooth logger happens here)
     */

    /* Noise filter */
    if (flagbyte1 & flagbyte1_noisefilter) {
        if (!(flagbyte0 & flagbyte0_foundfirst)) {
            if (edge == 0) { /* We want to store the edge on the opposite one from the trigger */
                NoiseFilter1 = TC0_32bits;
            } else {
                return;
            }

            flagbyte0 |= flagbyte0_foundfirst;
            return;
        } else {
            /* This edge should be the opposite edge that we saw previously...
             * DON'T just use it! Check the polarity
             */
            if (edge == 0) {
                return; // must be noise - same edge as last time
            }

            flagbyte0 &= ~flagbyte0_foundfirst;

            if (outpc.rpm > 10) {
                if ((TC0_32bits - NoiseFilter1) < NoiseFilterMin) {
                    if (flash8.feature413 & 1) {
                        outpc.gpioadc[6] += 0x100; // debug
                    }
                    return;
                }
            }
        }
    /* or Polarity check (can't presently have both) */
    /* intentionally read from PORTT instead of portt_save, to allow a slight delay */
    } else if (flagbyte1 & flagbyte1_polarity) {
        if (flagbyte2 & flagbyte2_twintrignow) { // actually came from second trig
            if (flash4.ICIgnOption & 0x01) { // rising IC
                if ((PORTT & TFLG_trig2) == 0) { // but is actually low!
                    return; // bail out
                }
            } else { // falling edge
                if (PORTT & TFLG_trig2) { // but is actually high!
                    return; // bail out
                }
            }   
        } else { // normal
            if (flash4.ICIgnOption & 0x01) { // rising IC
                if ((PORTT & 0x01) == 0) { // but is actually low!
                    return; // bail out
                }
            } else { // falling edge
                if (PORTT & 0x01) { // but is actually high!
                    return; // bail out
                }
            }
        }   
    }

    flagbyte2 &= ~flagbyte2_twintrignow; // clear this

    /* Putting this here will cause code to think there's a stall if there are
     * a LOT of short pulses in a row, resetting ignition.
     */
    ltch_lmms = lmms;     // latch RTI .128 ms clk

    //*******************************************************************************
    //***  mode selection ***
    spkmode = flash4.spk_mode & 0x1f; // saves doing "anda, andb" over and over below

    if (spkmode < 2) {
        goto DO_EDIS;
    }
    //*******************************************************************************

    temp1 = TC0_32bits - tooth_time1; // tooth gap that just happened

    // False trigger period rejection
    if (false_period_crk_tix) {
        if ((unsigned int)temp1 < false_period_crk_tix) {
            unsigned char ftrtmp1;
            // assume this is a false trigger
            if (flash8.feature413 & 1) { // debug counter?
                // gcc optimises this 'junk' to precisely the right asm - nice!
                ftrtmp1 = outpc.gpioadc[6] & 0xff;
                ftrtmp1++;
                outpc.gpioadc[6] = (outpc.gpioadc[6] & 0xff00) | ftrtmp1;
            }
            return;
        }
    }

    tooth_time2 = tooth_time1; // Do this _after_ the rejection code
    tooth_time1 = TC0_32bits;  // so it only runs for real teeth

    tooth_diff_last_2 = tooth_diff_last_1; // the one before that
    tooth_diff_last_1 = tooth_diff_last; // the one before
    tooth_diff_last = tooth_diff_this;  // previous gap

    tooth_diff_this = temp1; // tooth gap that just happened

    //2nd trig polling removed as now input capture

    //tooth logger
    if (flagbyte0 & flagbyte0_tthlog) {

        __asm__ __volatile__ (
                "ldab  %1\n"
                "andb  #0xf\n"
                "brclr %3, #1, tlnot_sync\n" // #0x01 is SYNC_SYNCED -> 0x10 in log top byte
                "orab  #0x10\n"
                "tlnot_sync:\n"
                "brclr %3, #8, tlnot_semi\n" // #0x08 is SYNC_SEMI -> 0x40 in log top byte
                "orab  #0x40\n"
                "tlnot_semi:\n"
                "brclr %3, #0x10, tlnot_semi2\n" // #0x10 is SYNC_SEMI2 -> 0x80 in log top byte
                "orab  #0x80\n"
                "tlnot_semi2:\n"
                "brclr %4,#1,tlnot_trg2\n" // #0x01 is flagbyte1_trig2active -> 0x20 in log top byte
                "orab  #0x20\n"
                "tlnot_trg2:\n"
                "stab  0,Y\n"

                "ldd  %2\n"
                "std  1,Y\n"
                :
                : "y" (log_offset+ram_data),
            "m" (*((unsigned char *)&tooth_diff_this+1)), // byte 3:**2**:1:0
            "m" (*((unsigned int *)&tooth_diff_this+1)),  // bytes 3:2:**1**:**0**
            "m" (synch),
            "m" (flagbyte1)
                );
        log_offset+=3;


        if (log_offset > 1023) {
            flagbyte0 &= ~flagbyte0_tthlog; // turn off logger
            outpc.status3 |= status3_donelog;
        }
    }

    if (spkmode == 31) {  // go for it right away - no need to sync
        goto SPKMODEFUEL;
    }

    // start with sync off, and wait a few pulses before trying to sync
    if ( (!(synch & SYNC_SYNCED)) && (!(synch & SYNC_SEMI)) && (!(synch & SYNC_SEMI2)))  {
        // not synced yet, count down to 0 on tooth_no.
        if (tooth_no > 0) {
            tooth_no--;
            trig2cnt = 0;
            flagbyte1 &= ~flagbyte1_trig2active; // ensure we see 2nd trigger at right time
            return;
        }
    }

    /************ mode selection "if" *************/
    // creates faster asm
    if (spkmode == 2) {
        goto SPKMODE2;
    } else if (spkmode == 3) {
        goto SPKMODE3;
    } else if (spkmode == 4) {
        goto SPKMODE4;
    } else if (spkmode == 5) {
        goto SPKMODE5;
    } else if (spkmode == 6) {
        goto SPKMODE6;
    } else if (spkmode == 7) {
        goto SPKMODE7;
    } else if (spkmode == 8) {
        goto SPKMODE8;
    } else if (spkmode == 9) {
        goto SPKMODE9;
    } else if (spkmode == 10) {
        goto SPKMODE10;
    } else if (spkmode == 11) {
        goto SPKMODE11;
    } else if (spkmode == 12) {
        goto SPKMODE12;
    } else if (spkmode == 13) {
        goto SPKMODE13;
    } else if (spkmode == 14) {
        goto SPKMODE14;
    } else if (spkmode == 15) {
        goto SPKMODE15;
    } else if (spkmode == 16) {
        goto SPKMODE16;
    } else if (spkmode == 17) {
        goto SPKMODE17;
    } else if (spkmode == 18) {
        goto SPKMODE18;
    } else if (spkmode == 19) {
        goto SPKMODE19;
    } else if (spkmode == 20) {
        goto SPKMODE20;
    } else if (spkmode == 21) {
        goto SPKMODE21;
    } else if (spkmode == 22) {
        goto SPKMODE22;
    } else if (spkmode == 23) {
        goto SPKMODE23;
    } else if (spkmode == 24) {
        goto SPKMODE24;
    } else if (spkmode == 25) {
        goto SPKMODE25;
/* gap */
    } else if (spkmode == 29) {
        goto SPKMODE29;
    } else {
        goto SPKMODEFUEL;  // really mode 31
    }
    /************ missing tooth wheel & missing and 2nd trigger wheel mode *************/
SPKMODE4:
    if ((flash4.spk_config & 0xc) == 0x8) {
        goto SPKMODE4B;
    }
    /* this is the "find missing" step */
    // look for missing tooth (subtract last tooth time from this tooth
    // count taking overflow into account, and then multiply previous
    // tooth time by 1.5 and see

    if (firstsync_iter == 0) {
        /* Here we will look for missing */

        temp1 = tooth_diff_last + (tooth_diff_last >> 1);

        if (tooth_diff_this > temp1) {
            firstsync_iter = 1;
        }
        return;
    } else if (firstsync_iter == 1) {
        /* tooth after what we thought was missing, lets make sure this one is short
         * on the first sync, we miss tooth #1, but that's ok as long as we catch it next time
         * split this into 2 operations so compiler doesn't call subroutine
         */
        temp1 = (tooth_diff_last >> 1); /* 1/2 of last value */
        temp1 = temp1 >> 1; /* 1/4th of last value */

        temp1 = tooth_diff_last - temp1; /* 3/4ths of last value */

        if (tooth_diff_this >= temp1) {
            /* this wasn't really the missing tooth... */
            firstsync_iter = 0;
            return;
        }

        firstsync_iter = 2;
        flagbyte4 |= flagbyte4_found_miss;
        set_count = 1;
    } else if (firstsync_iter == 2) {
        if (tooth_no == 0) { // this should not happen, so reset
            outpc.syncreason = 1;
            ign_reset();  // note that this sequence of setting reason, resetting ign and incrementing counter is
            return;
        }

        if ((flash8.feature413 & 0x2) == 0) { // default behaviour is only to look for missing when expected
            if ((tooth_no == last_tooth) ||
                (((flash4.spk_config & 0xc) == 0xc) && (tooth_no == mid_last_tooth))) {
                /* this means we should have the last tooth here, so check for missing */
                temp1 = tooth_diff_last + (tooth_diff_last >> 1); /* 1.5 * last tooth */

                if (tooth_diff_this <= temp1) {
// WANT TO MODIFY THIS
	                firstsync_iter = 0;
                    flagbyte4 &= ~flagbyte4_found_miss;
                    outpc.syncreason = 2;
                    ign_reset();
                    return; 
                }

                flagbyte4 |= flagbyte4_found_miss;
                set_count = 0;
            }
 
       } else { // If in debug mode - check on every tooth
                temp1 = tooth_diff_last + (tooth_diff_last >> 1); /* 1.5 * last tooth */
                if (tooth_diff_this > temp1) { // found a missing tooth
                    if ((tooth_no == last_tooth) ||
                        (((flash4.spk_config & 0xc) == 0xc) && (tooth_no == mid_last_tooth))) {
                        flagbyte4 |= flagbyte4_found_miss; // all ok, missing found when expected
                        set_count = 0;
                        if (syncerr) {
                            syncerr--;
                        }
                    } else { // missing tooth not found when expected
                        // check for +/- 3 teeth. Beyond that declare nonsense
                        signed int delta_tooth;
                        
                        delta_tooth = (signed int)last_tooth - (signed int)tooth_no;
                        outpc.istatus5 = (unsigned char) delta_tooth;

                        if ((delta_tooth < 3) && (delta_tooth > -3)) {
                            if (delta_tooth < 0) {
                                outpc.syncreason = 3;
                            } else {
                                outpc.syncreason = 4;
                            }
                            outpc.synccnt++;
                            // allow permissiveness
                            syncerr++;
                            flagbyte4 |= flagbyte4_found_miss; // just say we found it
                            set_count = 0;
                        } else if ((flash4.spk_config & 0xc) == 0xc) { // check if two rotations
                            delta_tooth = (signed int)mid_last_tooth - (signed int)tooth_no;

                            if ((delta_tooth < 3) && (delta_tooth > -3)) {
                                if (delta_tooth < 0) {
                                    outpc.syncreason = 8;
                                } else {
                                    outpc.syncreason = 9;
                                }
                                outpc.synccnt++;
                                // allow permissiveness
                                syncerr++;
                                flagbyte4 |= flagbyte4_found_miss; // just say we found it
                                set_count = 0;
                            } else {
                                outpc.syncreason = 7; // just too far away
            	                firstsync_iter = 0;
                                flagbyte4 &= ~flagbyte4_found_miss;
                                ign_reset();
                                return;
                            }
                        } else { // wasn't close to last tooth and not using two rotations                    
                            outpc.syncreason = 6; // just too far away
       	                    firstsync_iter = 0;
                            flagbyte4 &= ~flagbyte4_found_miss;
                            ign_reset();
                            return;
                        }
                    }
                }
            }
        }

        if (tooth_no == 1) {
            /* check to make sure this tooth is < 3/4th's of last tooth
             * If it's not, we lost sync...
             */

            temp1 = (tooth_diff_last >> 1);
            temp1 = temp1 >> 1;

            temp1 = tooth_diff_last - temp1;

            if (tooth_diff_this >= temp1) {
                /* lost sync */
                firstsync_iter = 0;
                outpc.syncreason = 5;
                ign_reset();
                return;
            }
        }
    

// check for wasted to COP transition
    if ((synch & SYNC_WCOP2) && (coilsel == 0)) { // ready and coils not about to fire
        synch &= ~(SYNC_WCOP1 | SYNC_WCOP2);
    }

    if (flagbyte4 & flagbyte4_found_miss) {

        flagbyte4 &= ~flagbyte4_found_miss;

        // found the missing tooth

// code to run wasted COP before full sync when running dual + missing
        if ((flash4.spk_config & 0xc) == 0xc) {
            if (!(synch & SYNC_SYNCED)) {
	          if ( ((no_triggers & 1) == 1) && ((flash4.spk_mode & 0xc0) == 0x80) ) {
	  	        // can't handle odd cyls with COP this way - require sync
                    if (!(flagbyte1 & flagbyte1_trig2active)) {
                        goto common_wheel;
                    }
                } else if (!(flagbyte1 & flagbyte1_trig2active)) { // haven't seen 2nd trig just yet
                    synch |= SYNC_WCOP1;
                }
            } else if ((synch & SYNC_WCOP1) && (flagbyte1 & flagbyte1_trig2active)) {
                if (coilsel == 0) { //not about to fire
                    synch &= ~(SYNC_WCOP1 | SYNC_WCOP2); // turn wasted cop mode off
                } else {
                    synch |= SYNC_WCOP2; // in middle of a dwell, need to wait for completion
                }
            }
        }

        synch |= SYNC_SYNCED;

        if (synch & SYNC_FIRST) {
            syncfirst();
        }

        outpc.status1 |= status1_syncok; /* have sync */

        if ((flash4.spk_config & 0xc) != 0xc) {
            tooth_no = set_count;
        } else { // dual with missing
            if (synch & SYNC_WCOP1) {
                if (tooth_no >= last_tooth) {
                    tooth_no = set_count;
                } else if (tooth_no != 0) {
                    tooth_no += flash4.No_Miss_Teeth;
                } else {
                    tooth_no = set_count;
                }
            } else { 
               if (flagbyte1 & flagbyte1_trig2active) {
                    tooth_no = set_count;
                    flagbyte1 &= ~flagbyte1_trig2active;
                } else {
                    tooth_no += flash4.No_Miss_Teeth;
                }
            }
        }
    }
    goto common_wheel;

    /************ 2nd trigger non-missing mode *************/
SPKMODE4B:
/* new method - like used on missing tooth wheel - only check for cam trigger when we are expecting it
   Will also need some method of ensuring that masking/period rejection isn't trigger by incorrect
   noise pulse
*/
        if (!(synch & SYNC_SYNCED)) {
            if (!(flagbyte1 & flagbyte1_trig2active)) {
                return;                 // wait until we get a second trigger
            }
            /* can only get here if we have received a 2nd trigger */
            synch |= SYNC_SYNCED;
            outpc.status1 |= status1_syncok;
            tooth_no = 0;
        } else {
            if (tooth_no == no_teeth) {           
                /* recheck sync */
                if (flagbyte1 & flagbyte1_trig2active) {
                    /* all is well, got the second trigger when expected */
                    tooth_no = 0;
                } else {
                    /* didn't received the second trigger when expected - sync error */
                    outpc.syncreason = 17;
                    ign_reset();
                }
            } else {
                /* not time to check sync */
                if (flagbyte1 & flagbyte1_trig2active) { // had a trigger on cam we shouldn't have done
                    ltch_lmms2 = 0xffffffff; // reset this data
                    TIE |= TFLG_trig2; // ensure 2nd trig ISR is on
                    TC_trig2_last = TC_trig2_last2; // restore previous tooth time to ignore false pulse
                    outpc.syncreason = 11; // let the user know there is a potential problem without losing sync
                }
                /* do nothing else, just count the teeth in this mode */
            }
        }
    flagbyte1 &= ~flagbyte1_trig2active; // clear flag
    goto common_wheel;

    /************ dizzy mode *************/
SPKMODE2:
SPKMODE3:
    if ((!(synch & SYNC_SYNCED)) && (!edge) ) {
        return; // only sync on correct edge
    }
    //check we are still synced up
    if ((!edge) && (!(tooth_no & 1))) { // out of sync
        outpc.syncreason = 13;
        ign_reset(); // kill the lot
        return;
    }

    //oddfire sync
    // concern that heavy accel/decel on slightly odd engines might lose sync
    // sync if  this < last  and  last > last_1  i.e. period coming up is long

    if ((flash4.ICIgnOption & 0x8) && (!(synch & SYNC_SYNCED))) {
        if (!((tooth_diff_this < tooth_diff_last) && (tooth_diff_last > tooth_diff_last_1))) {
            return; // not found right pattern yet
        }
    }

    // check for sync, tooth_no here is 1 less than normal as ++ below
    if ((flash4.ICIgnOption & 0x8) && (!(tooth_no & 1))) {
        if ((tooth_diff_this < tooth_diff_last) && (tooth_diff_last > tooth_diff_last_1)) {
            outpc.syncreason = 14;
            ign_reset(); // out of sync
        }
    }


    synch |= SYNC_SYNCED; // always synced in dizzy mode
    outpc.status1 |= status1_syncok;
    if (synch & SYNC_FIRST) {
        tooth_no = 0; // syncfirst now follows common_wheel
    }
    goto common_wheel;

    /************ 420A/Neon mode *************/
SPKMODE5:
    //initial sync

    if (!edge) {  // only sync or do spark on falling edge
        flagbyte1 &= ~flagbyte1_trig2active; // clear 2nd trig
        return;
    }

    if (!(synch & SYNC_SYNCED)) {
        if ((!tooth_diff_last) || (!tooth_diff_last) || (!tooth_diff_last_1) || (!tooth_diff_last_2)){
            return; // only sync on falling edge
        }
        // see if we've got sync. Look for a tooth that is a lot longer than previous teeth
        if (tooth_diff_last > (tooth_diff_last_1 <<1)) {
            if (tooth_diff_this > (tooth_diff_last_1 <<1)) {
                tooth_no = 0; // this tooth is 1
                synch |= SYNC_SYNCED;
                outpc.status1 |= status1_syncok;
            } else if ((tooth_diff_last > (tooth_diff_this <<1)) && (tooth_diff_last > ((tooth_diff_last_1 + tooth_diff_last_2)<<1))) {
                tooth_no = 4; // this tooth is 5
                synch |= SYNC_SYNCED;
                outpc.status1 |= status1_syncok;
    	    } else {
                flagbyte1 &= ~flagbyte1_trig2active; // clear 2nd trig, in phase when it should be low
                return;
            }
        }

        // if COP or allow-CAM, check cam phase
        if ( (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) && (flagbyte1 & flagbyte1_trig2active)) {
            tooth_no = tooth_no + 8;
        }
    } else {
        // recheck for sync
        if ((tooth_no == 16) || (tooth_no == 12) || (tooth_no == 8) || (tooth_no == 4)) {
            // see if we've got sync. Look for the pre 69deg tooth

            if (tooth_diff_last > (tooth_diff_last_1 <<1)) {
                if (tooth_diff_this > (tooth_diff_last_1 <<1)) {
                    if ((tooth_no != 8) && (tooth_no != 16)) {
                        outpc.syncreason = 23;
                        ign_reset();
                        return;
                    }
                    // if COP or allow-CAM, check cam phase
                    if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) {
                        if ((tooth_no == 8) && (flagbyte1 & flagbyte1_trig2active)) {
                            tooth_no = 8; // only halfway through cycle
                        } else if ((tooth_no == 16) && ((flagbyte1 & flagbyte1_trig2active) == 0)) {
                            tooth_no = 0; // start of cycle
                        } else {
                            outpc.syncreason = 24;
                            ign_reset(); // cam phase wrong
                        }
                    } else {
                        tooth_no = 0; // this tooth is 1
                    }
                } else if ((tooth_diff_last > (tooth_diff_this <<1)) && (tooth_diff_last > ((tooth_diff_last_1 + tooth_diff_last_2)<<1))) {
                    if ((tooth_no != 4) && (tooth_no != 12)) {
                        outpc.syncreason = 25;
                        ign_reset();
                        return;
                    }
                    // tooth no. ok
                } else {
                    outpc.syncreason = 26;
                    ign_reset();
                    return;
                }
            } else {
                // got out of sync
                outpc.syncreason = 27;
                ign_reset();
                return;
            }
        }
    }

    flagbyte1 &= ~flagbyte1_trig2active; // clear 2nd trig

    goto common_wheel;

    /************ 36-1+1 mode *************/
SPKMODE6:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	    if ((!edge) || (!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1) || (!tooth_diff_last_2)){
	        return; // only sync on falling edge
	    }
    	// see if we've got sync. Look for the +1/-1 tooth
    	if ((tooth_diff_this + tooth_diff_last) > ((tooth_diff_last_1 + tooth_diff_last_2)<<1)) {
    	    synch |= SYNC_SYNCED;
    	    outpc.status1 |= status1_syncok;

    	    if (tooth_diff_last > (tooth_diff_this <<1)) {
    	    	tooth_no = 0; // this tooth is 1
    	    } else {
    	    	tooth_no = 16; // this tooth is 17
    	    }
    	} else {
    	    return; // not found right sequence yet
    	}
    } else {
    	//while synced only use falling edge for further calcs
    	if (!edge) {
    	    return;
    	    //ignore the rising edge for timing purposes, only count falling edge as a tooth
    	}
    	// recheck for sync
    	if ((tooth_no == 32) || (tooth_no == 16)) { // remove leading 1
    	    // see if we've got sync. Look for the +1/-1 tooth
    	    if ((tooth_diff_this + tooth_diff_last) > ((tooth_diff_last_1 + tooth_diff_last_2)<<1)) {
        		synch |= SYNC_SYNCED;
        		outpc.status1 |= status1_syncok;

        		// seems we've found either the 60deg or 120deg low before 69deg
        		if (tooth_diff_last > (tooth_diff_this <<1)) {
        		    tooth_no = 0; // this tooth is 1
        		} else {
        		    tooth_no = 16; // this tooth is 17
        		}
    	    } else {
                outpc.syncreason = 28;
        		ign_reset(); // got out of sync
        		return;
    	    }
    	}

    }

    // be certain we stop here unless correct edge
    if (!edge) {
        return;
        //ignore the rising edge for timing purposes, only count falling edge as a tooth
    }

    //only do this on active edges

    goto common_wheel;

    /************ 36-2-2-2 mode *************/
SPKMODE7:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
        if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
            return; // only sync when there's enough data
        }

        // when unsynced we wait until we see a missing double tooth after a couple
        // of shorter ones

        if (!(synch & SYNC_SEMI)) { // just starting
            if ( (tooth_diff_this > (tooth_diff_last<<1))
                    && (tooth_diff_this < (tooth_diff_last<<2))
                    && (tooth_diff_this > (tooth_diff_last_1<<1))
                    && (tooth_diff_this < (tooth_diff_last_1<<2)) ) {
                synch |= SYNC_SEMI; // started sync sequence
                tooth_no = 0;
            }
            return;
        } else { // started sequence, check possible sync points
            tooth_no++;
            if (tooth_no == 1) {
                if ( (tooth_diff_this > (tooth_diff_last_1<<1))
                        && (tooth_diff_this < (tooth_diff_last_1<<2)) ){
                    // compare against tooth before double missing
                    // found double tooth sequence, set tooth and go
                    tooth_no = 17;
                    goto WHL36_2_2_2_OK;
                }
            } else if ( (tooth_diff_this > (tooth_diff_last<<1))
                    && (tooth_diff_this < (tooth_diff_last<<2)) ) {
                if (tooth_no == 13) {
                    tooth_no = 0;
                    goto WHL36_2_2_2_OK;
                } else if (tooth_no == 16) {
                    tooth_no = 16;
                    goto WHL36_2_2_2_OK;
                }
            } else if (tooth_no > 30) {
                // PS Deviant track 9
                outpc.syncreason = 29;
                ign_reset();
            }
            return;
        }
WHL36_2_2_2_OK:

	synch &= ~SYNC_SEMI;
	synch |= SYNC_SYNCED;
	outpc.status1 |= status1_syncok;

    } else {
        // recheck for sync
        if ((tooth_no == 16) || (tooth_no == 30)) {  // (one less)
            if (tooth_diff_this <= (tooth_diff_last<<1)) {
                //fell over
                if (tooth_no == 16) {
                    outpc.syncreason = 30;
                } else {
                    outpc.syncreason = 52;
                }
                ign_reset();
                return;
            }
        }
    }

    if (tooth_no == 30) {
        tooth_no = 0;
    }

    goto common_wheel;

    /************ Subaru 6/7 mode *************/
SPKMODE8:
    //  initial sync - wait for two crank teeth with at least one cam tooth in between
    if (!(synch & SYNC_SYNCED)) {
    	if  ((!tooth_diff_this) || (!tooth_diff_last) || (trig2cnt == 0 )) {
    	    trig2cnt = 0;
    	    return; // only sync when there's enough data
    	}
    	// can use cam data for cylinder ID and sequential - but not doing that yet
    	if (trig2cnt > 1) {
    	    tooth_no = 0;
    	} else {
    	    tooth_no = 3;
    	}
    	synch |= SYNC_SYNCED;
    	outpc.status1 |= status1_syncok;
        trig2cnt = 0;
    } else {
    	// recheck for sync only on teeth 1 (6) and 4(3)
	    if (tooth_no == 6) {   // (last tooth we saw)
// new sync method, use tooth times to check for sync and check cam tooth numbers over two teeth. 
    	    if ((tooth_diff_this < tooth_diff_last) || (tooth_diff_this < tooth_diff_last_1) || (trig2cnt < 2)) { // must have at least one tooth in this period
        		//fell over
                outpc.syncreason = 20;
        		ign_reset();
        		return;
    	    } else {
        		tooth_no = 0;
                trig2cnt = 0;
    	    }
    	} else if (tooth_no == 3) {
    	    if ((tooth_diff_this < tooth_diff_last) || (tooth_diff_this < tooth_diff_last_1) || (trig2cnt != 1)) {
        		//fell over
                outpc.syncreason = 21;
        		ign_reset();
        		return;
	        } else {
                trig2cnt = 0;
            }
	    } else if ((tooth_no == 1) || (tooth_no == 4)) {
            trig2cnt = 0;
        } // don't reset trig2cnt on tooth 2 or tooth 5
    }


    goto common_wheel;

    /************ 99-00 Miata *************/
SPKMODE9:
    //  initial sync - wait for two crank teeth with at least one cam tooth in between
    if (!(synch & SYNC_SYNCED)) {
    	if  ((!tooth_diff_this) || (!tooth_diff_last) || (trig2cnt == 0 )) {
    	    trig2cnt = 0;
    	    return; // only sync when there's enough data
    	}

    	if (trig2cnt == 1) {
    	    tooth_no = 0;
    	} else if (trig2cnt == 2) {
    	    tooth_no = 4;
    	} else {
    	    trig2cnt = 0;
	        return; // unexpected number of 2nd triggers (noise?)
    	}
    	synch |= SYNC_SYNCED;
    	outpc.status1 |= status1_syncok;

    } else {
      	// recheck for sync
	    if (tooth_no == 4) {   // (last tooth we saw)
	        if (trig2cnt < 2) {
             outpc.syncreason = 31;
	         ign_reset();
	         return;
	        }
	    } else if (tooth_no == 8) {   // (last tooth we saw)
    	    if (trig2cnt == 0) {
                outpc.syncreason = 32;
           		ign_reset();
	            return;
	        } else {
	            tooth_no = 0;
	        }
      	}
    }

    trig2cnt = 0;

    goto common_wheel;

    /************ Mitsubishi 6g72 mode *************/
SPKMODE10:
    //  initial sync - wait for two crank teeth
    if (!(synch & SYNC_SYNCED)) {
        if  ((!tooth_diff_this) || (!tooth_diff_last)) {
            goto m6g72_exit;
        }
        // to allow events to fill before actual rpm declared
        synch |= SYNC_SEMI2;
        outpc.engine |= 0x2;
        outpc.rpm = 1;

        if (!(synch & SYNC_SEMI)) {
            // using falling edge as active
            // until fully synced use "synthetic" tooth numbers
            if (!edge) {
                tooth_no = 2; // for mainloop
            } else {
                tooth_no = 1; // for mainloop
                if ((edge2) && (flagbyte1 & flagbyte1_trig2statl)) {
                    synch |= SYNC_SEMI; // found crank tooth with absent cam tooth
                    tooth_no = 5; // actual 5 or 11.
                }
            }
            goto m6g72_exit;
        } else {
            tooth_no++;

            if ( ((tooth_no == 6) && (edge2)) || (tooth_no>7) ) {
                ign_reset(); // incorrect sequence, abort syncing
                goto m6g72_exit;
            }

            if (tooth_no == 7) {
                if (!edge2) {
                    tooth_no = 0;
                    goto m6g72_sync;
                } else {
                    tooth_no = 6;
                    goto m6g72_sync;
                }
            }
        }
        //goto section only reached for exit
m6g72_exit:
        flagbyte1 &= ~flagbyte1_trig2active;
        // store last 2nd trigger status
        if (edge2) {
            flagbyte1 |= flagbyte1_trig2statl;
        } else {
            flagbyte1 &= ~flagbyte1_trig2statl;
        }
        return; // only sync when there's enough data

        //continue here if synced
m6g72_sync:
	synch |= SYNC_SYNCED;
	outpc.status1 |= status1_syncok;

    } else {
        // recheck for sync
        if (tooth_no == 2) {   // (last tooth we saw)
            // cam must be high now and low on last edge
            if ((edge2) || (!(flagbyte1 & flagbyte1_trig2statl))) {
                outpc.syncreason = 33;
                ign_reset();
                return;
            }
        } else if (tooth_no == 4) {   // (last tooth we saw)
            // cam must be low now and low on last edge
            if (!(edge2) || (!(flagbyte1 & flagbyte1_trig2statl))) {
                outpc.syncreason = 34;
                ign_reset();
                return;
            }
        }

    }

    // store last 2nd trigger status
    if (edge2) {
        flagbyte1 |= flagbyte1_trig2statl;
    } else {
        flagbyte1 &= ~flagbyte1_trig2statl;
    }

    if (tooth_no == 12) {
        tooth_no = 0;
    }

    goto common_wheel;

    /************ IAW Weber-Marelli *************/
    /* As used on Sierra Cosworth, some Fiats, Lancia */
SPKMODE11:
    if (!(synch & SYNC_SYNCED)) {
	if (!(synch & SYNC_SEMI2)) {
	    if ( (!tooth_diff_this) || (!tooth_diff_last) ) {
		trig2cnt = 0;
		return;
	    }
	    synch |= SYNC_SEMI2;
	    tooth_no = 1; // fake tooth so mainloop can fill event table
	    outpc.engine |= 0x2;
	    if (trig2cnt == 0 ) {
		return; // only sync when there's enough data
	    } else {
		// for real sync need to find both lobes, but for simple distributor sync it doesn't matter
		// find one lobe then we know if even or odd crank tooth.

		//Method we could use is declare SYNC_SEMI and count teeth. Once second tooth found, then
		//know where we are.
		//Would be worth making the additional sync dependant on whether COP/ W/S selected to allow
		//faster starts on dizzy engines.
		tooth_no = 0;
		synch |= SYNC_SYNCED;
		outpc.status1 |= status1_syncok;
	    }
	} else {
	    if (trig2cnt == 0 ) {
		return; // only sync when there's enough data
	    } else {
		// for real sync need to find both lobes, but for simple distributor sync it doesn't matter
		// find one lobe then we know if even or odd crank tooth.

		//Method we could use is declare SYNC_SEMI and count teeth. Once second tooth found, then
		//know where we are.
		//Would be worth making the additional sync dependant on whether COP/ W/S selected to allow
		//faster starts on dizzy engines.
		tooth_no = 0;
		synch |= SYNC_SYNCED;
		outpc.status1 |= status1_syncok;
	    }
	}

    } else {
	// recheck for sync
	if (tooth_no == 8) {   // (last tooth we saw)
	    if (trig2cnt == 0) {
        outpc.syncreason = 35;
		ign_reset();
		return;
	    } else {
		tooth_no = 0;
	    }
	}
    }

    trig2cnt = 0;

    goto common_wheel;
    /************ CAS 4/1 mode *************/
SPKMODE12:
    //  initial sync - wait for second trigger
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) || (!edge) || (!(flagbyte1 & flagbyte1_trig2active)) ) {
	    if (edge) {
		flagbyte1 &= ~flagbyte1_trig2active;
	    }
	    return;
	}
	tooth_no = 0;
	synch |= SYNC_SYNCED;
	outpc.status1 |= status1_syncok;

    } else {
	// recheck for sync
	if (tooth_no == 8) {
	    if ( (!edge) || (!(flagbyte1 & flagbyte1_trig2active)) ) {
        outpc.syncreason = 36;
		ign_reset();
		return;
	    } else {
		tooth_no = 0;  // OK, restart sequence
	    }
	}
    }

    if (edge) {
        flagbyte1 &= ~flagbyte1_trig2active;
    }

    goto common_wheel;
    /************ 4G63 (CAS 4/2) mode *************/
    // Actually M1 (NA) Miata 89-97
SPKMODE13:
    // CAS 4/2 mode tied into "Miata" (and others?) trigger disc
    // expects correct timing, trigger angle can be tweaked, but should be around 10BTDC
    // Falling edge of crank signal is "edge" triggers on both edges
    // 2nd trig ISR not actually used, code here polls the pin on appropriate crank edge

    if (!(synch & SYNC_SYNCED)) {
	unsigned char utmp13;
	// For sync first look for rising edge of crank when cam is high
	if (!(synch & SYNC_SEMI)) {
	    unsigned char utmp13;
	    if  ( (!tooth_diff_this) || (!tooth_diff_last) ) {
		return;
	    }
	    synch |= SYNC_SEMI2;
	    outpc.engine |= 0x2; // declare cranking
	    outpc.rpm = 1; // bogus low rpm
	    // this should allow the code to fill advance tables before we declare sync
	    if (edge) {
		tooth_no = 2;
		return;
	    } else {
		tooth_no = 1;
	    }
	    utmp13 = portt_save & (TFLG_trig2 | 0x01);
	    // check if crank and cam the same without checking edge trigger settings
	    if ((utmp13 == (TFLG_trig2 | 0x01)) || (utmp13 == 0)) {
		synch |= SYNC_SEMI;
	    } else {
		return;
	    }
	} else {
	    // have semi synced
	    if (!edge) {
		// something went wrong, should be "edge"
        outpc.syncreason = 37;
		ign_reset();
		return;
	    }

	    utmp13 = portt_save & (TFLG_trig2 | 0x01);
	    // crank is now low..
	    // if same then this tooth is 4, otherwise 8
	    if ((utmp13 == (TFLG_trig2 | 0x01)) || (utmp13 == 0x00)) {
		tooth_no = 3;
	    } else {
		tooth_no = 7;
	    }
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	}
    } else {
	unsigned char utmp13;
	// recheck for sync
	utmp13 = portt_save & (TFLG_trig2 | 0x01);
	if (tooth_no == 3) {
	    //if not an active falling edge or cam and crank are different then fail
	    if ( (!(edge)) || (utmp13 == TFLG_trig2) || (utmp13 == 0x01) ) {
        outpc.syncreason = 38;
		ign_reset();
		return;
	    }
	} else if (tooth_no == 7) {
	    //if not an active falling edge or cam and crank are same then fail
	    if ( (!(edge)) || (utmp13 == (TFLG_trig2 | 0x01)) || (utmp13 == 0x00) ) {
        outpc.syncreason = 39;
		ign_reset();
		return;
	    }
	} else if (tooth_no == 8) {
	    tooth_no = 0;  // restart sequence
	}

    }

    goto common_wheel;
    /************ Twin trigger (bike) mode *************/
SPKMODE14:
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last)) {
	    tooth_no = 0;
	    synch &= ~SYNC_SEMI;
	    return; // only sync when there's enough data
	}
	if (!(synch & SYNC_SEMI)) {
	    if (flagbyte4 & flagbyte4_tach2) { // flag indicating we arrived via 2nd tach input
		tooth_no = 2;  // normally 0, but use 2 for this syncing
	    } else {
		tooth_no = 1;
	    }
	    synch |= SYNC_SEMI; // we force ourselves to check for both trigger inputs
	    return;
	} else {
	    // seen one trigger, now check it is the other, else problems
	    if (flagbyte4 & flagbyte4_tach2) {
		if (tooth_no == 2) {
		    ign_reset();
		    return;
		}
	    } else {
		if (tooth_no == 1) {
		    ign_reset();
		    return;
		}
	    }
	    synch &= ~SYNC_SEMI;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	}
    } else {
	// re-check phasing is correct (could occur due to miswiring)

	// arranging like this instead of one long "if" generates smaller asm
	if (flagbyte4 & flagbyte4_tach2) {
	    if (tooth_no == 2) {
        outpc.syncreason = 40;
		ign_reset();
		return;
	    }
	} else {
	    if (tooth_no == 1) {
        outpc.syncreason = 41;
		ign_reset();
		return;
	    }
	}
    }

    if (tooth_no == 2) {
        tooth_no = 0;
    }

    goto common_wheel;
    /************ Chrysler 2.2/2.5 *************/
SPKMODE15:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {

    	// when unsynced we wait until we see a high on the other input while we rise
	    if ((!edge) && (!edge2)) {
	        tooth_no = 0;
	        synch |= SYNC_SYNCED;
	        outpc.status1 |= status1_syncok;
	    } else {
	        return;
	    }

    } else {
	    // recheck for sync
	    if (tooth_no == 10) {  // (actually tooth 1)
	        if (edge2) {
                outpc.syncreason = 42;
	        	ign_reset();
	        	return;
	        } else {
	        	tooth_no = 0;
	        }
	    }
    }

    goto common_wheel;
    /************ Renix 44-2-2 *************/
SPKMODE16:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) ) {
	    return; // only sync when there's enough data
	}

	// when unsynced we wait until we see a missing double tooth
	if (tooth_diff_this > (tooth_diff_last<<1)) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 20) {  // (one less)
	    if (tooth_diff_this <= (tooth_diff_last<<1)) {
        outpc.syncreason = 43;
		ign_reset();
		return;
	    } else {
		tooth_no = 0;
	    }
	}
    }

    goto common_wheel;
    /************ Suzuki swift *************/
SPKMODE17:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) ) {
	    return; // only sync when there's enough data
	}
	// look for tooth longer than either of last ones
	if ((tooth_diff_this > tooth_diff_last)
		&& (tooth_diff_this > tooth_diff_last_1) ) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 6) {  // (one less)
	    if ((tooth_diff_this < tooth_diff_last)
		    || (tooth_diff_this < tooth_diff_last_1) ) {
        outpc.syncreason = 44;
		ign_reset();
		return;
	    } else {
		tooth_no = 0;
	    }
	}
    }

    goto common_wheel;

    /************ Suzuki vitara 2.0 *************/
SPKMODE18:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) ) {
	    return; // only sync when there's enough data
	}
	if (!(synch & SYNC_SEMI)) {
	    // look for short tooth after two long ones
	    if ( ((tooth_diff_this+(tooth_diff_this>>1)) < tooth_diff_last)
		    && ((tooth_diff_this+(tooth_diff_this>>1)) < tooth_diff_last_1) ) {
		tooth_no = 0;
		synch |= SYNC_SEMI;
	    } else {
		return;
	    }
	} else {
	    // semi synced, wait a few teeth
	    tooth_no++;
	    if (tooth_no < 2) {
		return;
	    }
	    if ((tooth_diff_this+(tooth_diff_this>>1)) < tooth_diff_last) {
		tooth_no = 2;
		synch |= SYNC_SYNCED;
		outpc.status1 |= status1_syncok;
	    } else if (tooth_diff_this > (tooth_diff_last+(tooth_diff_last>>2))) {
		tooth_no = 8;
		synch |= SYNC_SYNCED;
		outpc.status1 |= status1_syncok;
	    } else {
		// failed to sync for some reason
		ign_reset();
		return;
	    }
	}

    } else {
	// recheck for sync
	if (tooth_no == 11) {  // (one less)
	    if ((tooth_diff_this > tooth_diff_last)
		    || (tooth_diff_this > tooth_diff_last_1) ) {
        outpc.syncreason = 45;
		ign_reset();
		return;
	    } else {
		tooth_no = 0;
	    }
	} else if (tooth_no == 6) {  // (one less)
	    if ((tooth_diff_this > tooth_diff_last)
		    || (tooth_diff_this > tooth_diff_last_1) ) {
        outpc.syncreason = 46;
		ign_reset();
		return;
	    }
	}
    }

    goto common_wheel;

    /************ Daihatsu 3 cyl *************/
SPKMODE19:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
	    return; // only sync when there's enough data
	}
	//look for short tooth gap - this is tooth no.1
	ltmp1 = tooth_diff_this <<1;
	if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 4) {  // (one less)
	    ltmp1 = tooth_diff_this <<1;
	    if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
		    tooth_no = 0;
	    } else {
            outpc.syncreason = 47;
		    ign_reset();
		    return;
	    }
	}
    }

    goto common_wheel;

    /************ Daihatsu 4 cyl *************/
SPKMODE20:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
	    return; // only sync when there's enough data
	}
	//look for short tooth gap - this is tooth no.1
	ltmp1 = tooth_diff_this <<1;
	if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 5) {  // (one less)
	    ltmp1 = tooth_diff_this <<1;
	    if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
    		tooth_no = 0;
	    } else {
            outpc.syncreason = 48;
    		ign_reset();
		return;
	    }
	}
    }

    goto common_wheel;

    /************ Honda VTR1000 *************/
SPKMODE21:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last)) {
	    return; // only sync when there's enough data
	}
	//look for long tooth gap - this is tooth no.1
	ltmp1 = tooth_diff_this <<1;
	if ( tooth_diff_this > (tooth_diff_last << 1) ) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 9) {  // (one less)
	    if ( tooth_diff_this > (tooth_diff_last << 1) ) {
    		tooth_no = 0;
	    } else {
            outpc.syncreason = 49;
    		ign_reset();
		return;
	    }
	}

    }

    goto common_wheel;

    /************ Rover 36-1-1 mode *************/
SPKMODE22:
//initial sync
            if (!(synch & SYNC_SYNCED)) {
                if  ((!tooth_diff_this) || (!tooth_diff_last) ) {
                    return; // only sync when there's enough data
                }
                // when unsynced we wait until we see a missing tooth
                temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
                if (tooth_diff_this > temp1) {
                    tooth_no = 0;
                    synch |= SYNC_SYNCED;
                    outpc.status1 |= status1_syncok;
                } else {
                  return;
                }

    } else {
        // recheck for sync - revised method
        // this now does the calc on every tooth - previously only did it on tooth 17
        temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
        if (tooth_diff_this > temp1) { // missing tooth
            if (tooth_no != 17) {  // we are expecting tooth no. 17 (one less)
                //fell over
//                ign_reset(); // old method - one shot and you are out
                // be more tolerant
	            syncerr++;
                outpc.synccnt++;
                return;
            }
            tooth_no = 0;
        }
    }

    goto common_wheel;

    /************ Rover 36-1-1-1-1 mode2 (EU3) *************/
    // used on SPI Mini
SPKMODE23:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
        if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
            flagbyte1 &= ~flagbyte1_trig2active;
            return; // only sync when there's enough data
        }

        // when unsynced we wait until we see a missing tooth and then another one
        // and count the teeth in-between

        if (!(synch & SYNC_SEMI)) { // just starting
            temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
            if (tooth_diff_this > temp1) {
                tooth_no = 0;
                synch |= SYNC_SEMI; // started sync sequence
            }
            flagbyte1 &= ~flagbyte1_trig2active; // assume that cam tooth must occur between missing tooth segments
            return;
        } else { // started sequence, check possible sync points
            tooth_no++;
            if (!(synch & SYNC_SEMI2)) { // just starting
                temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
                if (tooth_diff_this > temp1) {
                    if (tooth_no == 2) {
                        tooth_no = 0; // tooth 1
                        goto WHL_ROV2_OK;
                    } else if (tooth_no == 3) {
                        tooth_no = 17; // tooth 18
                        goto WHL_ROV2_OK;
                    } else if (tooth_no == 13) {
                        tooth_no = 30; // tooth 15
                        goto WHL_ROV2_OK;
                    } else if (tooth_no == 14) {
                        tooth_no = 14; // tooth 31
                        goto WHL_ROV2_OK;
                    } else {
                        tooth_no = 0; // doesn't make sense, so try again from this missing tooth
                    }
                }
                return;
            }
        }
WHL_ROV2_OK:

	    synch &= ~SYNC_SEMI;
	    synch &= ~SYNC_SEMI2;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;

        if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) { // COP or use-cam
            if (flagbyte1 & flagbyte1_trig2active) {
                tooth_no += 32;
                flagbyte1 &= ~flagbyte1_trig2active;
            }
        }

    } else {
        // recheck for sync in normal running
        if ((tooth_no == 14) || (tooth_no == 17) || (tooth_no == 30) || (tooth_no == 32) || (tooth_no == 46) || (tooth_no == 49) || (tooth_no == 62) || (tooth_no == 64) ) {  // (one less)
            temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
            if (tooth_diff_this <= temp1) {
                outpc.syncreason = 22;
                ign_reset();
                return;
            } else {
                // sync recheck passed, now if in cam/cop mode, see if we are on right phase
                // intended to allow us to sync on wrong phase and 'fix' it soon afterwards
                // ought to start on wasted cop too, but not implemented yet
                if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) { // COP or use-cam
                    if ((tooth_no < 33) && (flagbyte1 & flagbyte1_trig2active) ) {
                        tooth_no += 32;
                    }
                }
            }           
            if (tooth_no == 32) {
                if (!(((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08))) { // COP or use-cam
                    tooth_no = 0;
                }
            } else if (tooth_no == 64) {
                tooth_no = 0;
            }
            flagbyte1 &= ~flagbyte1_trig2active;
        }
    }

    goto common_wheel;

    /************ Rover 36-1-1-1-1 mode3 - do not know application *************/
SPKMODE24:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
        if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
            return; // only sync when there's enough data
        }

        // when unsynced we wait until we see a missing tooth and then another one
        // and count the teeth in-between

        if (!(synch & SYNC_SEMI)) { // just starting
            temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
            if (tooth_diff_this > temp1) {
                tooth_no = 0;
                synch |= SYNC_SEMI; // started sync sequence
            }
            return;
        } else { // started sequence, check possible sync points
            tooth_no++;
            if (!(synch & SYNC_SEMI2)) { // just starting
                temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
                if (tooth_diff_this > temp1) {
                    if (tooth_no == 4) {
                        tooth_no = 0; // tooth 1
                        goto WHL_ROV3_OK;
                    } else if (tooth_no == 5) {
                        tooth_no = 16; // tooth 17
                        goto WHL_ROV3_OK;
                    } else if (tooth_no == 11) {
                        tooth_no = 11; // tooth 12
                        goto WHL_ROV3_OK;
                    } else if (tooth_no == 12) {
                        tooth_no = 28; // tooth 29
                        goto WHL_ROV3_OK;
                    } else {
                        tooth_no = 0; // doesn't make sense, so try again from this missing tooth
                    }
                }
                return;
            }
        }
WHL_ROV3_OK:

	    synch &= ~SYNC_SEMI;
	    synch &= ~SYNC_SEMI2;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;

    } else {
        // recheck for sync
        if ((tooth_no == 11) || (tooth_no == 16) || (tooth_no == 28) || (tooth_no == 32)) {  // (one less)
            temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
            if (tooth_diff_this <= temp1) {
                outpc.syncreason = 50;
                ign_reset();
                return;
            }
            if (tooth_no == 32) {
                tooth_no = 0;
            }
        }
    }

    goto common_wheel;

    /************ GM 7X native *************/
SPKMODE25:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	    if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
	        return; // only sync when there's enough data
	    }
	    //look for short tooth gap - this is tooth no.7
	    ltmp1 = tooth_diff_this <<1;
	    if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
	        tooth_no = 6;
	        synch |= SYNC_SYNCED;
	        outpc.status1 |= status1_syncok;
	    } else {
	        return;
	    }

    } else {
	    // recheck for sync
	    if (tooth_no == 6) {  // (one less)
	        ltmp1 = tooth_diff_this <<1;
	        if (!( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) )) {
                outpc.syncreason = 51;
		        ign_reset();
		        return;
	        }
	    } else if (tooth_no == 7) {
            tooth_no = 0;
        }
    }

/* Nissan CAS and optispark to go in here LATER!*/

        /* ----------------------  Honda RC-51  --------------------*/
SPKMODE29:
/* this wheel can come after 2.1.0*/
    //  initial sync - wait for two crank teeth with at least one cam tooth in between
    if (!(synch & SYNC_SYNCED)) {
        if (!(synch & SYNC_SEMI)) {
        	if  ((!tooth_diff_this) || (!tooth_diff_last) || (!(flagbyte1 & flagbyte1_trig2active))) {
        	    flagbyte1 &= ~flagbyte1_trig2active;
        	    return; // only sync when there's enough data
        	}
            // just found the first cam pulse
            synch |= SYNC_SEMI;
            tooth_no = 0;
      	    flagbyte1 &= ~flagbyte1_trig2active;
            return;
        } else {
            tooth_no++;
            if (!(flagbyte1 & flagbyte1_trig2active)) {
                return;
            }
            // now we've had two cam pulses
            if (tooth_no == 10) {
                tooth_no = 16;
                goto rc51_ok;
            } else if (tooth_no == 2) {
                tooth_no = 18;
                goto rc51_ok;
            } else if (tooth_no == 12) {
                tooth_no = 6;
                goto rc51_ok;
            } else {
                outpc.syncreason = 53;
		        ign_reset();
		        return;
            }
        }
rc51_ok:
    	synch &= ~SYNC_SEMI;
    	synch |= SYNC_SYNCED;
    	outpc.status1 |= status1_syncok;
    } else {
        if ((tooth_no == 6) || (tooth_no == 16) || (tooth_no == 18)) {
            if (!(flagbyte1 & flagbyte1_trig2active)) {
                if (tooth_no == 6) {
                    outpc.syncreason = 54;
                } else if (tooth_no == 16) {
                    outpc.syncreason = 55;
                } else {
                    outpc.syncreason = 56;
                }
		        ign_reset();
		        return; 
            }
        } else if (tooth_no == 24) {
            tooth_no = 0;
        }
    }

    flagbyte1 &= ~flagbyte1_trig2active;

    goto common_wheel; 
    /************ fuel only mode *************/
SPKMODEFUEL:
    synch |= SYNC_SYNCED;
    outpc.status1 |= status1_syncok; /* have sync */
    thistoothevents |= FUEL; // every tach event is a fuel tooth
    /************ end of the long if for different variants of wheel mode *************/

common_wheel:
    if (synch & SYNC_FIRST) {
        syncfirst();
    }
    if (synch & SYNC_SYNCED) {
        tooth_no++;
        if (tooth_no > last_tooth) {
	        if (! (((flash4.spk_mode & 0x1e) == 2) || ((flash4.spk_mode & 0x1f) == 31)) ) { // NOT 2,3, 31
                outpc.syncreason = 10;
	            syncerr++;
                outpc.synccnt++;
            }
	        tooth_no = 1;
	    }

        if ((spkmode == 5) || (spkmode == 6))  {
            // Neon/420A and 36-1+1 join up tooth times
            dtpred_adder += tooth_diff_this + tooth_diff_last; // look for more flexible way to do this
            tooth_diff_rpm_last = tooth_diff_rpm;
            tooth_diff_rpm.time_32_bits = tooth_diff_this+tooth_diff_last;
            tooth_no_rpm = tooth_no;
        } else {
            dtpred_adder += tooth_diff_this;
            tooth_no_rpm = tooth_no;
            tooth_diff_rpm_last = tooth_diff_rpm;
            tooth_diff_rpm.time_32_bits = tooth_diff_this;
        }
        // log to ring buffer for mainloop to extract tooth times
        act_tooth_time[tooth_counter] = tooth_diff_rpm;
        act_tooth_num[tooth_counter] = tooth_no;
        tooth_counter++;
        if (tooth_counter >= WHEEL_NUM_TEETH) {
            tooth_counter = 0;
        }

        if (outpc.rpm == 0) {
            outpc.rpm = 1; // fake non zero rpm
            outpc.engine |= 0x02; // declare cranking
        }

    }
    //--- added JSM
    // if we get repeated additional or lost teeth then something is wrong
    if (syncerr > 3) {
        outpc.syncreason = 12;
        ign_reset();
        return;
    }
    //---

    /* update the dwell and spark time... if possible.
     * Make sure that dwell and spark tooth are both
     * still the same, otherwise don't update.
     */
    if ((next_dwell.tooth == dwell_events[next_dwell.coil].tooth) &&
            (next_spark.tooth == spark_events[next_spark.coil].tooth)) {
        next_dwell.time32 = dwell_events[next_dwell.coil].time32;
        next_spark.time32 = spark_events[next_spark.coil].time32;
    }

    if (flash10.RotarySplitMode & 0x20) {
        if ((next_dwl_trl.tooth == dwell_events[next_dwl_trl.coil].tooth) &&
                (next_spk_trl.tooth == spark_events[next_spk_trl.coil].tooth)) {
            next_dwl_trl.time32 = dwell_events[next_dwl_trl.coil].time32;
            next_spk_trl.time32 = spark_events[next_spk_trl.coil].time32;
        }
    }

    /* now I need to figure out which coil I want to fire,
     * or if I'm on a "fuel tooth"
     */

    // check if we are in the middle of a dwell or a spark event as we reach the trigger and fire if we are
    if ((flash4.spk_mode & 0x1f) == 2) { //was 0x1e so 2,3
        if (coilsel) {
            TIE &= ~0x04;
            fire_coil();
        }
        if ((dwellsel) && (flash4.dwellmode != 2)) {
            TIE &= ~0x04;
            fire_coil();
        }
    }

    if (next_spark.tooth == tooth_no) {
        thistoothevents = SPARK;
        if (synch & SYNC_WCOP1) {
            if (num_spk == 4) {
                tmp_coil = next_spark.coil + 2;
                if (tmp_coil > 3) {
                    tmp_coil -= 4;
                }
                SET_COIL(&tmp_coil, &coilsel);
            } else if (num_spk == 6) {
                tmp_coil = next_spark.coil + 3;
                if (tmp_coil > 5) {
                    tmp_coil -= 6;
                }
                SET_COIL(&tmp_coil, &coilsel);
            }
        }
        SET_COIL(&next_spark.coil, &coilsel);
    }

    if ((next_dwell.tooth == tooth_no) && (flash4.dwellmode != 2)) {
        thistoothevents |= DWELL;
        if (synch & SYNC_WCOP1) {
            if (num_spk == 4) {
                tmp_coil = next_dwell.coil + 2;
                if (tmp_coil > 3) {
                    tmp_coil -= 4;
                }
                SET_COIL(&tmp_coil, &dwellsel);
            } else if (num_spk == 6) {
                tmp_coil = next_dwell.coil + 3;
                if (tmp_coil > 5) {
                    tmp_coil -= 6;
                }
                SET_COIL(&tmp_coil, &dwellsel);
            }
        }
        SET_COIL(&next_dwell.coil, &dwellsel);
    }


    if (flash10.RotarySplitMode & 0x20) {
        if (next_spk_trl.tooth == tooth_no) {
            thistoothevents |= ROTARY_SPK;
            SET_COIL(&next_spk_trl.coil, &rotaryspksel);
        }

        if (next_dwl_trl.tooth == tooth_no) {
            thistoothevents |= ROTARY_DWL;
            SET_COIL(&next_dwl_trl.coil, &rotarydwlsel);
        }
    }

    if (next_fuel == tooth_no) {
        thistoothevents |= FUEL;
//debug
        if (flash8.feature413 & 1) {
            outpc.gpioadc[2]++; // increase trigger counter
        }
    }

    /* set the timer here. */
    if (thistoothevents & SPARK) {
        if (next_spark.time32 < 110) {
            // check how long dwell has been on delay spark if needed
            // not written yet
            TIE &= ~0x04;
            fire_coil();
        } else if (!next_spark.time16_high) {
            TC_ign = (unsigned short)(TC0this + next_spark.time16_low);
            TIE |= TFLG_ign;
            TFLG1 = TFLG_ign;	 // clear ign OC interrupt flag
        } else {
            wheeldec_ovflo |= OVFLO_SPK;
            spk_time_ovflo.time_32_bits = next_spark.time32 + TC0_32bits;
            TIE &= ~0x04; //disable spk OC
            TFLG1 = 0x04;	 // clear ign OC interrupt flag
        }

        /* explicitly copy each member of the struct...
         * otherwise gcc jumps to memcpy.. which is
         * notoriously slow
         */
        if (next_spark.coil == no_triggers - 1) {
            next = 0;
        } else {
            next = next_spark.coil + 1;
        }
        next_spark.time = spark_events[next].time;
        next_spark.tooth = spark_events[next].tooth;
        next_spark.coil = spark_events[next].coil;
        next_spark.ftooth = spark_events[next].ftooth;
        next_spark.fs = spark_events[next].fs;
    }

    if (thistoothevents & DWELL) {
        if (next_dwell.time32 < 110) {
            TIE &= ~0x40;
            dwell_coil();
        } else if (!next_dwell.time16_high) {
            TC6 = (unsigned short)(TC0this + next_dwell.time16_low);
            TIE |= 0x40;
            TFLG1 = 0x40;	 // clear ign OC interrupt flag
        } else {
            wheeldec_ovflo |= OVFLO_DWL;
            dwl_time_ovflo.time_32_bits = next_dwell.time32 + TC0_32bits;
            TIE &= ~0x40; //disable dwl OC
            TFLG1 = 0x40;	 // clear dwell OC interrupt flag
        }

        if (next_dwell.coil == no_triggers - 1) {
            next = 0;
        } else {
            next = next_dwell.coil + 1;
        }
        next_dwell.time = dwell_events[next].time;
        next_dwell.tooth = dwell_events[next].tooth;
        next_dwell.coil = dwell_events[next].coil;
    }

    if (thistoothevents & ROTARY_DWL) {
        if(next_dwl_trl.time32 < 110) {
            TIE &= ~0x80;
            dwell_coil_rotary();
        } else if (!next_dwl_trl.time16_high) {
            TC7 = (unsigned short)(TC0this + next_dwl_trl.time16_low);
            TIE |= 0x80;
            TFLG1 = 0x80;
        } else {
            wheeldec_ovflo |= OVFLO_ROT_SPK;
            dwl_time_ovflo_trl.time_32_bits = next_dwl_trl.time32 + TC0_32bits;
        }

        if (next_dwl_trl.coil == 2) {
            next = 3;
        } else {
            next = 2;
        }

        next_dwl_trl.time = dwell_events[next].time;
        next_dwl_trl.tooth = dwell_events[next].tooth;
        next_dwl_trl.coil = dwell_events[next].coil;
    }

    if (thistoothevents & ROTARY_SPK) {
        if (next_spk_trl.time32 < 110) {
            TIE &= ~0x10;
            fire_coil_rotary();
        } else if (!next_spk_trl.time16_high) {
            TC4 = (unsigned short)(TC0this + next_spk_trl.time16_low);
            TIE |= 0x10;
            TFLG1 = 0x10;
        } else {
            wheeldec_ovflo |= OVFLO_ROT_SPK;
            spk_time_ovflo_trl.time_32_bits = next_spk_trl.time32 + TC0_32bits;
        }

        if (next_spk_trl.coil == 2) {
            next = 3;
        } else {
            next = 2;
        }

        next_spk_trl.time = spark_events[next].time;
        next_spk_trl.tooth = spark_events[next].tooth;
        next_spk_trl.coil = spark_events[next].coil;
    }

    if (thistoothevents & FUEL) {

// trigger logger
    if (flagbyte0 & flagbyte0_trglog) {

        __asm__ __volatile__ (
                "ldab  %1\n"
                "andb  #0xf\n" // top 4 bits not used in trigger logger for consistency
                "stab  0,Y\n"
                "ldd  %2\n"
                "std  1,Y\n"
                :
                : "y" (log_offset+ram_data),
            "m" (*((unsigned char *)&dtpred+1)), // byte 3:**2**:1:0
            "m" (*((unsigned int *)&dtpred+1))  // bytes 3:2:**1**:**0**
                );
        log_offset+=3;


        if (log_offset > 1023) {
            flagbyte0 &= ~flagbyte0_trglog; // turn off logger
            outpc.status3 |= status3_donelog;
        }
    }



        if (fuel_cntr == no_triggers - 1) {
            fuel_cntr = 0;
        } else {
            fuel_cntr++;
        }
        next_fuel = trigger_teeth[(unsigned)fuel_cntr];
        dtpred_last3 = dtpred_last2;
        dtpred_last2 = dtpred_last;
        dtpred_last = dtpred;
        dtpred = dtpred_adder;
        dtpred_adder = 0;
        mapsample_time_aftertach = 0;
        synch |= SYNC_RPMCALC;
        goto START_INJ;
    }
    goto IC_EXIT;

    //*******************************************************************************
DO_EDIS:
    // calculate new dt. All times in ticks to save *3/2 or *2/3
    tooth_time2 = tooth_time1;
    tooth_time1 = TC0_32bits;
    dt2 = dt3;
    dt3 = tooth_time1 - tooth_time2;

    if(pulse_no >= flash4.no_skip_pulses)  {
        // after 1st few pulses, start checking for missed/ extra pulses
        if(PulseTol < 100)  {
            if(dt3 < ((100 - PulseTol) * dt2) / 100)  {
                // reject false trigger
                tooth_time1 = tooth_time2;
                dt3 = dt2;
                outpc.dt3 = (int)dt3;
                // clear IC interrupt flag
                TFLG1 = 0x01;
                return;                     // wait for next (true) pulse
            }
        }
        ltmp1 = ((100 + PulseTol) * dt2) / 100;
        if(dt3 > ltmp1)  {
            missed_pulse++;
            if(missed_pulse > 2)  {
                PORTE &= ~0x10;   // Turn off fuel Pump
                *pPTMpin[2] &= ~0x04;  // Turn off fast idle ** Bug Fix By Guy Hill **
                outpc.syncreason = 15;
                ign_reset();
                return;
            }
            // make up for missing pulse - set dt3 to last dt2
            dt3 = dt2;
        }
        else  {
            missed_pulse = 0;
        }
    }
    outpc.dt3 = dt3;

    // if we got here then we are alive
    outpc.status1 |= status1_syncok; /* show sync on MT display */
    synch |= SYNC_SYNCED; // ensure stall timeout runs

    // use last period
    dtpred_old = dtpred;
    dtpred = dt3;
    if(pulse_no < flash4.no_skip_pulses)  {  // skip 1st few (>1) pulses
        pulse_no++;
        // clear IC interrupt flag
        TFLG1 = 0x01;
//        return;
        goto START_INJ; // squirt some fuel right away for faster starts
    }
    else  {
        if(pulse_no < 3)
            pulse_no++;
    }
    // calculate rpm in mainloop

    if (dtpred <= 100)  {
        // Noise or beyond rev limit, clear all in engine
        PORTE &= ~0x10;   // Turn off fuel Pump
        *pPTMpin[2] &= ~0x04;  // Turn off fast idle ** Bug Fix By Guy Hill **
        outpc.syncreason = 16;
        ign_reset();
        return;
    }

// trigger logger (tooth logger not relevant or supported for EDIS)
    if (flagbyte0 & flagbyte0_trglog) {

        __asm__ __volatile__ (
                "ldab  %1\n"
                "andb  #0xf\n" // top 4 bits not used in trigger logger for consistency
                "stab  0,Y\n"
                "ldd  %2\n"
                "std  1,Y\n"
                :
                : "y" (log_offset+ram_data),
            "m" (*((unsigned char *)&dtpred+1)), // byte 3:**2**:1:0
            "m" (*((unsigned int *)&dtpred+1))  // bytes 3:2:**1**:**0**
                );
        log_offset+=3;


        if (log_offset > 1023) {
            flagbyte0 &= ~flagbyte0_trglog; // turn off logger
            outpc.status3 |= status3_donelog;
        }
    }

    // EDIS Ignition Output
    // cyl n                                   cyl n+1
    // tdc                                        tdc
    //  |-------- dtpred ---------------------------|
    //  |-delay- __________                         |
    //  |       |          |                        |
    //  |       |---SAW----|                        |
    //  |       |          |                        |
    //  |_______|          |________________________|
    // TC0
    //
    // send SAW pulse after delay, so we don't send
    // SAW while still sparking (send at 64us atdc)
    charge_time = 96;   //64us
    // SAW pulse calculation
    ltmp1 = coil_dur; // calculated in mainloop
    // multispk EDIS
    if(spkmode== 1)  {
        if (flagbyte4 & flagbyte4_first_edis)  {		 // 1st SAW for multispk is 2048 us
            flagbyte4 &= ~flagbyte4_first_edis;
            ltmp1 = 3072;      //2048us  1024 if ever have 10 cyl
        }
        else if(outpc.rpm < 1200)  {
            ltmp1 += 3072;     //2048us 1024 if ever have 10 cyl
        }
    }
    coil_dur_calc = ltmp1;
    outpc.coil_dur = coil_dur_calc;
    coil_dur_set = coil_dur_calc;
    IgnOCpinstate = SPK;
    ign_setpin = CHG;  // use to set OC o/p in OL5
    // load OC compare register, 64us after start of ISR
    TC5 = 400 + TC0;  // added delay to keep away from spark noise.
    // Set Ign OC pin & enable interrupt
//    TCTL1 = (TCTL1 & 0xFB) | (ign_setpin << 2);
    if (ign_setpin) {
        TCTL1 |= 0x04;
    } else {
        TCTL1 &= ~0x04;
    }
    TIE |= 0x20;
    TFLG1 = 0x20;	 // clear ign OC interrupt flag

    //	    goto START_INJ;

    //*******************************************************************************

START_INJ:
//if (outpc.istatus5 == 0) {
//    outpc.istatus5 = outpc.status4;
//}
    // Set up for Injector squirt(s)
    if(igncount == 0)
        asecount++;
    egocount++;

    flagbyte3 |= flagbyte3_samplemap;

    staged_num_events++;

    // Turn on fuel pump
    PORTE |= 0x10;
    outpc.engine |= 0x01;   // set engine running

    //low-res period timer
    lowres = lowres_ctr;
    lowres_ctr = 0;

    //do tacho output
    if ((flash5.tacho_opt & 0x80) && (flash4.userlevel > 127)) {
        unsigned char tmp_opt;
        if (flash5.tacho_opt & 0x40) {
            if (flagbyte0 & flagbyte0_to) {
                flagbyte0 &= ~flagbyte0_to;
                tacho_targ = lowres;
            } else {
                flagbyte0 |= flagbyte0_to;
                tacho_targ = 1; // i.e. turn off asap
                goto NO_TACHSET;
            }
        } else {
            tacho_targ = lowres >>1;
        }
        tmp_opt = flash5.tacho_opt & 0x3f;
        if (tmp_opt == 0) {
            PORTT |= 0x20;
        } else if (tmp_opt == 1) {
            PORTT |= 0x80;
        } else if (tmp_opt == 2) {
            PORTT |= 0x40;
        } else if (tmp_opt == 3) {
            PORTA |= 0x01;
        } else if (tmp_opt == 4) {
            PORTM |= 0x04;
        } else if (tmp_opt == 5) {
            PORTM |= 0x08;
        } else if (tmp_opt == 6) {
            PORTM |= 0x10;
        } else if (tmp_opt == 7) {
            PORTM |= 0x20;
        }
    }
NO_TACHSET:

    if(outpc.engine & 0x02)goto SCHED_SQUIRT;
    if(!(flagbyte3 & flagbyte3_toothinit))goto SCHED_SQUIRT;

    igncount++;
    if (flash4.Divider == 1) {
        EAElag_squirting = 0;
        goto SCHED_SQUIRT;
    } else {
        if(igncount < flash4.Divider) {
            if (!(flagbyte2 & flagbyte2_EAElag)) {
                if ((EAElagcomp_squirts > 0) && (EAElagcomp_squirts < num_cyl)) {
                    EAElagcomp_squirts++;
                    EAElag_squirting = 1;
                    goto SCHED_SQUIRT_NOEAE;
                }
                EAElagcomp_squirts = 0;
                EAElag_squirting = 0;
                goto IC_EXIT;				  // skip Divider tach pulses
            } else {
                EAElagcomp_squirts++;
                if (EAElagcomp_squirts == num_cyl) {
                    EAElagcomp_squirts = 0;
                }
                EAElag_squirting = 1;
                goto SCHED_SQUIRT_NOEAE;
            }
        }
    }

SCHED_SQUIRT:
    if (flash4.EAEOption) {
        WF1 += AWA1;
        if (SOA1 <= WF1) {
            WF1 -= SOA1;
        } else {
            WF1 = 0;
        }
        WF2 += AWA2;
        if (SOA2 <= WF2) {
            WF2 -= SOA2;
        } else {
            WF2 = 0;
        }
    }
    igncount = 0;

SCHED_SQUIRT_NOEAE:
    if(flash4.RevLimOption & 2)  {
        if (outpc.rpm > RevLimRpm2) {
            // Cut fuel for Over Rev
            outpc.status3 |= status3_cut_fuel;
        } else if (outpc.rpm < RevLimRpm1) {
            // restore fuel
            outpc.status3 &= ~status3_cut_fuel;
        }
        if (outpc.status3 & status3_cut_fuel)  {
            outpc.pw1 = 0;   // Jedrik fix - let world know injectors are off
            outpc.pw2 = 0;
            goto IC_EXIT;
        }
    }
    if (flash4.OverBoostOption & 0x01) {
        if (outpc.status2 & status2_overboost_active) {
            outpc.status3 |= status3_cut_fuel;
        } else {
            outpc.status3 &= ~status3_cut_fuel;
        }
        if (outpc.status3 & status3_cut_fuel)  {
            outpc.pw1 = 0;   // Jedrik fix - let world know injectors are off
            outpc.pw2 = 0;
            goto IC_EXIT;
        }
    }

    if (outpc.engine & 0x02) { // if engine cranking
        flagbyte3 &= ~flagbyte3_toothinit;
        if ((!(flagbyte3 & flagbyte3_toothinit)) && (flash4.Alternate & 0x02)) { 
            // alternate during cranking option
            goto DO_ALT;
        }
        sched_both = 1;
        goto SCHED1;
    }

    // run mode
    if (flash10.feature3 & 0x08) {
        if (tooth_no == tooth_init) {  // wait for chosen tooth
            if (!(flagbyte3 & flagbyte3_toothinit)) {
                flagbyte3 |= flagbyte3_toothinit;
                igncount = 0;
                altcount = 1;
            }
        } else {
            if (!(flagbyte3 & flagbyte3_toothinit)) {
                sched_both = 1;
                goto SCHED1;
            }
        }
    } else {
        flagbyte3 |= flagbyte3_toothinit;
    }

    if (!(flash4.Alternate & 0x01))  { // if no alternate option (i.e. simultaneous)
        sched_both = 1;
        goto SCHED1;
    }

DO_ALT:
    sched_both = 0;
    altcount = 1 - altcount;
    if(altcount)
        goto SCHED2;

SCHED1:
    /* Catch a rare race condition that can cause semi-sequential
     * to pick the wrong tooth
     */ 
    if ((flash10.feature3 & 0x08) && (tooth_init != tooth_no)) {
        flagbyte3 &= ~flagbyte3_toothinit;
        sched_both = 1;
    }
    // Turn On Inj1
    // Set up to turn Off Inj1 when get to pw us
    inj1cntdown = injtime;
    if (EAElag_squirting) {
        outpc.pw1 = pwcalc_eae1;
        inj1cntdown = injtime_EAElagcomp;
    } else {
        outpc.pw1 = pwcalc1;
    }
    igncount = 0; 

    if(!sched_both) {
        goto IC_EXIT;
    }

SCHED2:
    inj2cntdown = injtime;
    // Set up to turn Off Inj2 when get to pw us
    if (EAElag_squirting) {
        outpc.pw2 = pwcalc_eae2;
        inj2cntdown = injtime_EAElagcomp;
    } else {
        outpc.pw2 = pwcalc2;
    }

IC_EXIT:
    if (false_mask_crk) {
        // Set up to re-enable IC interrupt in Timer ISR after a part of the time
        //  to next IC has elapsed to avoid noise false interrupts
        t_enable_IC = ltch_lmms + false_mask_crk;
        TIE &= ~0x01;   // disable interrupt
        TFLG1 = 0x01;		// clear flag
    } else {
        t_enable_IC = 0xffffffff; // keep int enabled
    }

    //IC_END:
    //    outpc.istatus5 = TCNT - TC0; // how long did ISR take

    return;
}
