/* $Id: ms2_extra_ign.c,v 1.100.6.32 2009/02/08 15:22:00 jsmcortina Exp $ */
#include "ms2_extra.h"

unsigned char decode_errs;
unsigned long dtpred_adder;

void ign_reset(void)
{
    // enter here at init and when in stall condition
    // Disable IC, Ign,Inj OC interrupts
    //    TIE &= 0x94; // may need review
    TIE = 0; // disable all IC/OC ints. Re-enable as required in a mo
    TSCR1 = 0x80;  // always leave timer enabled
    // reinitialize

    if (resetholdoff == 0) { // not within burn timeout period
        PORTE &= ~0x10;   // Turn off fuel Pump. // try again here
        outpc.engine = 0;
        outpc.rpm = 0;
        flagbyte2 |= flagbyte2_crank_ok;
        if (((flash4.spk_mode & 0x1f) == 2) && (flash4.spk_conf2 & 1)) {
            // Set HEI bypass to 0v
            PTM |= 0x10;
        }
    }

    tooth_diff_this = 0;
    tooth_diff_last = 0;
    tooth_diff_last_1 = 0;
    tooth_diff_last_2 = 0;
    TC_ovflow = 0;
    pulse_no = 0;  // This will inhibit overflow counters
    t_enable_IC = 0xFFFFFFFF;
    t_enable_IC2 = 0xFFFFFFFF;
    igncount = 0;
    altcount = 0;
    egocount = 0;
    egopstat[0] = egopstat[1] = 0;
    tpsaclk = 0;
    asecount = 0;
    outpc.status3 &= ~status3_cut_fuel;
    knk_clk = 0;
    knk_clk_test = flash4.knk_trtd;
    knk_stat = 0;
    knk_count = 0;
    outpc.knk_rtd = 0;
    spark_events = spark_events_a;
    dwell_events = dwell_events_a;

    // Turn off all spark outputs right away
#ifdef MICROSQUIRT
    FIRE_ALL_US;
#else
    FIRE_ALL;
#endif

    // Turn Off injectors
    TCTL2 &= ~0x44;   // set outputs lo in OL1,3
    CFORC |= 0x0A;
    PWME &= ~0x14;	  // turn off pwms
    *pPTMpin[3] &= ~0x08;   // turn off inj led
    outpc.squirt = 0;       // injectors off
    IgnOCpinstate = SPK;
    // enable timer & IC interrupt
    synch = SYNC_FIRST;
    decode_errs = 0;
    if (outpc.status1 & status1_syncok) { // was synced
        outpc.synccnt++;
        outpc.status1 &= ~(status1_syncok | status1_synclatch);
    }
    dtpred_adder = 0;
    TFLG1 = 0xff; // clear all pending ints
    TIE |= 0x01;
    if (flagbyte5 & FLAGBYTE5_CAM) {
        TIE |= TFLG_trig2;  // enable 2nd trig ISR
        flagbyte1 &= ~flagbyte1_trig2active; // reset software flag
        flagbyte2 &= ~flagbyte2_twintrignow; // reset software flag
    }

    pulse_no = 0;
    dwl[0] = 0; // 0 means not in use, so count starts at 1
    dwl[1] = 0;
    dwl[2] = 0;
    dwl[3] = 0;
    dwl[4] = 0;
    dwl[5] = 0;
    dwl[6] = 0;
    dwl[7] = 0;
    trig2cnt = 0;
    tooth_no = 0;
    flagbyte3 &= ~flagbyte3_toothinit;
    flagbyte1 &= ~flagbyte1_trig2active; // clear 2nd trig
    tooth_counter = 0;
    tooth_counter_main = 0;
    syncerr = 0;
    flagbyte0 &= ~flagbyte0_firstrpm;
    firstsync_iter = 0;
    NoiseFilterMin = 0;
    return;
}

int coil_dur_table(int delta_volt)
{
    int ix;
    long interp, interp3;
    // returns correction for coil duration vs battery voltage deviation
    //  from 12 V from table lookup in .1 ms units
    // bound input arguments
    if(delta_volt > flash4.deltV_table[NO_COILCHG_PTS-1])  {
        return((int)flash4.deltDur_table[NO_COILCHG_PTS-1]);
    }
    if(delta_volt < flash4.deltV_table[0])  {
        return((int)flash4.deltDur_table[0]);
    }
    // delta_volt in V x 10
    for(ix = NO_COILCHG_PTS - 2; ix > -1; ix--)  {
        if(delta_volt > flash4.deltV_table[ix])  {
            break;
        }
    }
    if(ix < 0)ix = 0;

    interp = flash4.deltV_table[ix + 1] - flash4.deltV_table[ix];
    if(interp != 0)  {
        interp3 = (delta_volt - flash4.deltV_table[ix]);
        interp3 = (100 * interp3);
        interp = interp3 / interp;
        if(interp < 0)interp = 0;
    }
    return((int)(flash4.deltDur_table[ix] +
                interp * (flash4.deltDur_table[ix+1] - flash4.deltDur_table[ix])/ 100));
}

void wheel_fill_event_array(ign_event *spark_events_fill, ign_event *dwell_events_fill,
	                    int spk_ang, int dwl_ang, ign_time last_tooth_time,
			    unsigned int last_tooth_ang, unsigned char rotary)
{
    char start, stop, iterate, tth, wfe_err;
    int tth_ang, tmp_ang, i, j;
    ign_time spk_time, dwl_time;
    long tmptime;

    if(rotary) {
        start = 2;
        stop = 4;
    } else {
        start = 0;
        stop = no_triggers;
    }
    for (i = start; i < stop; i++) {
        if (rotary) {
            j = i - 2;
        } else {
            j = i;
        }
        wfe_err = 0;
        iterate = 0;
        tth_ang = trig_angs[j]; // trigger angle for this trigger to allow for oddfire
        tth = trigger_teeth[j];
        while (!iterate) {
            if (tth_ang > spk_ang) {  // must both be signed to get comparison to work
                // found a suitable tooth
                iterate = 1;
            } else {
                //how far do we step back in deg
                tth--;
                if (tth < 1) {
                    tth = last_tooth;
                    wfe_err++;
                    if (wfe_err > 1) {
                        iterate = 2;
                    }
                }
                tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
            }
        } // end while


        if (iterate == 2) {
            DISABLE_INTERRUPTS;
            asm ( "nop\n" ); // something screwed up, place for breakpoint
            ENABLE_INTERRUPTS;
            // can't continue as didn't find a valid tooth
            return;
        }

        tmp_ang = tth_ang - spk_ang; // angle after trigger tooth we found
        //convert this small angle to time
        spk_time.time_32_bits = (tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang;

        wfe_err = 0;
        while ((wfe_err < 2) && (spk_time.time_32_bits < SPK_TIME_MIN)) {
            // too soon after tooth, need to step back
            tth--;
            if (tth < 1) {
                tth = last_tooth;
                wfe_err++;
            }
            tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
            // recalc
            tmp_ang = tth_ang - spk_ang;
            spk_time.time_32_bits = (tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang;
        }

        if (wfe_err > 1) {
            DISABLE_INTERRUPTS;
            asm ( "nop\n" ); // something screwed up, place for breakpoint
            ENABLE_INTERRUPTS;
            // can't continue as didn't find a valid tooth
            return;
        }

        spark_events_fill[(unsigned int)i].tooth = tth;
        spark_events_fill[(unsigned int)i].time = spk_time;
        spark_events_fill[(unsigned int)i].coil = i;

        // Code limits spark advance so spark point should always be ahead of or after
        // the trigger and not crossing it.
        // During next-cyl cranking we set this flag.
        // to force a spark at trigger.
        tmptime = (spk_ang * last_tooth_time.time_32_bits) / last_tooth_ang;

        if ((flash4.dwellmode & 3) == 3) {
            //if "charge on trigger", then dwell on same tooth as scheduling spark
            //might be ok for MSD in basic dizzy mode. Might give unpredictable short pulses
            // when combined with wheel mode.
            dwell_events_fill[(unsigned int)i].tooth = spark_events_fill[(unsigned int)i].tooth;
            dwell_events_fill[(unsigned int)i].time32 = 0;
        } else {
            // do normal dwell - assume that it must always start ahead of spark
            // so start from spark tooth

            wfe_err = 0;
            iterate = 0;
            while (!iterate) {
                if (tth_ang > dwl_ang) {
                    // found a suitable tooth
                    iterate = 1;
                } else {
                    //how far do we step back in deg
                    tth--;
                    if (tth < 1) {
                        tth = last_tooth;
                        wfe_err++;
                        if (wfe_err > 1) {
                            iterate = 2;
                        }
                    }
                    tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
                }
            } // end while

            if (iterate == 2) {
                DISABLE_INTERRUPTS;
                asm ( "nop\n" ); // something screwed up, place for breakpoint
                ENABLE_INTERRUPTS;
                // can't continue as didn't find a valid tooth
                return;
            }

            tmp_ang = tth_ang - dwl_ang; // angle after trigger tooth we found
            //convert this small angle to time
            dwl_time.time_32_bits = (tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang;

            wfe_err = 0;
            while ((wfe_err < 2) && (dwl_time.time_32_bits < SPK_TIME_MIN)) {
                // too soon after tooth, need to step back
                tth--;
                if (tth < 1) {
                    tth = last_tooth;
                    wfe_err++;
                }
                tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
                // recalc
                tmp_ang = tth_ang - dwl_ang;
                dwl_time.time_32_bits = (tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang;
            }

            if (wfe_err > 1) {
                DISABLE_INTERRUPTS;
                asm ( "nop\n" ); // something screwed up, place for breakpoint
                ENABLE_INTERRUPTS;
                // can't continue as didn't find a valid tooth
                return;
            }

            dwell_events_fill[(unsigned int)i].tooth = tth;
            dwell_events_fill[(unsigned int)i].time = dwl_time;
        }
        dwell_events_fill[(unsigned int)i].coil = i;

        // if dwell has stepped back then force dwell on tooth just before spark
        // or if dwell is on same tooth but fairly short then force it
        if ((dwell_events_fill[(unsigned int)i].tooth != spark_events_fill[(unsigned int)i].tooth)
                || ( (dwell_events_fill[(unsigned int)i].tooth == spark_events_fill[(unsigned int)i].tooth)
                    && (dwell_events_fill[(unsigned int)i].time32 < 150)
                    && (dwell_events_fill[(unsigned int)i].time32 >= 0) ) ) {
            spark_events_fill[(unsigned int)i].ftooth = spark_events_fill[(unsigned int)i].tooth;
        } else {
            spark_events_fill[(unsigned int)i].ftooth = 0;
        }
    }
}

void syncfirst(void)
{
    signed int tmp_tooth;
    unsigned char i;
    tmp_tooth = 32767;
    fuel_cntr = 0;

    for (i = 0 ; i < no_triggers ; i++) {
        signed int tmp_tooth2;
        tmp_tooth2 = (signed int)trigger_teeth[i] - (signed int)tooth_no;
        if ( (tmp_tooth2 > 0) && (tmp_tooth2 < tmp_tooth)) {
            tmp_tooth = tmp_tooth2;
            fuel_cntr = i;
        }
    }

    next_spark.time = spark_events[fuel_cntr].time;
    next_spark.tooth = spark_events[fuel_cntr].tooth;
    next_spark.coil = spark_events[fuel_cntr].coil;
    next_spark.ftooth = spark_events[fuel_cntr].ftooth;
    next_spark.fs = spark_events[fuel_cntr].fs;
    next_dwell.time = dwell_events[fuel_cntr].time;
    next_dwell.tooth = dwell_events[fuel_cntr].tooth;
    next_dwell.coil = dwell_events[fuel_cntr].coil;
    // don't use ftooth or fs in dwell array
    next_fuel = trigger_teeth[fuel_cntr];
    if ((next_spark.tooth != 0) &&
            (next_dwell.tooth != 0)) {
        synch &= ~SYNC_FIRST;  // must have non zero values before declaring sync not first
    }

    if (((flash4.spk_mode & 0x1f) == 4) && (flash10.RotarySplitMode & 0x20)) {
        next_spk_trl.time = spark_events[2].time;
        next_spk_trl.tooth = spark_events[2].tooth;
        next_spk_trl.coil = spark_events[2].coil;
        next_dwl_trl.time = dwell_events[2].time;
        next_dwl_trl.tooth = dwell_events[2].tooth;
        next_dwl_trl.coil = dwell_events[2].coil;   
        if ((next_spk_trl.tooth != 0) && (next_dwl_trl.tooth != 0)) {
            synch &= ~SYNC_FIRST;  // must have non zero values before declaring sync not first
        }
    }

}

void SET_COIL(unsigned char *coil, unsigned char *bits) {
    if (flash10.RotarySplitMode & 0x20) {
	if (*coil == TRIGA) {
	    *bits |= COILABIT;
	} else if (*coil == TRIGB) {
	    *bits |= COILBBIT;
	} else if (*coil == TRIGC) {
	    *bits |= COILCBIT;
	} else if (*coil == TRIGD) {
	    *bits |= COILDBIT;
	}
    } else {
	if (*coil == TRIGA) {
	    *bits |= COILABIT;
	} else if (*coil == TRIGB) {
	    if (num_spk == 1) {
		*bits |= COILABIT;
	    } else {
		*bits |= COILBBIT;
	    }
	} else if (*coil == TRIGC) {
	    if (num_spk == 1) {
		*bits |= COILABIT;
	    } else if (num_spk == 2) {
		*bits |= COILABIT;
	    } else {
		*bits |= COILCBIT;
	    }
	} else if (*coil == TRIGD) {
	    if (num_spk == 1) {
       		*bits |= COILABIT;
	    } else if (num_spk == 2) {
		*bits |= COILBBIT;
	    } else if (num_spk == 3) {
		*bits |= COILABIT;
	    } else {
		*bits |= COILDBIT;
	    }
	} else if (*coil == TRIGE) {
	    if (num_spk == 1) {
		*bits |= COILABIT;
	    } else if (num_spk == 2) {
		*bits |= COILABIT;
	    } else if (num_spk == 3) {
		*bits |= COILBBIT;
	    } else if (num_spk == 4) {
		*bits |= COILABIT;
	    } else {
		*bits |= COILEBIT;
	    }
	} else if (*coil == TRIGF) {
	    if (num_spk == 1) {
		*bits |= COILABIT;
	    } else if (num_spk == 2) {
		*bits |= COILBBIT;
	    } else if (num_spk == 3) {
		*bits |= COILCBIT;
	    } else if (num_spk == 4) {
		*bits |= COILBBIT;
	    } else {
		*bits |= COILFBIT;
	    }
	} else if (*coil == TRIGG) {
	    if (num_spk == 1) {
		*bits |= COILABIT;
	    } else if (num_spk == 2) {
		*bits |= COILABIT;
	    } else if (num_spk == 4) {
		*bits |= COILCBIT;
	    } else {
		*bits |= COILGBIT;
	    }
	} else if (*coil == TRIGH) {
	    if (num_spk == 1) {
		*bits |= COILABIT;
	    } else if (num_spk == 2) {
		*bits |= COILBBIT;
	    } else if (num_spk == 4) {
		*bits |= COILDBIT;
	    } else {
		*bits |= COILHBIT;
	    }
	}
    }
}
