/* $Id: ms2_extra_idle.c,v 1.1.2.22 2009/06/10 04:34:23 culverk Exp $ */

#include "ms2_extra.h"

long PV_last[2];
int pwmidle_stepsize, pwmidle_numsteps, pwmidle_num_intervals;
unsigned int pwmidle_targ_stepsize, pwmidle_targ_numsteps, pwmidle_targ_last;
unsigned int targ_rpm;
char valve_closed, last_direction;

#define LAST_DIRECTION_UNDEF 0
#define LAST_DIRECTION_CLOSE 1
#define LAST_DIRECTION_OPEN  2

#define PWMIDLE_RESET_PID 0
#define PWMIDLE_RESET_JUSTLIFTED 1
#define PWMIDLE_RESET_DONOTHING 2
#define PWMIDLE_RESET_JUSTCRANKED 3
#define PWMIDLE_RESET_CALCNEWTARG 6


void idle_ctl_init(void)
{
    IACmotor_reset = 2;
    pwmidle_timer = 0;
    pwmidle_stepsize = 0;
    pwmidle_numsteps = 0;
    pwmidle_targ_stepsize = 0;
    pwmidle_targ_numsteps = 0;
    pwmidle_targ_last = 0;
    pwmidle_num_intervals = 1000 / flash5.pwmidle_ms;
    PV_last[0] = PV_last[1] = 0;
    last_direction = LAST_DIRECTION_UNDEF;
}

void idle_test_mode(void)
{
int pos_tmp;
    pos_tmp = pg8_ptr->iacpostest; // adding this temp var halves the code size for this if {} section
    //for PWM valves, scale the result
    if ((flash4.IdleCtl & 0xfd) == 4) { // 4 or 6
        if (pos_tmp > 100) {
            pos_tmp = 100;
        }
        IACmotor_pos = (pos_tmp * 256) / 100; // means user enters 0-100% // sensible code with temp var, crap without
    } else {
        IACmotor_pos = pos_tmp;
    }

    if ((pg8_ptr->iactest) & 1) { // home feature
        pg8_ptr->iactest &= ~1; // clear the bit
#ifndef MICROSQUIRT
        IACmotor_reset = 0;
        if ((IdleCtl == 2) || (IdleCtl == 3) ||
                (IdleCtl == 5) || (IdleCtl == 7) ||
                (IdleCtl == 8)) {
            DISABLE_INTERRUPTS;
            IACmotor_pos = 0;
            outpc.iacstep = pg8_ptr->iachometest;  // set current motor step position
            ENABLE_INTERRUPTS;
            (void)move_IACmotor();
        }
    } else if ((outpc.iacstep != IACmotor_pos)) {
        // move IAC motor to new step position
        move_IACmotor();
#endif
    }
}

void idle_on_off(void)
{
    if(outpc.clt < flash4.FastIdle - flash4.IdleHyst)
        *pPTMpin[2] |= 0x04;             // turn on fast idle solenoid
    else if(outpc.clt > flash4.FastIdle)
        *pPTMpin[2] &= ~0x04;            // turn off fast idle solenoid
}

void idle_iac_warmup(void)
{
    int tmp1, tmp2;
    unsigned int pos;

    pos = intrp_1ditable(outpc.clt, 4, (int *)pg5_ptr->pwmidle_crank_clt_temps,
                             (unsigned int *)pg5_ptr->pwmidle_crank_dutyorsteps);

    // In cranking mode. The very first time we crank we want to
    //  open to crankpos, but after cranking we don't want to do
    // this because of an ignition reset (in which rpm = 0)
    if(((outpc.rpm || (flagbyte3 & flagbyte3_firstIAC))) && (outpc.rpm < flash4.crank_rpm))  {
        tmp1 = CW_table(outpc.clt,(int *)flash4.iacstep_table, (int *)flash4.temp_table);
        if(tmp1 < pos)  {
            tmp1 = pos;   // want IAC open at 
            // least this much during cranking regardless of temp
        }
        tble_motor_pos = tmp1;
    }

    // after cranking flare back to normal temperature dependent pos
    if((outpc.seconds >= tcrank_done) &&
            (outpc.seconds <= tcrank_done + flash4.IACcrankxt))  {
        tmp1 = CW_table(outpc.clt,(int *)flash4.iacstep_table, (int *)flash4.temp_table);
        if(tmp1 <= pos) {
            tmp2 =(int)((long)((pos - tmp1) / flash4.IACcrankxt) * 
                    (outpc.seconds - tcrank_done));
            tmp1 = pos - tmp2;
        }
        tble_motor_pos = tmp1;
        flagbyte3 &= ~flagbyte3_firstIAC;

        //  switch to time based control if cold enough at startup
    } else if((outpc.seconds >= tcold_pos) &&
            (outpc.seconds <= tcold_pos + flash4.IACcoldxt))  {
        tmp1 = CW_table(outpc.clt,(int *)flash4.iacstep_table, (int *)flash4.temp_table);
        if(tmp1 <= flash4.IACcoldpos) {
            tmp2=(int)((long)(flash4.iacstep_table[NO_TEMPS-1] - flash4.IACcoldpos)
                    *(tcold_pos + flash4.IACcoldxt - outpc.seconds) /flash4.IACcoldxt);
            tmp1 = flash4.iacstep_table[NO_TEMPS-1] - tmp2;
        }
        tble_motor_pos = tmp1;

        // check if there has been a significant change in clt temp
    } else if((outpc.clt < last_iacclt - flash4.IdleHyst) ||
            (outpc.clt > last_iacclt))  {
        tble_motor_pos = CW_table(outpc.clt,(int *)flash4.iacstep_table, (int *)flash4.temp_table);
    }
    tmp1 = tble_motor_pos + flash4.IdleAdj;
    if(tmp1 < 0)tmp1 = 0;
    IACmotor_pos = tmp1;

    if(outpc.iacstep != IACmotor_pos)  {
        // move IAC motor to new step position
#ifndef MICROSQUIRT
        if(IdleCtl != 4)  {
            if(move_IACmotor())
                last_iacclt = outpc.clt;
        } else {
            last_iacclt = outpc.clt;
        }
#endif
    }

    // check if/ when to start extended time-based idle control
    if(start_clt < flash4.IACcoldtmp)  {
        if((outpc.seconds > tcrank_done) && (tcold_pos == 0xFFFF) &&
                (IACmotor_pos > flash4.IACcoldpos))
            tcold_pos = outpc.seconds;
    }

#ifndef MICROSQUIRT
    if((flash4.IdleCtl == 5) && (outpc.seconds > 900))  {
        IdleCtl = 2;
        if(!IAC_moving)
            PORTB |= 0x10;  // disable current to stepper motor(bit=1)
    }
#endif
}

void idle_pwm_warmup(void)
{
    int tmp1, tmp2;
    unsigned int pos;

    pos = intrp_1ditable(outpc.clt, 4, (int *)pg5_ptr->pwmidle_crank_clt_temps,
                             (unsigned int *)pg5_ptr->pwmidle_crank_dutyorsteps);

    //pwmidle warmup only simplified
    if (outpc.engine & 0x02) {
        DISABLE_INTERRUPTS;
        IACmotor_pos = pos;
        ENABLE_INTERRUPTS;
    } else {
        // after cranking taper back to normal temperature dependent pos
        // 0% duty is fully closed
        if (outpc.clt < flash4.temp_table[0]) {
            tmp2 = flash4.pwmidle_table[0];
        } else if (outpc.clt > flash4.temp_table[9]) {
            tmp2 = flash4.pwmidle_table[9];
        } else {
            tmp2 = CW_table(outpc.clt,(int *)pg4_ptr->pwmidle_table, (int *)flash4.temp_table);
        }

        if((outpc.seconds >= tcrank_done) &&
                (outpc.seconds <= tcrank_done + flash5.pwmidlecranktaper))  {
            // check for taper requirement
            if(IACmotor_pos < pos) {
                /* should be (cranking pos - end pos) / seconds */
                tmp1 = (pos - tmp2) / flash5.pwmidlecranktaper;
                /* now multiply this by the current number of seconds past */
                tmp1 *= (outpc.seconds - tcrank_done);
                tmp2 = pos - tmp1;
            } else {
                tmp2 = pos - 1;
            }
        }

        //check range
        DISABLE_INTERRUPTS;
        if (tmp2 > 255) {
            IACmotor_pos = 255;
        } else if (tmp2 < 0) {
            IACmotor_pos = 0;
        } else {
            IACmotor_pos = tmp2;
        }
        ENABLE_INTERRUPTS;
    }
}

void idle_closed_loop_throttlepressed(int rpm_thresh)
{
    int pos = IACmotor_pos;

    outpc.status2 &= ~0x80;

    if (outpc.rpm > rpm_thresh) {  /* should we close the valve? */
        /* Did the user just cross the rpm threshold? */
        if (IACmotor_pos == IACmotor_last) {
            /* IF so, the number of steps is the delay in ms divided by how 
             * often we will run, and the step size is the amount to move total
             * divided by the number of steps
             */
            if (flash5.pwmidle_close_delay) {
                pwmidle_numsteps = ((long)(flash5.pwmidle_close_delay * 1000)) / 
                    flash5.pwmidle_ms;
                if (pwmidle_numsteps > 0) {
                    pwmidle_stepsize = (IACmotor_pos - flash5.pwmidle_closed_duty) /
                        pwmidle_numsteps;
                } else {
                    pos = flash5.pwmidle_closed_duty;
                    valve_closed = 1;
                }

                if (pwmidle_stepsize == 0) {
                    pwmidle_stepsize = 1;
                }
            } else {
                pos = IACmotor_last;
                valve_closed = 1;
            }
        }
        if (flagbyte2 & flagbyte2_runidle) {
            if ((pos > flash5.pwmidle_closed_duty) && !valve_closed) {
                pos -= pwmidle_stepsize;
            }
            if (pos <= flash5.pwmidle_closed_duty) {
                pos = flash5.pwmidle_closed_duty;
                valve_closed = 1;
            }

            DISABLE_INTERRUPTS;
            flagbyte2 &= ~flagbyte2_runidle;
            IACmotor_pos = pos;
            ENABLE_INTERRUPTS;
        }
    }

    pwmidle_reset = PWMIDLE_RESET_JUSTLIFTED;

    DISABLE_INTERRUPTS;
    idle_wait_timer = 0;
    ENABLE_INTERRUPTS;
    last_rpm = outpc.rpm;
}

void idle_closed_loop_throttlelifted(int rpm_thresh)
{
    PV_last[0] = PV_last[1] = 0;
    DISABLE_INTERRUPTS;
    if (valve_closed) {
        IACmotor_pos = IACmotor_last + flash5.pwmidle_dp_adder;
        valve_closed = 0;
    }
    if (IACmotor_pos < IACmotor_last) { /* partial close */
        IACmotor_pos = IACmotor_last;
    }
    if (IACmotor_pos > (int)flash5.pwmidle_open_duty) {
        IACmotor_pos = flash5.pwmidle_open_duty;
    }
    ENABLE_INTERRUPTS;

    /* if rpm is below rpm threshold, just enable PID */
    if(outpc.rpm <= rpm_thresh) {
        DISABLE_INTERRUPTS;
        idle_wait_timer = 0;
        ENABLE_INTERRUPTS;
        pwmidle_reset = PWMIDLE_RESET_CALCNEWTARG;
        return;
    }

    /* check for PID lockout */
    if (flagbyte2 & flagbyte2_runidle) {
        int rpmdot;

        DISABLE_INTERRUPTS;
        flagbyte2 &= ~flagbyte2_runidle;
        ENABLE_INTERRUPTS;

        rpmdot = (pwmidle_num_intervals * ((int)outpc.rpm - (int)last_rpm));
        last_rpm = outpc.rpm;

        if (rpmdot < 0) {
            rpmdot = -rpmdot;
        }

        if (idle_wait_timer >= flash5.pwmidle_pid_wait_timer) {
            if (rpmdot < flash5.pwmidle_rpmdot_threshold) {
                if (outpc.fuelload > flash5.pwmidle_decelload_threshold) {
                    pwmidle_reset = PWMIDLE_RESET_CALCNEWTARG;
                }
            }
        }
    }
}

void idle_closed_loop_pid(int targ_rpm)
{
    int pwmidle_deriv, rpm_error, tmp1, rpm;
    long Kp, Ki, Kd, PV, SP;

    DISABLE_INTERRUPTS;
    flagbyte2 &= ~flagbyte2_runidle;
    ENABLE_INTERRUPTS;

    outpc.status2 |= 0x80; // turn on CL indicator

    /* Convert the rpms to generic percents in % * 10000 units.
     * Avoid going below the min rpm set by the user.
     * That will cause a large duty cycle spike
     */
    rpm = outpc.rpm;

    if (rpm < flash5.pwmidle_min_rpm) {
        rpm = flash5.pwmidle_min_rpm;
    }

    PV = ((long)(rpm - flash5.pwmidle_min_rpm) * 10000) /
        (flash5.pwmidle_max_rpm - flash5.pwmidle_min_rpm);
    SP = ((long)(targ_rpm - flash5.pwmidle_min_rpm) * 10000) /
        (flash5.pwmidle_max_rpm - flash5.pwmidle_min_rpm);

    if ((pwmidle_reset == PWMIDLE_RESET_CALCNEWTARG) || 
        (pwmidle_reset == PWMIDLE_RESET_JUSTCRANKED)) {
        PV_last[0] = PV_last[1] = PV;
    }

    pwmidle_reset = PWMIDLE_RESET_PID;

    rpm_error = PV - SP;

    pwmidle_deriv = PV - (2*PV_last[0]) + PV_last[1];

    /* don't divide these down (I'm using them as percents)
     * to help get better resolution in the next calcs
     */

    Kp = ((long)((PV - PV_last[0]) * flash5.pwmidle_Kp));
    Ki = (((long)rpm_error * flash5.pwmidle_ms * flash5.pwmidle_Ki) / 1000);
    Kd = ((long)pwmidle_deriv * (((long)flash5.pwmidle_Kd*10)/flash5.pwmidle_ms));

    PV_last[1] = PV_last[0];
    PV_last[0] = PV;

    /* now that we have the raw values in percent to change the output by, we need
     * to convert it down to the actual output's units.
     * To do that we multiply by the open duty - the closed duty, and divide that by
     * 100 (cross multiply). 
     */

    tmp1 = IACmotor_pos - (((long)(Kp + Ki - Kd) *
                          (flash5.pwmidle_open_duty - flash5.pwmidle_closed_duty)) / 
                           10000000);

    if (tmp1 < flash5.pwmidle_min_duty) {
        tmp1 = flash5.pwmidle_min_duty;
    } else if (tmp1 > flash5.pwmidle_open_duty) {
        tmp1 = flash5.pwmidle_open_duty;
    }

    DISABLE_INTERRUPTS;
    IACmotor_pos = tmp1;
    IACmotor_last = IACmotor_pos;
    ENABLE_INTERRUPTS;
}

int idle_closed_loop_newtarg(int targ_rpm)
{
    int new_targ;

    /* This function gradually drops the target from where it is now
     * to the end target
     */
    if ((pwmidle_reset == PWMIDLE_RESET_CALCNEWTARG) ||
        (pwmidle_reset == PWMIDLE_RESET_JUSTCRANKED)) {
        /* first time here, figure out number of steps
         * and the amount per step
         */

        if (outpc.rpm > targ_rpm) {
            pwmidle_targ_numsteps = (flash5.pwmidle_targ_ramptime * 1000) /
                flash5.pwmidle_ms;
            if (pwmidle_targ_numsteps > 0) {
                pwmidle_targ_stepsize = (outpc.rpm - targ_rpm) / pwmidle_targ_numsteps;
                pwmidle_targ_last = outpc.rpm;
                return outpc.rpm;
            } else {
                pwmidle_targ_last = 0;
                return targ_rpm;
            }
        } else {
            pwmidle_targ_last = 0;
            return targ_rpm;
        }
    }

    if (pwmidle_targ_last != 0) {
        new_targ = pwmidle_targ_last - pwmidle_targ_stepsize;
        if (new_targ >= targ_rpm) {
            pwmidle_targ_last = new_targ;
            return new_targ;
        } 
        pwmidle_targ_last = 0;
    }
    return targ_rpm;
}

void idle_closed_loop(void)
{
    unsigned int rpm_thresh, adj_targ, pos;

    targ_rpm = intrp_1ditable(outpc.clt,PWMIDLE_NUM_BINS,(int *)pg5_ptr->pwmidle_clt_temps,
                             (unsigned int *)pg5_ptr->pwmidle_target_rpms);

    rpm_thresh = targ_rpm + flash5.pwmidle_engage_rpm_adder;

    if (outpc.engine & 0x02) {
        pos = intrp_1ditable(outpc.clt, 4, (int *)pg5_ptr->pwmidle_crank_clt_temps,
                             (unsigned int *)pg5_ptr->pwmidle_crank_dutyorsteps); 
        /* cranking */
        DISABLE_INTERRUPTS;
        IACmotor_pos = pos;
        IACmotor_last = pos;
        idle_wait_timer = 0;
        ENABLE_INTERRUPTS;
        valve_closed = 0;
        outpc.status2 &= ~0x80;
        pwmidle_reset = PWMIDLE_RESET_JUSTCRANKED;
    } else {
        if (outpc.tps > (int)flash5.pwmidle_tps_thresh) {
            idle_closed_loop_throttlepressed(rpm_thresh);
        } else {
            if (pwmidle_reset == PWMIDLE_RESET_JUSTLIFTED) {
                idle_closed_loop_throttlelifted(rpm_thresh);
            } else {
                unsigned char timer;

                if (pwmidle_reset == PWMIDLE_RESET_JUSTCRANKED) {
                    timer = flash5.pwmidlecranktaper;
                } else {
                    timer = flash5.pwmidle_pid_wait_timer;
                }

                //outpc.istatus5 = timer;

                if ((flagbyte2 & flagbyte2_runidle) &&
                    (idle_wait_timer >= timer) &&
                     !IAC_moving) {
                    adj_targ = idle_closed_loop_newtarg(targ_rpm);
                    idle_closed_loop_pid(adj_targ);
                }
            }
        }
    }
#ifndef MICROSQUIRT
    if ((IdleCtl == 7) || (IdleCtl == 8)) {
        (void)move_IACmotor();
    }
#endif
}

void idle_ctl(void)
{
    if (IACmotor_reset && (page == 8) && (pg8_ptr->iactest & 2) ) {
        idle_test_mode();
    } else {
        if(IdleCtl == 1)  {
            idle_on_off();
        } else if(((IdleCtl == 2) || (IdleCtl == 3) || (IdleCtl == 5)) && IACmotor_reset)  {
            idle_iac_warmup();
        } else if(IdleCtl == 4) {
            idle_pwm_warmup();
        } else if ((IdleCtl == 6) || (IdleCtl == 7) || (IdleCtl == 8)) {
            idle_closed_loop(); 
        }
    }
}

#ifndef MICROSQUIRT
int move_IACmotor(void)
{
    //unsigned char coils;
    short del;

    if(IAC_moving)return 0;
    del = IACmotor_pos - outpc.iacstep;
    if(del < 0)del = -del;
    if(del < pg4_ptr->IACminstep)return 0;  // new var

    if(IAC_moving || (outpc.iacstep == IACmotor_pos))return 0;
    // set up the motor move

    DISABLE_INTERRUPTS;
    motor_time = lmms + flash4.IAC_tinitial_step;  // units changed to .128 ms
    ENABLE_INTERRUPTS
    PORTB &= ~0x10;  // enable current to motor(bit=0)
    IAC_moving = 2;
    return 1;
}
#endif
