/* $Id: ms2_extra_can_isr.c,v 1.1.2.4 2008/04/22 01:57:39 culverk Exp $ */
#include "ms2_extra.h"

INTERRUPT void CanTxIsr(void)
{
    unsigned char ix,jx,kx;

    /* CAN Xmit Interrupt */
    CANTBSEL = CANTFLG;    // select MSCAN xmit buffer
    // Check ring buffers and xfer to MSCAN buffer
    for (ix = 0;ix < 2;ix++)  {
        if (can[ix].cxno)  {
            jx = can[ix].cxno_out;
            /* Set up identifier registers */
            CAN_TB0_IDR0 = (unsigned char)(can[ix].cx_destvaroff[jx] >> 3);
            // 8 high bits in IDR0, 3 low bits in IDR1
            CAN_TB0_IDR1 = 
                (unsigned char)((can[ix].cx_destvaroff[jx] & 0x0007) << 5) | 
                0x18 |           // SRR=IDE=1
                can[ix].cx_msg_type[jx];			// 3 bits
            CAN_TB0_IDR2 = (flash4.mycan_id << 4) | can[ix].cx_dest[jx];
            CAN_TB0_IDR3 = (can[ix].cx_destvarblk[jx] << 4);
            /* Set xmt buffer priorities (lower is > priority) */
            CAN_TB0_TBPR = 0x02;

            /* set data in buffer */
            switch (can[ix].cx_msg_type[jx])  {
                case MSG_CMD:  // msg for dest ecu to set a variable to val in msg
                case MSG_RSP:  // msg in reply to dest ecu's request for a var val
                    CAN_TB0_DLR = can[ix].cx_varbyt[jx];
                    for (kx = 0;kx < CAN_TB0_DLR;kx++)  {
                        *(&CAN_TB0_DSR0 + kx) = can[ix].cx_datbuf[jx][kx];
                    }
                    break;

                case MSG_REQ:  // msg to send back current value of variable(s)
                    // this 1st byte holds var blk for where to put rcvd data
                    // 2nd,3rd bytes hold var offset rel. to var blk and how
                    // many consecutive bytes to be sent back
                    CAN_TB0_DLR = 3;
                    CAN_TB0_DSR0 = can[ix].cx_myvarblk[jx];
                    CAN_TB0_DSR1 = (unsigned char)(can[ix].cx_myvaroff[jx] >> 3);
                    CAN_TB0_DSR2 = (unsigned char)((can[ix].cx_myvaroff[jx] & 0x0007) << 5) | 
                        can[ix].cx_varbyt[jx];
                    break;

                case MSG_XSUB:
                    CAN_TB0_DLR = 0;
                    break;

                case MSG_BURN:
                    CAN_TB0_DLR = 0;
                    break;
            }
            // This is where (in xmt buffer) to get next outgoing message
            if (can[ix].cxno_out < (NO_CANMSG - 1)) {
                can[ix].cxno_out++;
            } else {
                can[ix].cxno_out = 0;
            }
            if (can[ix].cxno > 0) {
                can[ix].cxno--;    // TB buf loaded for xmit - decrement ring buf count
            }
            can_status &= CLR_XMT_ERR;
            /* set CAN xmt interrupt bit and clear flag to initiate transmit */
            CANTIER |= CANTBSEL;  
            CANTFLG = CANTBSEL;  // 1 clears(buffer full), 0 is ignored
            break;               // only handle 1 buffer entry at time
        }
        if (ix == 1)  {    // nothing left in either ring buffer
            CANTIER = 0x00;  // leave CANTFLG as buffer empty, but disable interrupt
            // Note: if this last xmt in buf, will re-neter ISR, but 
            //  then exit because can[0,1].cxno = 0. 
            break;  
        }
    }		        // end for loop
    if ((CANRFLG & 0x0C) != 0)  {
        // Xmt error count
        can_status |= XMT_ERR;
        //can_reset = 1;
    }
    return;
}

INTERRUPT void CanRxIsr(void)
{
    unsigned char rcv_id,msg_type,var_blk,var_byt,jx,kx;
    unsigned short var_off,dvar_off;

    /* CAN Recv Interrupt */
    if (CANRFLG & 0x01)  {
        var_off = ((unsigned short)CAN_RB_IDR0 << 3) |
            ((CAN_RB_IDR1 & 0xE0) >> 5);
        msg_type = (CAN_RB_IDR1 & 0x07);
        rcv_id = CAN_RB_IDR2 >> 4;		// message from device rcv_id
        var_blk = CAN_RB_IDR3 >> 4;
        var_byt = (CAN_RB_DLR & 0x0F);

        switch(msg_type)  {
            case MSG_CMD:  // msg for this ecu to set a variable to val in msg
            case MSG_RSP:  // msg in reply to this ecu's request for a var val
                // value in the data buffer in recvd msg
                if (flagbyte3 & flagbyte3_getcandat)  {
                    // set up for serial xmit of the recvd CAN bytes (<= 8)
                    //  MT getting back data requested from aux board
                    txcnt = 0;
                    txgoal = var_byt;
                    if ((txgoal > 0) && (txgoal <= 8))  {
                        txmode = 6;
                        for (jx = 0;jx < var_byt;jx++)  {
                            *((char *)&txbuf + jx) = *(&CAN_RB_DSR0 + jx);
                        }
                        SCI0DRL = *((char *)&txbuf);
                        SCI0CR2 &= ~0x24;   // rcv, rcvint disable
                        SCI0CR2 |= 0x88;        // xmit enable & xmit interrupt enable i.e. send the first byte by serial

                    } else  {
                        txgoal = 0;
                        txmode = 0;
                    }
                    flagbyte3 &= ~flagbyte3_getcandat;
                    ltch_CAN = 0xFFFFFFFF;
                    break;
                } else  {
                    unsigned int dest_addr = 0;
                    // update variable value with received data
                    // see if this variable block is in ram at present
                    // if being tuned by remote CAN then we should copy it over,
                    // if being tuned by serial and it isn't in ram then we'll have
                    // to ignore the CAN device
                    // Will never pay any attention to writes to the sensor data

                    if ((var_blk == 4) || (var_blk == 5) || (var_blk == 8) || (var_blk == 9) || (var_blk == 10)) {
                        // jump to common code used by serial code
                        // if tuning remotely still need to copy flash to RAM etc.
                        // concurrent access to tuning data via serial and CAN will cause corruption
                        flagbyte4 |= flagbyte4_cantuning;
                        tble_idx = var_blk;
                        chknewpage();  // success code returned in A
                        __asm__  __volatile__ ("tsta\n"
                                "bne ccnp_skip\n");
                        dest_addr = (unsigned int)&ram_data;
                    } else if (var_blk == 6) {
                        dest_addr = (unsigned int)&txbuf;
                    } else if (var_blk == 7) {
                        dest_addr = (unsigned int)&outpc;
                    }

                    if (dest_addr) {
                        for(jx = 0;jx < var_byt;jx++)  {
                            if (((var_blk == 4) || (var_blk == 5) || (var_blk == 8) || (var_blk == 9) || (var_blk == 10))
                                    && (*((unsigned char *)dest_addr + var_off + jx) != *(&CAN_RB_DSR0 + jx) )) {
                                outpc.status1 |= status1_needburn; // we changed some tuning data
                            }
                            *((unsigned char *)dest_addr + var_off + jx) = *(&CAN_RB_DSR0 + jx);
                        }
                    }
                    __asm__  __volatile__ ("ccnp_skip:\n");
                }
                break;

            case MSG_REQ:  // msg to send back current value of variable(s)
                // Update related parameters for xmt ring buffer
                jx = can[0].cxno_in;
                can[0].cx_msg_type[jx] = MSG_RSP;
                // destination var blk
                can[0].cx_destvarblk[jx] = CAN_RB_DSR0;
                dvar_off = ((unsigned short)CAN_RB_DSR1 << 3) |
                    ((CAN_RB_DSR2 & 0xE0) >> 5);
                can[0].cx_destvaroff[jx] = dvar_off;
                can[0].cx_dest[jx] = rcv_id;
                var_byt = CAN_RB_DSR2 & 0x1F;
                can[0].cx_varbyt[jx] = var_byt;
                // put variable value(s) in xmit ring buffer

                unsigned int dest_addr = 0;
                // update variable value with received data
                // see if this variable block is in ram at present
                // if being tuned by remote CAN then we should copy it over,
                // if being tuned by serial and it isn't in ram then we'll have
                // to ignore the CAN device
                // Will never pay any attention to writes to the sensor data

                unsigned char save_ppage;
                save_ppage = PPAGE;

                if (var_blk < 4) {
                    // CAUTION! forcibly swapping pages to enable access to the lookup data
                    PPAGE = 0x3c;
                    dest_addr = *tables[var_blk].addrFlash;
                } else if ((var_blk == 4) || (var_blk == 5) || (var_blk == 8) || (var_blk == 9) || (var_blk == 10)) {
                    // jump to common code used by serial code
                    // if tuning remotely still need to copy flash to RAM etc.
                    tble_idx = var_blk;
                    flagbyte4 |= flagbyte4_cantuning;
                    chknewpage();
                    __asm__  __volatile__ ("tsta\n"
                            "bne ccnp_skip2\n");
                    dest_addr = (unsigned int)&ram_data; // will be...
                } else if (var_blk == 6) {
                    dest_addr = (unsigned int)&txbuf;
                } else if (var_blk == 7) {
                    dest_addr = (unsigned int)&outpc;
                } else if (var_blk == 14) {
                    dest_addr = (unsigned int)&Signature;
                } else if (var_blk == 15) {
                    dest_addr = (unsigned int)&RevNum;
                }

                if (dest_addr) {
                    for(kx = 0;kx < var_byt;kx++)  {
                        can[0].cx_datbuf[jx][kx] = *((unsigned char *)dest_addr + var_off + kx);
                    }
                }
                PPAGE = save_ppage;
                __asm__  __volatile__ ("ccnp_skip2:\n");

                // This is where (in xmt buffer) to put next messge
                if (can[0].cxno_in < (NO_CANMSG - 1)) {
                    can[0].cxno_in++;
                } else {
                    can[0].cxno_in = 0;
                }
                // increment counter
                if (can[0].cxno < NO_CANMSG) {
                    can[0].cxno++;
                } else {
                    can[0].cxno = NO_CANMSG;
                }
                if (!(CANTIER & 0x07))  {
                    // Following will cause entry to TxIsr without sending msg
                    // since when CANTIER = 0, CANTFLG left as buff empty.
                    // If CANTIER has at least 1 int buf enabled, will enter
                    // TxIsr automatically. 
                    CANTBSEL = CANTFLG;
                    CANTIER = CANTBSEL;
                }
                break;

            case MSG_XSUB:  // msg to execute a subroutine
                switch(rcv_id)  {
                    case 1:           // message to this ecu from device 1
                        can_xsub01();		// execute sub immediately here (set
                        // flag if can execute in main loop) 
                        break;
                }
                break;

            case MSG_BURN:  // msg to burn data table
                Flash_Init(); //check FDIV written to (should be at reset)
                flocker = 0xcc;
                tble_idx = var_blk;
                burntbl();
                outpc.status1 &= ~(status1_lostdata | status1_needburn);
                break;
        }					 // end msg_type switch
        can_status &= CLR_RCV_ERR;
    }
    if ((CANRFLG & 0x72) != 0)  {
        // Rcv error or overrun on receive
        can_status |= RCV_ERR;
        //can_reset = 1;
    }
    /* clear RX buf full, err flags to ready for next rcv int */
    /*  (Note: can't clear err count bits) */
    CANRFLG = 0xC3;

    return;
}

