/* $Id: ms2_extra_can.c,v 1.5.6.7 2009/03/27 16:49:20 jsmcortina Exp $ */
#include "ms2_extra.h"

void CanInit(void)
{
    unsigned char ix;
    /* Set up CAN communications */
    /* Enable CAN, set Init mode so can change registers */
    CANCTL1 |= 0x80;
    CANCTL0 |= 0x01;

    /* clear ring buffers */
    for(ix = 0;ix < 2;ix++)  {
        can[ix].cxno = 0;
        can[ix].cxno_in = 0;
        can[ix].cxno_out = 0;
    }
    can_status = 0;

    while(!(CANCTL1 & 0x01));  // make sure in init mode

    /* Set Can enable, use IPBusclk (24 MHz),clear rest */
    CANCTL1 = 0xC0;  
    /* Set timing for .5Mbits/ sec */
    CANBTR0 = 0xC2;  /* SJW=4,BR Prescaler= 3(24MHz CAN clk) */
    CANBTR1 = 0x1C;  /* Set time quanta: tseg2 =2,tseg1=13 
                        (16 Tq total including sync seg (=1)) */
    CANIDAC = 0x00;   /* 2 32-bit acceptance filters */
    /* CAN message format:
     * Reg Bits: 7 <-------------------- 0
     * IDR0:    |---var_off(11 bits)----|  (Header bits 28 <-- 21)
     * IDR1:    |cont'd 1 1 --msg type--|  (Header bits 20 <-- 15)
     * IDR2:    |---From ID--|--To ID---|  (Header bits 14 <--  7)
     * IDR3:    |--var_blk-|--spare--rtr|  (Header bits  6 <-- 0,rtr)
     */  
    /* Set identifier acceptance and mask registers to accept 
       messages only for can_id or device #15 (=> all devices) */
    /* 1st 32-bit filter bank-to mask filtering, set bit=1 */
    CANIDMR0 = 0xFF;           // anything ok in IDR0(var offset)
    CANIDAR1 = 0x18;           // 0,0,0,SRR=IDE=1
    CANIDMR1 = 0xE7;		   // anything ok for var_off cont'd, msgtype
    CANIDAR2 = flash4.mycan_id;     // rcv msg must be to can_id, but
    CANIDMR2 = 0xF0;			 // can be from any other device
    CANIDMR3 = 0xFF;           // any var_blk, spare, rtr
    /* 2nd 32-bit filter bank */
    CANIDMR4 = 0xFF;           // anything ok in IDR0(var offset)
    CANIDAR5 = 0x18;           // 0,0,0,SRR=IDE=1
    CANIDMR5 = 0xE7;		   // anything ok for var_off cont'd, msgtype
    CANIDAR6 = 0x0F;			 // rcv msg can be to everyone (id=15), and
    CANIDMR6 = 0xF0;			 // can be from any other device
    CANIDMR7 = 0xFF;           // any var_blk, spare, rtr

    /* clear init mode */
    CANCTL0 &= 0xFE;  
    /* wait for synch to bus */
    while(!(CANCTL0 & 0x10));

    /* no xmit yet */
    CANTIER = 0x00;
    /* clear RX flag to ready for CAN recv interrupt */
    CANRFLG = 0xC3;
    /* set CAN rcv full interrupt bit */
    CANRIER = 0x01;
    ltch_CAN = 0xffffffff;
    return;
}

void can_sendburn()
{
    int ix;
    // set up single CAN message for "burn" & forward to aux board
    // (called from SCI routine)
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_BURN; 
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_destvaroff[ix] = 0;
    can[0].cx_dest[ix] = CANid;
    can[0].cx_varbyt[ix] = 0;		 // no data bytes
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }
}

void can_reqdata()
{
    int ix;
    // set up single CAN message & forward to aux board
    //   MT requesting data from aux board.
    //   Note: MT must only deal with 1 board at a time and wait til
    //   data back or timeout.
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_REQ; 
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_myvarblk[ix] = 6;  // txbuf
    // varblks for the aux boards
    can[0].cx_destvaroff[ix] = rxoffset;
    can[0].cx_myvaroff[ix] = 0;
    can[0].cx_dest[ix] = CANid;
    if (rxnbytes > 8) {
        can[0].cx_varbyt[ix] = 8; // bring data back in 8 byte chunks
    } else {
        can[0].cx_varbyt[ix] = (unsigned char)rxnbytes;
    }
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }
    flagbyte3 |= flagbyte3_getcandat;
    flagbyte3 &= ~flagbyte3_sndcandat;

}

void can_snddata()
{
    int ix;
    unsigned char bk_cnt;
    bk_cnt = (rxnbytes-1) & 0x07; // allow splitting blocks
    // set up single CAN message & forward to aux board
    //   MT sending data to aux board
    for(ix = 0; ix <= bk_cnt; ix++)  {
        can[0].cx_datbuf[can[0].cxno_in][ix] = *((char *)&txbuf + ix + ((rxnbytes-1) & 0xfff8));
    }
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_CMD; 
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_destvaroff[ix] = rxoffset + ((rxnbytes-1) & 0xfff8);
    can[0].cx_dest[ix] = CANid;
    can[0].cx_varbyt[ix] = bk_cnt+1;
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }  
} 

void can_t()
{
    unsigned int ix;
    // set up single CAN message & forward to aux board
    //   MT sending data to aux board
    //  'T' command for remote sensor data
    for(ix = 0; ix < Tcntr; ix++)  {
        can[0].cx_datbuf[can[0].cxno_in][ix] = *((char *)&txbuf + ix);
    }
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_CMD;
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_destvaroff[ix] = 0;
    can[0].cx_dest[ix] = CANid;
    can[0].cx_varbyt[ix] = Tcntr;
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }
}

void can_xsub01(void)
{
    return;
}

