; $Id: ms2_extra_burner.s,v 1.4.10.2 2008/01/15 00:05:08 jsmcortina Exp $
.sect .text
.globl burntbl
.globl RamBurnPgm
.globl ram_data
.globl flash4
.globl flash5
.globl flash10
.globl flash8
.globl flash9
.globl tble_idx

;.nolist
include "s12asmdefs.inc"
;.list

;*********************************************************************
; burn a ram table to flash
; ram table always at same place ram_data
; flash location in lookup table
;
;*********************************************************************
burntbl:
       pshd
       pshx
       pshy
       ldaa    flocker
       cmpa    #0xcc
       bne     burnend
burnok:
       ldab    tble_idx
       cmpb    #4
       bne     bok5
       ldx     #flash4
       bra     bokok
bok5:
       cmpb    #5
       bne     bok7
       ldx     #flash5
       bra     bokok
bok7:
       cmpb    #10
       bne     bok8
       ldx     #flash10
       bra     bokok
bok8:
       cmpb    #8
       bne     bok9 
       ldx     #flash8
       bra     bokok
bok9: 
       cmpb    #9
       bne     burnend
       ldx     #flash9
bokok:
       brclr   FSTAT,#CBEIF,.   ; loop until no command in action 
;erase the 1k sector
       ldaa    FSTAT
       anda    #0x30
       beq     burnerase
       movb    #ACCERR|PVIOL,FSTAT
burnerase:
       ldd     #0xffff
       std     0,x
       movb    #SecErase,FCMD
       ldaa    #CBEIF
       jsr     RamBurnPgm

       ldy     #0  ; burn loop counter

burnlp:

       movb    #ACCERR|PVIOL,FSTAT
       ldd     ram_data,y  ; load/write a word at a time
       std     0,x
       movb    #ProgWord,FCMD
       ldaa    #CBEIF
       jsr     RamBurnPgm

nop  ; provide BP ability in here

       inx
       inx
       iny
       iny
       cmpy    #0x400
       bne     burnlp
burnend:
nop  ; provide BP ability in here
       puly
       pulx
       puld
       rts
