;*********************************************************************
; Misc asm
;*********************************************************************
; $Id: ms2_extra_asm.s,v 1.8.6.4 2009/05/20 23:00:54 jsmcortina Exp $

.sect .text
.globl UnimplementedISR, ckstall

             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extrah.inc"
             include "ms2extra_structs.inc"
             list                 ;turn listing back on

;**************************************************************************
; Miscellaneous code in asm
; **************************************************************************
UnimplementedISR:
   ; Unimplemented ISRs trap
   rti

ckstall:
   brset   synch,#1,cont_ckstall   ; skip if not synced
   jmp	   LM73 

;  check rpm for stall condition (< 50 rpm) after engine synch
;          if((lmms - ltch_lmms) > (18750/num_cyl))  {
cont_ckstall:
   sei
   ldx     lmms
   ldd     lmms+0x2
   subd    ltch_lmms+0x2
   xgdx
   sbcb    ltch_lmms+0x1
   sbca    ltch_lmms      ; result now in d:x
   cli
   cpd     stall_timeout
   blo     end_stall
   bhi     LM70
   cpx     stall_timeout+0x2
   blo     end_stall

LM70:
;              // Engine is stalled, clear all in engine
   bclr	PORTE,#0x10 ; Turn off fuel Pump
;              *pPTMpin[2] &= ~0x04;    	// Turn off fast idle ** Bug Fix By Guy Hill **
   ldx     pPTMpin+0x4
   bclr    0,X,#0x04
   call    ign_reset
   ldd	   #0
   std    outpc.pw1
   std    outpc.pw2
   bset   flagbyte2,0x4
   movw   #0xFFFF,tcrank_done
   clr    running_seconds
   brset   flash4.EAEOption,0x1,EAESet
   jmp     end_stall

EAESet:
   ldd	   #100
   std	   outpc.EAEfcor1
   std     outpc.EAEfcor2
   ldd	   #0
   std	   outpc.wallfuel1
   std     outpc.wallfuel1+0x02
   std     outpc.wallfuel2
   std     outpc.wallfuel2+0x02
   std	   WF1
   std	   WF1+0x02
   std     AWA1
   std     AWA1+0x02
   std	   SOA1
   std	   SOA1+0x02
   std	   WF2
   std	   WF2+0x02
   std     AWA2
   std     AWA2+0x02
   std	   SOA2
   std	   SOA2+0x02
   bra     end_stall

LM73:
   brset   flagbyte1,#2,end_stall  ; skip if in test mode
;      // if no tach pulse within 2 sec
;      else if((lmms - ltch_lmms) > 15625)  {
   ldx     lmms
   ldd     lmms+0x2
   subd    ltch_lmms+0x2
   xgdx
   sbcb    ltch_lmms+0x1
   sbca    ltch_lmms      ; result now in d:x
   tbne    D,LM74
   cpx     #15625
   bls     end_stall

LM74:
   bclr	   PORTE, #0x10   ; // Turn off fuel Pump
;          *pPTMpin[2] &= ~0x04;    	// Turn off fast idle ** Bug Fix By Guy Hill **
   ldx     pPTMpin+0x4
   bclr	   0,X #0x04
   movw    #0,outpc.pw1
   movw    #0,outpc.pw2
   movw	   #0xFFFF,tcrank_done
   clr     running_seconds
   bset	   flagbyte2,0x4
   brclr   flash4.EAEOption,0x1,end_stall
   ldd	   #100
   std	   outpc.EAEfcor1
   std     outpc.EAEfcor2
   ldd	   #0
   std	   outpc.wallfuel1
   std     outpc.wallfuel1+0x02
   std     outpc.wallfuel2
   std     outpc.wallfuel2+0x02
   std	   WF1
   std	   WF1+0x02
   std     AWA1
   std     AWA1+0x02
   std	   SOA1
   std	   SOA1+0x02
   std	   WF2
   std	   WF2+0x02
   std     AWA2
   std     AWA2+0x02
   std	   SOA2
   std	   SOA2+0x02

end_stall:

; also setup PWM duties (also moved from 0.128ms)
;; need to change to pointer to allow realtime tuning
   ldy     pg4_ptr
   ldab	   flash4.InjPWMPd-0x4000,Y  ; HARDCODING
   ldaa    flash4.InjPWMDty-0x4000,Y ; HARDCODING
;   ldab    flash4.InjPWMPd
;   ldaa    flash4.InjPWMDty
;      PWMDTY2 = (unsigned char)((flash4.InjPWMDty * PWMPER2) / 100);
   mul
   ldx     #100
   idivs   ; why signed?
   xgdx
   stab    pwmd1
   brset   flash4.ICIgnOption,#0x20,pwmd_2
   stab    pwmd2   ; same at the moment, but ought to extend so each channel different
   bra     pwmc_end
pwmd_2:
   ldy     pg4_ptr
   ldab	   flash4.InjPWMPd2-0x4000,Y   ; HARDCODING
   ldaa    flash4.InjPWMDty2-0x4000,Y  ; HARDCODING
;   ldab    flash4.InjPWMPd2
;   ldaa    flash4.InjPWMDty2
   mul
   ldx     #100
   idivs
   xgdx
   stab    pwmd2

   pwmc_end:
rtc
