;*********************************************************************
; config error   (C) 2006 James Murray
;*********************************************************************
; $Id: ms2_conferr.s,v 1.14.6.14 2009/03/27 19:09:03 jsmcortina Exp $

.sect .text3a   ; was text3
.globl configerror,realtime
.globl conf_err

             nolist               ;turn off listing
             include "s12asmdefs.inc"
             list                 ;turn listing back on

;kill just about everything and send config error down serial port,
; then sit in loop turning fuel pump on and off
;*********************************************************************
; on entry A contains the config error
;*********************************************************************
.sect .text3a
configerror:
            sei                        ; disable ints until we've sent the message
            movb        #0x00,SCI0CR1
            movb        #0x08,SCI0CR2  ; disable SCI ints, enable tx
			ldx			#20
			bsr			delaylp1		; short delay to ensure everything is ready
;send CR,NL as pre-amble to avoid missed first bytes
            ldx         #cr
            bsr         sendstr        ; uses X

            ldaa        conf_err
            deca
            lsla
            tfr         a,x
            ldx         errtbl,x
            bsr         sendstr        ; uses X
            cli
            movb        #0x00,SCI0CR1
            movb        #0x24,SCI0CR2  ; set back to normal

celoop:
            bset        PORTE,PTE4
            bsr         delay
            bclr        PORTE,PTE4
            bsr         delay
            bra         celoop


;*********************************************************************
;sendstr:      ; send text string down serial port
; on entry X points to start of zero terminated string
;*********************************************************************
sendstr:
            ldaa        SCI0SR1    ; ensure stat reg read as part of sequence
sendstrlp:
            ldaa        ,x
            beq         ssdone
            staa        SCI0DRL
            inx
sswait:
            brset       SCI0SR1,#0x80,sendstrlp ; wait for byte to be sent
            movb        #0x55,ARMCOP      ; keep COP happy
            movb        #0xAA,ARMCOP
            bra         sswait
ssdone:
            rts

;*********************************************************************
;delay:      ; busy wait
;*********************************************************************
delay:
            ldx         #0
delaylp1:
            ldy         #16
delaylp2:
            movb        #0x55,ARMCOP      ; keep COP happy
            movb        #0xAA,ARMCOP
            nop
            nop
            nop
            nop
            dbne        y,delaylp2
            pshx
            pshy
            call         realtime       ; be prepared to send realtime data
            puly
            pulx
            dbne        x,delaylp1
            rts

;*********************************************************************
errtbl:
            fdb         err1
            fdb         err2
            fdb         err3
            fdb         err4
            fdb         err5
            fdb         err6
            fdb         err7
            fdb         err8
            fdb         err9
            fdb         err10
            fdb         err11
            fdb         err12
            fdb         err13
            fdb         err14
            fdb         err15
            fdb         err16
            fdb         err17
            fdb         err18
            fdb         err19
            fdb         err20
            fdb         err21
            fdb         err22
            fdb         err23
            fdb         err24
            fdb         err25
            fdb         err26
            fdb         err27
            fdb         err28
            fdb         err29
            fdb         err30
            fdb         err31
            fdb         err32
            fdb         err33
            fdb         err34
            fdb         err35
            fdb         err36
            fdb         err37
            fdb         err38
            fdb         err39
            fdb         err40
            fdb         err41

cr:         fcb         0x0d,0x0a,0

err1:
            fcc         "Number of teeth/cylinders conflict"
            fcb         0x0d,0x0a,0
err2:
            fcc         "Conflict on realtime baro input pin"
            fcb         0x0d,0x0a,0
err3:
            fcc         "Conflict on 2nd ego input pin"
            fcb         0x0d,0x0a,0
err4:
            fcc         "Conflict on knock sensor input pin"
            fcb         0x0d,0x0a,0
err5:
            fcc         "Conflict on flex fuel input pin"
            fcb         0x0d,0x0a,0
err6:
            fcc         "Conflict with Tacho Output"
            fcb         0x0d,0x0a,0
err7:
            fcc         "Conflict with Launch input"
            fcb         0x0d,0x0a,0
err8:
            fcc         "7, 9, 11, 13+ cyl not supported"
            fcb         0x0d,0x0a,0
err9:
            fcc         "Trigger return and Oddfire not allowed"
            fcb         0x0d,0x0a,0
err10:
            fcc         "Staged injection primary or secondary injector size zero"
            fcb         0x0d,0x0a,0
err11:
            fcc         "Staged triggers cannot be the same"
            fcb         0x0d,0x0a,0
err12:
            fcc         "Staged trigger param 1 or 2 zero"
            fcb         0x0d,0x0a,0
err13:
			fcc         "Second parameter enabled but with zero parameter"
            fcb         0x0d,0x0a,0
err14:
            fcc         "Staged transition enabled with zero events"
            fcb         0x0d,0x0a,0
err15:
            fcc         "Staged injection can only be used with simultaneous"
            fcb         0x0d,0x0a,0
err16:
            fcc         "Dual table and secondary load cannot be enabled together"
            fcb         0x0d,0x0a,0

err17:
            fcc         "Spark mode requires 4 cylinders"
            fcb         0x0d,0x0a,0

err18:
            fcc         "4G63 requires 4 cylinders"
            fcb         0x0d,0x0a,0

err19:
            fcc         "6G72 requires 6 cylinders"
            fcb         0x0d,0x0a,0

err20:
            fcc         "Daihatsu 3 cyl requires 3 cylinders"
            fcb         0x0d,0x0a,0

err21:
            fcc         "Daihatsu 4 cyl requires 4 cylinders"
            fcb         0x0d,0x0a,0

err22:
            fcc         "Vitara 2.0 requires 4 cylinders"
            fcb         0x0d,0x0a,0

err23:
            fcc         "Suzuki Swift requires 4 cylinders"
            fcb         0x0d,0x0a,0

err24:
            fcc         "IAW Weber Marelli requires 4 cylinders"
            fcb         0x0d,0x0a,0

err25:
            fcc         "Failed to calculate trigger teeth, check settings"
            fcb         0x0d,0x0a,0

err26:
            fcc         "Staging and Dual Table cannot be used together"
            fcb         0x0d,0x0a,0

err27:
            fcc         "Conflict with boost control pins"
            fcb         0x0d,0x0a,0

err28:
            fcc         "Conflict with nitrous pins and IAC"
            fcb         0x0d,0x0a,0

err29:
            fcc         "Twin Trigger mode is designed for bike type ignition and can only be used with 4 cylinder wasted spark"
            fcb         0x0d,0x0a,0

err30:
            fcc         "Only two spark outputs allowed on Microsquirt"
            fcb         0x0d,0x0a,0

err31:
	    	fcc			"Dizzy mode with negative angle"
			fcb			0x0d,0x0a,0

err32:
            fcc         "COP set, but second trigger resets every crank rotation. Try wasted spark or change your 2nd trigger hardware to every cam rotation"
            fcb         0x0d,0x0a,0

err33:
            fcc         "Oddfire not allowed in this ignition mode"
            fcb         0x0d,0x0a,0

err34:
            fcc         "VTR1000 mode requires 2 cyl and oddfire and wasted spark"
            fcb         0x0d,0x0a,0

err35:
            fcc         "Spark mode requires 4cyl and single coil"
            fcb         0x0d,0x0a,0
err36:
            fcc         "Conflict with nitrous input"
            fcb         0x0d,0x0a,0

err37:
            fcc         "Too many spark outputs required with your settings"
            fcb         0x0d,0x0a,0

err38:
            fcc         "COP set, but crank speed trigger wheel. Try wasted spark, install a cam trigger or mount your wheel on the cam"
            fcb         0x0d,0x0a,0
err39:
            fcc         "Conflict with nitrous pins and FIDLE"
            fcb         0x0d,0x0a,0
err40:
            fcc         "Conflict with nitrous pins and D15"
            fcb         0x0d,0x0a,0
err41:
            fcc         "Oddfire required"
            fcb         0x0d,0x0a,0

.nolist                      ;skip the symbol table
