;*********************************************************************
; ISR_INJ_TIMER OUT
;*********************************************************************
; $Id: isr_inj.s,v 1.3 2007/06/11 22:04:43 jsmcortina Exp $

.sect .text
.globl ISR_Inj1_TimerOut
.globl ISR_Inj2_TimerOut

             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extra_structs.inc"
             include "ms2extrah.inc"
             list                 ;turn listing back on

;*********************************************************************
ISR_Inj1_TimerOut:
; Enter here when OC match to cease firing Inj1.
; At entry here the pin will automatically turn off injector;
.ifndef MICROSQUIRT
   bclr	   PWME,#0x04 ;  also turn off pwm1 (this not necessary since nanded)
.endif
   bclr	   outpc.squirt,#0x01  ; inj1 stopped squirting

   ldab    outpc.squirt
   andb    #3
   bne     ii1to_neither  ; branch if still one inj squirting

   ldx	   pPTMpin+0x6  ;    *pPTMpin[3] &= ~0x08
   bclr	   0,X, #0x08   ; turn off inj led

ii1to_neither:
;  Disable Inj1 OC interrupt - will re-enable on next tach pulse
   bclr	   TIE,#0x02
   movb	   #0x02, TFLG1 ; clear OC interrupt flag
   rti

;*********************************************************************
ISR_Inj2_TimerOut:
; Enter here when OC match to cease firing Inj1.
; At entry here the pin will automatically turn off injector;
.ifndef MICROSQUIRT
   bclr	   PWME,#0x10 ;  also turn off pwm1 (this not necessary since nanded)
.endif
   bclr	   outpc.squirt,#0x02  ; inj1 stopped squirting

   ldab    outpc.squirt
   andb    #3
   bne     ii2to_neither  ; branch if still one inj squirting

   ldx	   pPTMpin+0x6  ;    *pPTMpin[3] &= ~0x08
   bclr	   0,X, #0x08   ; turn off inj led

ii2to_neither:
;  Disable Inj1 OC interrupt - will re-enable on next tach pulse
   bclr	   TIE,#0x08
   movb    #0x08, TFLG1 ; clear OC interrupt flag
   rti

.nolist
