;*********************************************************************
;dwell timer, ign_out timer
; $Id: isr_ign.s,v 1.33.6.52 2009/05/26 22:12:17 jsmcortina Exp $
;.sect .text (see below)
.globl ISR_Dwl_TimerOut, ISR_TC5, ISR_Ign_TimerOut, ISR_Rot_TimerOut, ISR_Rot_SpkTimerOut
.globl fire_coil, dwell_coil, fire_coil_rotary, dwell_coil_rotary, do_complog_pri

             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extra_structs.inc"
             include "ms2extrah.inc"
             list                 ;turn listing back on

;*********************************************************************
.sect .text
ISR_Rot_TimerOut:
   movb    #0x80,TFLG1
   bclr    TIE,#0x80
   brclr   flash10.RotarySplitMode,#0x20,rot_timerout_end
   ldaa	   spk_cutx    ; Spark cut for rotary just turns off trailing completely
   bne	   rot_timerout_end
   bsr     dwell_coil_rotary

rot_timerout_end:
   clr     rotarydwlsel
   rti

;*********************************************************************
dwell_coil_rotary:
   brset   flash4.ICIgnOption,#0x10,rotdwllo
   brset   flash10.RotarySplitMode,0x01,FDDwl
   brset   flash10.RotarySplitMode,0x04,FDDwl
   brset   rotarydwlsel,0x4,FCDwl
   brset   rotarydwlsel,0x8,FCDwl
   bra     dcr_end

FDDwl:
   brset   rotarydwlsel,0x4,FCDwl  ;reuse FCDwl
   brset   rotarydwlsel,0x8,FDDwlD
   bra     dcr_end

FDDwlD:
   bclr    PTM, #0x20
   bra     dcr_end

FCDwl:
   bclr	   PTM, #0x10

dcr_end:
   clr     rotarydwlsel
   rts

rotdwllo:
   brset   flash10.RotarySplitMode,0x01,FDDwllo
   brset   flash10.RotarySplitMode,0x04,FDDwllo
   brset   rotarydwlsel,0x4,FCDwllo
   brset   rotarydwlsel,0x8,FCDwllo
   bra     dcr_end

FDDwllo:
   brset   rotarydwlsel,0x4,FCDwllo  ;reuse FCDwl
   brset   rotarydwlsel,0x8,FDDwlDlo
   bra     dcr_end

FDDwlDlo:
   bset    PTM, #0x20
   bra     dcr_end

FCDwllo:
   bset	   PTM, #0x10
   bra     dcr_end

;*********************************************************************


ISR_Rot_SpkTimerOut:
   movb    #0x10,TFLG1
   bclr    TIE,#0x10
   brclr   flash10.RotarySplitMode,#0x20,rot_spk_end
   ldaa	   spk_cutx
   bne	   spk_cut_rot 
   bsr     fire_coil_rotary
   bra     rot_spk_end
spk_cut_rot:
   bset    PTM, #0x10
   bset    PTM, #0x20
   bsr     fire_coil_rotary

rot_spk_end:
   clr     rotaryspksel
   rti

;*********************************************************************
fire_coil_rotary:
   brset   flash4.ICIgnOption,#0x10,rotspkhi
   brset   flash10.RotarySplitMode,0x01,FDFire
   brset   flash10.RotarySplitMode,0x04,FDFire
   brset   rotaryspksel,0x4,FCFireC
   brset   rotaryspksel,0x8,FCFireD
   bra     fcr_end

FDFire:
   brset   rotaryspksel,0x4,FDFireC
   brset   rotaryspksel,0x8,FDFireD
   bra     fcr_end

FDFireC:
   bset    PTM, #0x10
   bra     fcr_end

FDFireD:
   bset    PTM, #0x20
   bra     fcr_end

FCFireC:
   bclr    PTM, #0x20
   bset    PTM, #0x10
   bra     fcr_end

FCFireD:
   bset    PTM, #0x20
   bset    PTM, #0x10
fcr_end:
   clr     rotaryspksel
   rts

rotspkhi:
   brset   flash10.RotarySplitMode,0x01,FDFirehi
   brset   flash10.RotarySplitMode,0x04,FDFirehi
   brset   rotaryspksel,0x4,FCFireChi
   brset   rotaryspksel,0x8,FCFireDhi
   bra     fcr_end

FDFirehi:
   brset   rotaryspksel,0x4,FDFireChi
   brset   rotaryspksel,0x8,FDFireDhi
   bra     fcr_end

FDFireChi:
   bclr    PTM, #0x10
   bra     fcr_end

FDFireDhi:
   bclr    PTM, #0x20
   bra     fcr_end

FCFireChi:
   bclr    PTM, #0x20
   bclr    PTM, #0x10
   bra     fcr_end

FCFireDhi:
   bset    PTM, #0x20
   bclr    PTM, #0x10
   bra     fcr_end

;*********************************************************************
.sect .text

ISR_Dwl_TimerOut:
   movb    #0x40,TFLG1 ; clear interrupt flag
   bclr    TIE,#0x40

;debug
   brclr   flash8.feature413, #1, idto1
   ldx     outpc.gpioadc0
   inx
   stx     outpc.gpioadc0
idto1:
;end debug
;   bclr    outpc.status3, #2 ; ?
   ldab    flash4.spk_mode
   andb    #0x1f
   cmpb    #2
   blo     idt_dn  ; shouldn't have got here in EDIS mode

; set dwell timers (even if we actually skip the dwell)
   brset   dwellsel,2,dwlt2
   brset   dwellsel,4,dwlt4
   brset   dwellsel,8,dwlt8
   brset   dwellsel,0x10,dwlt10
   brset   dwellsel,0x20,dwlt20
   ldx     #0
   bra     setdwlt
dwlt2:
   ldx     #1
   bra     setdwlt
dwlt4:
   ldx     #2
   bra     setdwlt
dwlt8:
   ldx     #3
   bra     setdwlt
dwlt10:
   ldx     #4
   bra     setdwlt
dwlt20:
   ldx     #5

setdwlt:
   ldaa    #1
   staa    dwl,x

   ldab    spk_cutx
   beq     itoDWELL_COIL    ; no spark cut
;spk cut timer
   ldaa    spk_cuti
   inca
   cmpa    spk_cuty
   bls     spk_cnt_ok
   ldaa    #1
spk_cnt_ok:
   staa    spk_cuti
   cba
   bls     idt_dn     ; don't set dwell

itoDWELL_COIL:
   bsr     dwell_coil

idt_dn:
   rti

;*********************************************************************
dwell_coil:
;debug   
   brclr   flash8.feature413, #1, dtle2
; outpc.status4 should go 1,2,1,2. 1= spark, 2= dwell
   ldab    outpc.status4
   cmpa    #1 ; previous should have been a spark
   beq     dtle
   pshx
   ldx     outpc.gpioadc5
   inx
   stx     outpc.gpioadc5
   pulx
dtle:
   movb    #2, outpc.status4
dtle2:
;end debug
   tst     dwellsel
   beq     idclrcoil
   brset   flash4.ICIgnOption,#0x10,nidhilo0
   jmp     idhilo0
nidhilo0:
   brset   flash10.RotarySplitMode,#0x20,chkrotdwl1
   brset   dwellsel,1,idh1c1
   brset   dwellsel,2,idh1c2
   brset   dwellsel,4,idh1c3
   brset   dwellsel,8,idh1c4
   brset   dwellsel,0x10,idh1c5
   brset   dwellsel,0x20,idh1c6
   bra     idclrcoil

chkrotdwl1:
   brclr   flash10.RotarySplitMode,0x04,idc1d14
   brset   dwellsel,1,idh1c1
   brset   dwellsel,2,idh1c4rx8
   bra     idclrcoil
idh1c1:
   bclr    dwellsel,#1
idh1c1b:
.ifndef MICROSQUIRT
   brset   flash4.spk_config,1,idc1d14
   ldab    num_spk
   cmpb    #3
   bhi     idc1d14
idc1js6:
.endif
   bset    PTT, #0x20
   bra     dwell_coil
idc1d14:
   bset    PTM, #0x08
   bclr    dwellsel,#1
   brset   flash10.RotarySplitMode,#0x20,idc1d14b
   bra     dwell_coil
idc1d14b:
   jmp     idclrcoil
idh1c2:
   bclr    dwellsel,#2
   brset   flagbyte4,#flagbyte4_oddspk,idh1c1b
.ifdef MICROSQUIRT
   bset    PTT, #0x10
.else
   bset    PTM, #0x10
.endif
   bra     dwell_coil
idh1c3:
   bset    PTM, #0x20
   bclr    dwellsel,#4
   bra     dwell_coil
idh1c4:
   bset    PORTA, #0x01
   bclr    dwellsel,#8
   bra     dwell_coil
idh1c4rx8:
   bset    PORTA, #0x01
   bclr    dwellsel,#2
   bra     dwell_coil
idh1c5:
   bset    PTAD, #0x40
   bclr    dwellsel,#0x10
   bra     dwell_coil
idh1c6:
   bset    PTAD, #0x80
   bclr    dwellsel,#0x20
   bra     dwell_coil

idhilo0:
   brset   flash10.RotarySplitMode,#0x20,chkrotdwl2
   brset   dwellsel,1,idh0c1
   brset   dwellsel,2,idh0c2
   brset   dwellsel,4,idh0c3
   brset   dwellsel,8,idh0c4
   brset   dwellsel,0x10,idh0c5
   brset   dwellsel,0x20,idh0c6
   bra     idclrcoil

chkrotdwl2:
   brclr   flash10.RotarySplitMode,0x04,idh0c1d14
   brset   dwellsel,1,idh0c1
   brset   dwellsel,2,idh0c4rx8
   bra     idclrcoil

idh0c1:
.ifndef MICROSQUIRT
   brset   flash4.spk_config,1,idh0c1d14
   ldab    num_spk
   cmpb    #3
   bhi     idh0c1d14
dh0c1js6:
.endif
   bclr    PTT, #0x20
   bclr    dwellsel,#1
   bra     dwell_coil
idh0c1d14:
   bclr    PTM, #0x08
   bclr    dwellsel,#1
   brset   flash10.RotarySplitMode,#0x20,idclrcoil
   bra     dwell_coil
idh0c2:
   brset   flagbyte4,#flagbyte4_oddspk,idh0c1
.ifdef MICROSQUIRT
   bclr    PTT, #0x10
.else
   bclr    PTM, #0x10
.endif
   bclr    dwellsel,#2
   bra     dwell_coil
idh0c3:
   bclr    PTM, #0x20
   bclr    dwellsel,#4
   bra     dwell_coil
idh0c4:
   bclr    PORTA, #0x01
   bclr    dwellsel,#8
   bra     dwell_coil
idh0c4rx8:
   bclr    PORTA, #0x01
   bclr    dwellsel,#2
   bra     dwell_coil
idh0c5:
   bclr    PTAD, #0x40
   bclr    dwellsel,#0x10
   bra     dwell_coil
idh0c6:
   bclr    PTAD, #0x80
   bclr    dwellsel,#0x20
   bra     dwell_coil

idclrcoil:
   clr     dwellsel
   rts
;*********************************************************************
ISR_Ign_TimerOut:
; this is   IOC2 on MS2    IOC5 on Microsquirt
   movb    #TFLG_ign, TFLG1 ; clear interrupt flag
   bclr    TIE,#TFLG_ign
;debug
   brclr   flash8.feature413, #1, ito1
   ldx     outpc.gpioadc1
   inx
   stx     outpc.gpioadc1
   ldd     outpc.gpioadc1
   subd    outpc.gpioadc0
   std     outpc.gpioadc3 ; spk w/o dwell counter

   ldd     outpc.gpioadc2
   subd    outpc.gpioadc0
   std     outpc.gpioadc4 ; fuel w/o spk counter
ito1:
;end debug
;   bclr    outpc.status3, #1
.ifdef MICROSQUIRT
   ldab	   flash4.spk_mode
   andb    #0x1e
   beq     edisspk
.endif

;measure latency
;   ldd     TCNT
;   subd    TC_ign
;   cpd     outpc.istatus5;  not now
;   bls     no_lat
;   std     outpc.istatus5 ; worst
;no_lat:

;guaranteed dwell validation
   ldaa    mindwl  ; check if this has been setup yet
   beq     itoFIRE_COIL

   brset   coilsel,#2,ckdwlt2
   brset   coilsel,#4,ckdwlt4
   brset   coilsel,#8,ckdwlt8
   brset   coilsel,#0x10,ckdwlt10
   brset   coilsel,#0x20,ckdwlt20
   ldx     #0
   bra     chkdwlt
ckdwlt2:
   ldx     #1
   bra     chkdwlt
ckdwlt4:
   ldx     #2
   bra     chkdwlt
ckdwlt8:
   ldx     #3
   bra     chkdwlt
ckdwlt10:
   ldx     #4
   bra     chkdwlt
ckdwlt20:
   ldx     #5

chkdwlt:
   ldab    dwl,x
   cmpb    maxdwl
   bhi     dwltoo_long
   cmpb    mindwl
   bhi     itoFIRE_COIL
   ;get here if dwell was below threshold
   ;need to reschedule spark a bit later on
   subb    nomdwl
   negb             ; nominal - actual = additional delay required
   ldaa    #192
   mul     ; convert 0.128ms units to timer ticks
   addd    TC_ign
   std     TC_ign ; store new later OC time
   movb    #TFLG_ign, TFLG1; 	// clear ign OC interrupt flag
   bset    #TFLG_ign, TIE; 	// set TIE
   jmp     really_done_ignout  ; go to rti and wait for new later event

dwltoo_long:
   ;don't do anything for now

itoFIRE_COIL:
   bsr fire_coil

really_done_ignout:
   rti
;*********************************************************************
fire_coil:
;debug
   brclr   flash8.feature413, #1, fcle2
; outpc.status4 should go 1,2,1,2. 1= spark, 2= dwell
   ldab    outpc.status4
   cmpb    #2 ; previous should have been a dwell
   beq     fcle
   pshx
   ldx     outpc.gpioadc6
   inx
   stx     outpc.gpioadc6
   pulx
fcle:
   movb    #1, outpc.status4
fcle2:
;end debug
   ldaa    coilsel ; save it
   brset   flash4.ICIgnOption,#0x10,nonitoilo0
   jmp     itoilo0
nonitoilo0:
   tst     coilsel
   beq     itocoil
   brset   flash10.RotarySplitMode,#0x20,chkrotspk1
   brset   coilsel,1,ito1c1
   brset   coilsel,2,ito1c2
   brset   coilsel,4,ito1c3
   brset   coilsel,8,ito1c4
   brset   coilsel,0x10,jito1c5
   brset   coilsel,0x20,jito1c6
   bra     itocoil

chkrotspk1:
   brclr   flash10.RotarySplitMode,0x04,ito1d14
   brset   coilsel,1,ito1c1
   brset   coilsel,2,ito1c4rx8
   bra     itocoil

ito1c1:
   movw	   dwell_time_slow,CoilACountdown
   bclr    coilsel,#1
ito1c1a:
.ifndef MICROSQUIRT
   brset   flash4.spk_config,1,ito1d14
   ldab    num_spk
   cmpb    #3
   bhi     ito1d14
ito1js6:
.endif
   bclr    PTT, #0x20
   bclr    coilsel,#1
   bra     nonitoilo0
ito1d14:
   bclr    PTM, #0x08
   brclr   flash10.RotarySplitMode,#0x20,nonitoilo0
   bra     itocoil
ito1c2:
   movw	   dwell_time_slowb,CoilBCountdown
   bclr    coilsel,#2
   brset   flagbyte4,#flagbyte4_oddspk,ito1c1a
.ifdef MICROSQUIRT
   bclr    PTT, #0x10
.else
   bclr    PTM, #0x10
.endif
   bra     nonitoilo0
ito1c3:
   movw	   dwell_time_slow,CoilCCountdown
   bclr    PTM, #0x20
   bclr    coilsel,#4
   bra     nonitoilo0

jito1c5: bra ito1c5
jito1c6: bra ito1c6

ito1c4:
   movw	   dwell_time_slowb,CoilDCountdown
   bclr    PORTA, #0x01
   bclr    coilsel,#8
   bra     nonitoilo0
ito1c4rx8:
   movw	   dwell_time_slowb,CoilDCountdown
   bclr    PORTA, #0x01
   bclr    coilsel,#2
   bra     nonitoilo0
ito1c5:
   movw	   dwell_time_slow,CoilECountdown
   bclr    PTAD, #0x40
   bclr    coilsel,#0x10
   bra     nonitoilo0
ito1c6:
   movw	   dwell_time_slowb,CoilFCountdown
   bclr    PTAD, #0x80
   bclr    coilsel,#0x20
   bra     nonitoilo0

itoilo0:
   tst     coilsel
   beq     itocoil
   brset   flash10.RotarySplitMode,#0x20,chkrotspk2
   brset   coilsel,1,ito0c1
   brset   coilsel,2,ito0c2
   brset   coilsel,4,ito0c3
   brset   coilsel,8,ito0c4
   brset   coilsel,0x10,jito0c5
   brset   coilsel,0x20,jito0c6
   bra     itocoil

chkrotspk2:
   brclr   flash10.RotarySplitMode,0x04,ito0c1d14
   brset   coilsel,1,ito0c1
   brset   coilsel,2,ito0c4rx8
   bra     itocoil

ito0c1:
   movw	   dwell_time_slow,CoilACountdown
ito0c1a:
.ifndef MICROSQUIRT
   brset   flash4.spk_config,1,ito0c1d14
   ldab    num_spk
   cmpb    #3
   bhi     ito0c1d14
ito0c1js6:
.endif
   bset    PTT, #0x20
   bclr    coilsel,#1
   bra     itoilo0
ito0c1d14:
   bset    PTM, #0x08
   bclr    coilsel,#1
   brset   flash10.RotarySplitMode,#0x20,itocoil
   bra     itoilo0
ito0c2:
   movw	   dwell_time_slowb,CoilBCountdown
   brset   flagbyte4,#flagbyte4_oddspk,ito0c1a
.ifdef MICROSQUIRT
   bset    PTT, #0x10
.else
   bset    PTM, #0x10
.endif
   bclr    coilsel,#2
   bra     itoilo0
ito0c3:
   movw	   dwell_time_slow,CoilCCountdown
   bset    PTM, #0x20
   bclr    coilsel,#4
   bra     itoilo0
ito0c4:
   movw	   dwell_time_slowb,CoilDCountdown
   bset    PORTA, #0x01
   bclr    coilsel,#8
   bra     itoilo0

jito0c5:   jmp ito0c5
jito0c6:   jmp ito0c6

ito0c4rx8:
   movw	   dwell_time_slowb,CoilDCountdown
   bset    PORTA, #0x01
   bclr    coilsel,#2
   bra     itoilo0
ito0c5:
   movw	   dwell_time_slow,CoilECountdown
   bset    PTAD, #0x40
   bclr    coilsel,#0x10
   bra     itoilo0
ito0c6:
   movw	   dwell_time_slowb,CoilFCountdown
   bset    PTAD, #0x80
   bclr    coilsel,#0x20
   bra     itoilo0

itocoil:
   ldab    flash4.dwellmode
   cmpb    #2
   bne     itccl
   staa    dwellsel ; previously saved before clearing it
   ldaa    #100
   ldab    flash4.dwelltime
   mul
   addd    TC_ign
   std     TC6           ; set up dwell timer for prescribed time later
   bset    TIE,#0x40
   movb    #0x40,TFLG1
itccl:
   clr     coilsel
   rts


;*********************************************************************
ISR_TC5:
; this is   IOC5 on MS2    IOC2 on Microsquirt
   movb    #TFLG_trig2, TFLG1 ; clear interrupt flag

.ifndef MICROSQUIRT
   ldab	   flash4.spk_mode
   andb    #0x1e
   beq     edisspk
.endif

; second trigger input
; may want to add tooth width recording like the start of ign_in
; for now simply set the flag to say second trigger happened
; The input capture setup determines when we arrive here

; Need to do these after the noise filtering
;   bset    flagbyte1,#flagbyte1_trig2active
   bset    TIE, #TFLG_trig2  ; ensure IC still enabled
;   inc     trig2cnt

   brclr   flagbyte2,#flagbyte2_twintrig,tc5notwin
   bset    flagbyte2,#flagbyte2_twintrignow
   jmp     ISR_Ign_TimerIn   ; CAUTION! Jumping to timerin

tc5notwin:
   ; this is the normal code path

   ; As with the crank input tach path is
   ;  * 1. if cam tach masking is enabled, we might not even have reached this ISR
   ;  * (composite tooth logger happens here)
   ;  * 2. 2nd trig noise filter
   ;  * 3. if noise filter off, polarity check
   ;  * 4. cam period filtering

   ; noise filter

   brset flagbyte5,FLAGBYTE5_CAM_NOISE,noise_filter
   brset flagbyte0, #flagbyte0_complog,noise_filter
   jmp   no_noise_filter

; Need 32-bit TC5 (MS2) or TC2 (Mircosquirt), so generate that
noise_filter: ; (this includes the composite logger)

   movw    swtimer,TC5_32bits
   movw    TC_trig2,TC5_32bits+2

   brclr   flagbyte1,#flagbyte1_ovfclose,ovf_check_nointyet
   ldd     TC5_32bits+2
   cmpd    #0x1000
   bhs     ovf_check_nointyet
   bra     extra_inc_TC532bits

ovf_check_nointyet:
   ldd     TC5_32bits+2
   cmpd     TC5_last
   bhs     done_ovf_tc5
   ldd     swtimer
   cmpd     swtimer_TC5_last
   bne     done_ovf_tc5

extra_inc_TC532bits:
   inc     TC5_32bits

done_ovf_tc5:
   movw    TC5_32bits+2,TC5_last
   movw    swtimer,swtimer_TC5_last

;composite tooth logger
   brset   flagbyte0, #flagbyte0_complog, do_ic2complog
   jmp     cl2done ; skip if not doing composite log

do_ic2complog:
    ldx     TC5_32bits
    ldd     TC5_32bits+2
    subd    IC_last+2
    xgdx
    sbcb    IC_last+1
    sbca    IC_last

;D contains high word of time since last edge (pri or sec)
;X contains low word
    movw    TC5_32bits, IC_last ; save this timer time
    movw    TC5_32bits+2, IC_last+2

    xgdy    ; don't trash D
    ldd	    #ram_data
    addd	log_offset
    xgdy    ; swap back
    ; ignore top byte in A
    andb	#0xf
    brclr	synch, #0x01, cl2not_sync   ; HARDCODING
    orab	#0x10

cl2not_sync:
    orab	#0x20 ; always tach2

    brclr   PTT,#1,cl2low1
    orab	#0x40   ; store pri trig pin level in 0x40

cl2low1:
    brclr   PTT,#TFLG_trig2,cl2low2
    orab	#0x80   ; store 2nd trig pin level in 0x80

cl2low2:
    stab	0,Y ; top byte of time + 4 special bits
    stx	    1,Y ; low word

    ldab    page
    cmpb    #0xf2
    beq     cl2end1
;comp log loop mode

    ldd     log_offset
    std     ram_data + 0x3fd ; store current log_offset as pointer to next data point
    brclr   synch, #1, cl2fin ; no sync.. we are done

cll2inc:
    ldd	    log_offset
    addd	#3
    std	    log_offset
    cpd	    #0x3fc   ; three less
    bls	    cl2done
;start again
    clr     log_offset
    clr     log_offset+1
    bra     cl2done

cl2end1:
    ldd	    log_offset
    addd	#3
    std	    log_offset
    cpd	    #0x3ff
    bls	    cl2done

cl2fin:
    ; we've reached the end of the buffer, stop
    bclr	flagbyte0, #flagbyte0_complog
    movb	#1, ram_data + 0x3ff ; HARDCODED version
    bset    outpc.status3, #status3_donelog

cl2done:
   ldd   outpc.rpm
   cmpd  #10 ; check over 10rpm
   blo   skip_nf
   brset flagbyte5,#FLAGBYTE5_CAM_NOISE,real_noise_filter
skip_nf:
   brclr flagbyte5,#FLAGBYTE5_CAM_POLARITY,cpol_done ; polarity check off
; polarity check
; mode4 has its own pair of bits, everything else follows main polarity
   ldaa  flash4.spk_mode
   anda  #0x1f
   cmpa  #4
   beq   nf4
;other modes
   brset flash4.ICIgnOption, #0x01, nf_rise ; rising edge
   bra   nf_fall

nf4:
;mode4 where it can be rising OR falling
;init code disables this check for rising AND falling
   brset flash4.spk_config, #0x10, nf_rise
   brset flash4.spk_config, #0x20, nf_fall
;shouldn't get here...bail
   bra  cpol_bail

nf_fall:
   brclr PORTT, #TFLG_trig2, cpol_done ; input pin is low
   bra   cpol_bail
nf_rise:
   brset PORTT, #TFLG_trig2, cpol_done ; input pin is high
cpol_bail:
;input pin was wrong polarity - bail out
   rti

cpol_done:
   jmp   no_noise_filter


; ok, now figure out what edge we're on, and what edge we're looking for
real_noise_filter:
   brclr   PTT,#TFLG_trig2,caught_fall

   ; rise, are we triggering on this or not?

   brset   flash4.spk_config,#0x20,not_triggering
   bra     triggering 

caught_fall:
   brset   flash4.spk_config,#0x10,not_triggering
   bra     triggering

not_triggering:
   ; Not triggering, store the time and exit the interrupt
   movw    TC5_32bits,TC5_trig_firstedge
   movw    TC5_32bits+2,TC5_trig_firstedge+2
   rti

triggering:
   ; triggering, see if the time is large enough to not be noise
   ldd     TC5_32bits+2
   subd    TC5_trig_firstedge+2
   xgdx
   ldd     TC5_32bits
   sbcb    TC5_trig_firstedge+1
   sbca    TC5_trig_firstedge
   bne     no_noise_filter
   xgdx
   cmpd    flash4.TC5_required_width
   bhi     no_noise_filter    ;filter passes, actual length is more than required

unset_bit_rti:
   bclr    flagbyte1,#flagbyte1_trig2active
   brclr   flash8.feature413, #1, ubr2
   inc     outpc.gpioadc7 ; debug counter for noise filter
ubr2:
   rti

no_noise_filter:
   movw    lmms, ltch_lmms2 ; save lmms value for false trig detection
   movw    lmms+2, ltch_lmms2+2 ; not really needed as lmms will not change while we are in here

   ldd     false_period_cam_tix
   beq     no_false_cam   ; skip if zero

   ldd     TC_trig2
   subd    TC_trig2_last
   cmpd    false_period_cam_tix
   bhi     no_false_cam
   bclr    flagbyte1,#flagbyte1_trig2active
   brclr   flash8.feature413, #1, nnf2
   inc     outpc.gpioadc7+1 ; debug counter for masking
nnf2:
   rti     ; assume this is a false trigger - bail out  

no_false_cam:
; If we got here this is considered a real pulse
   bset    flagbyte1,#flagbyte1_trig2active
   inc     trig2cnt
   movw    TC_trig2_last, TC_trig2_last2
   movw    TC_trig2, TC_trig2_last

;do we do VANOS logging
   brclr    flash4.feature4_0,#0x80, no_vanos
   movb     tooth_no, outpc.status4 ; save the last tooth we saw before this cam input
   ldd      TC_trig2
   subd     TC0_last
   std      outpc.istatus5 ; number of ticks since that tooth. User can convert these to an angle

no_vanos:
   ldab	   flash4.spk_mode
   andb	   #31
   cmpb    #15
   bne     gol1
   ; Chrysler 2.2/2.5 second trig section.
   ; even though primary trigger is "both edge", the secondary trigger isn't (at this time)
   ; we get here on a falling edge, so poll primary trigger to see if "high"
   brclr   flash4.ICIgnOption, #1, chry22inv
   brclr   PTT, #1, chry22set
   bra     chry22sync
chry22inv:
   brset   PTT, #1, chry22set
   bra     chry22sync
chry22set:
   ;falling edge of second trig and high level on primary. We've found the sync
   movb    #5, tooth_no
   bset	   synch, #0x01
   bset    outpc.status1, #0x8 
   bra     gol1
   ; sync check, we get here if it is a falling edge and primary isn't high
chry22sync:
   ldab    tooth_no
   cmpb    #5
   bne     gol1 ; ok, not expected anyway
   call    ign_reset ; lost sync

gol1:
   jmp     L1 ; goes to rti

edisspk:        ; EDIS spark output mode - always IOC5
    ; Enter here when ign OC reg match
   ldab    TCTL1
   andb    #4
   lsrb
   lsrb
   stab    IgnOCpinstate ; this only needs 1 bit
   cmpb    CHG
   bne     LM11

; set up dwell monitor timer
   movb    #1,dwl  ; always channel A at the moment

;	IgnTimerComp = TC5 + coil_dur_set;  // 2/3 us
   ldd     TC5
   addd    coil_dur_set+0x2
   ldx     coil_dur_set
   bcc     LM9b
   inx
LM9b:
   std     IgnTimerComp+0x2
   stx     IgnTimerComp

   movb    SPK, ign_setpin
   bra     LM16


LM11:
;	// Coil has just started discharging (sparking)

; clear dwell monitor timer
   clr     dwl  ; always channel A at the moment

   tst     ign_state
   bne     schd_dwl

LM12:
   bclr    TIE,#0x20 ;  disable ign OC interrupt - chge after next IC pulse
   jmp     L40 ; clear ign OC interrupt flag

schd_dwl:
	; want to charge after done with spark
;	    IgnTimerComp = TC5 + charge_time;  // 2/3 us
   ldx     charge_time
   ldd     TC5
   addd    charge_time+0x2
   bcc     LM14b
   inx
LM14b:
   std     IgnTimerComp+0x2
   stx     IgnTimerComp

   movb    CHG, ign_setpin ; use to set OC o/p in OL5

LM16:
;    // check if v. short OC reg occurs after TCNT
;There must be a cleaner way of doing this...
   ldx    #0
   ldd    TCNT
   subd   TC5
   bcc    LM18
   inx           ; rolled over between start and now so increment top word
LM18:
   addd   #12
   bcc    LM18b
   inx
LM18b:
   addd   TC5
   bcc    LM18c
   inx
LM18c:
; x:d now contains target + 12 ticks buffer
   cpx    IgnTimerComp
   bcs    LM20
   bhi    LM19b
   cpd    IgnTimerComp+0x2
   bls    LM20
;    if(IgnTimerComp < tcnt)IgnTimerComp = tcnt;
LM19b:
   std    IgnTimerComp+0x2
   stx    IgnTimerComp

LM20:
; We only get here in EDIS which is scheduled off trigger so
; will never require > 43ms delay

LM24:
   movw    IgnTimerComp+0x2, TC5   ; load ign OC register

;	// enable Ign OC pin
   tst     ign_setpin     ; either 0 or 1
   beq     LM24a

   bset    TCTL1,#0x04    ; fixed spk output for EDIS
   bra     LM24b
LM24a:
   bclr    TCTL1,#0x04
LM24b:

L40:
   movb    #TFLG_trig2, TFLG1; 	// clear ign OC interrupt flag
   bra     ign_rti

L1:
   ldd     false_mask_cam
   beq     ign_no_false
; cam sensor false trigger protection
   addd	   ltch_lmms2+0x2
   ldx     ltch_lmms2
   bcc	   L1carry
   inx
L1carry:
   stx     t_enable_IC2
   std     t_enable_IC2+0x2

   bclr    TIE, TFLG_trig2
   movb	   #TFLG_trig2, TFLG1
   bra	   ign_rti

ign_no_false:
    movw	#0xffff, t_enable_IC2+0x2
    movw	#0xffff, t_enable_IC2

ign_rti:
   rti


; composite logger moved to here from ign_in.c due to gcc mess up

do_complog_pri:
; function call does this, we arrive here with this data
;    ldx     TC0_32bits 
;    ldd     TC0_32bits+2
    subd    IC_last+2
    xgdx
    sbcb    IC_last+1
    sbca    IC_last

;D contains high word of time since last edge (pri or sec)
;X contains low word
;    movw    TC0_32bits, IC_last ; save this timer time ; do this in the C code
;    movw    TC0_32bits+2, IC_last+2

    xgdy    ; don't trash D
    ldd	    #ram_data
    addd	log_offset
    xgdy    ; swap back
    ; ignore top byte in A
    andb	#0xf
    brclr	synch, #0x01, cl1not_sync   ; HARDCODING
    orab	#0x10

cl1not_sync:
;    orab	#0x20 if tach2 - may want to handle twin trigger?

    brclr   PTT,#1,cl1low1
    orab	#0x40   ; store pri trig pin level in 0x40

cl1low1:
    brclr   PTT,#TFLG_trig2,cl1low2
    orab	#0x80   ; store 2nd trig pin level in 0x80

cl1low2:
    stab	0,Y ; top byte of time + 4 special bits
    stx	    1,Y ; low word

    ldab    page
    cmpb    #0xf2
    beq     cl1end1
;comp log loop mode
    ldd     log_offset
    std     ram_data + 0x3fd ; store current log_offset as pointer to next data point
    brclr   synch, #1, cl1fin  ; no sync.. we are done

cll1inc:
    ldd	    log_offset
    addd	#3
    std	    log_offset
    cpd	    #0x3fc   ; three less
    bls	    cl1done
;start again
    clr     log_offset
    clr     log_offset+1
    bra     cl1done

cl1end1:
    ldd	    log_offset
    addd	#3
    std	    log_offset
    cpd	    #0x3ff
    bls	    cl1done

cl1fin:
    ; we've reached the end of the buffer, stop
    bclr	flagbyte0, #flagbyte0_complog
    movb	#1, ram_data + 0x3ff ; HARDCODED version
    bset    outpc.status3, #status3_donelog

cl1done:
    rts
