/*************************************************************************
 **************************************************************************
 **   M E G A S Q U I R T  II - 2 0 0 4 - V1.000
 **
 **   (C) 2003 - B. A. Bowling And A. C. Grippo
 **
 **   This header must appear on all derivatives of this code.
 **
 ***************************************************************************
 **************************************************************************/

/*************************************************************************
 **************************************************************************
 **   GCC Port
 **
 **   (C) 2004,2005 - Philip L Johnson
 **
 **   This header must appear on all derivatives of this code.
 **
 ***************************************************************************
 **************************************************************************/

/*************************************************************************
 **************************************************************************
 **   MS2/Extra
 **
 **   (C) 2006 - Ken Culver, James Murray (in either order)
 **
 **   This header must appear on all derivatives of this code.
 **
 ***************************************************************************
 **************************************************************************/
/* $Id: ms2_extra_main.c,v 1.3 2007/05/05 22:18:50 jsmcortina Exp $ */

/* ----------------------
  Massively stripped down version to permit "usermode" reflash code to access
  extended pages without modifying bootloader
  -----------------------*/
#include "ms2_extra.h"

const tIsrFunc _vect[] VECT_ATTR = {      /* Interrupt table */
    UnimplementedISR,                 /* vector 63 */
    UnimplementedISR,                 /* vector 62 */
    UnimplementedISR,                 /* vector 61 */
    UnimplementedISR,                 /* vector 60 */
    UnimplementedISR,                 /* vector 59 */
    UnimplementedISR,                 /* vector 58 */
    UnimplementedISR,                 /* vector 57 */
    UnimplementedISR,                 /* vector 56 */
    UnimplementedISR,                 /* vector 55 */
    UnimplementedISR,                 /* vector 54 */
    UnimplementedISR,                 /* vector 53 */
    UnimplementedISR,                 /* vector 52 */
    UnimplementedISR,                 /* vector 51 */
    UnimplementedISR,                 /* vector 50 */
    UnimplementedISR,                 /* vector 49 */
    UnimplementedISR,                 /* vector 48 */
    UnimplementedISR,                 /* vector 47 */
    UnimplementedISR,                 /* vector 46 */
    UnimplementedISR,                 /* vector 45 */
    UnimplementedISR,                 /* vector 44 */
    UnimplementedISR,                 /* vector 43 */
    UnimplementedISR,                 /* vector 42 */
    UnimplementedISR,                 /* vector 41 */
    UnimplementedISR,                 /* vector 40 */
    UnimplementedISR,                 /* vector 39 */
    UnimplementedISR,                 /* vector 38 */
    UnimplementedISR,                 /* vector 37 */
    UnimplementedISR,                 /* vector 36 */
    UnimplementedISR,                 /* vector 35 */
    UnimplementedISR,                 /* vector 34 */
    UnimplementedISR,                 /* vector 33 */
    UnimplementedISR,                 /* vector 32 */
    UnimplementedISR,                 /* vector 31 */
    UnimplementedISR,                 /* vector 30 */
    UnimplementedISR,                 /* vector 29 */
    UnimplementedISR,                 /* vector 28 */
    UnimplementedISR,                 /* vector 27 */
    UnimplementedISR,                 /* vector 26 */
    UnimplementedISR,                 /* vector 25 */
    UnimplementedISR,                 /* vector 24 */
    UnimplementedISR,                 /* vector 23 */
    UnimplementedISR,                 /* vector 22 */
    UnimplementedISR,                 /* vector 21 */
    ISR_SCI_Comm,                     /* vector 20 */
    UnimplementedISR,                 /* vector 19 */
    UnimplementedISR,                 /* vector 18 */
    UnimplementedISR,                 /* vector 17 */
    UnimplementedISR,                 /* vector 16 timeroverflow */
    UnimplementedISR,                 /* vector 15 timer 7*/
    UnimplementedISR,                 /* vector 14 timer 6*/
    UnimplementedISR,                 /* vector 13 timer 5*/
    UnimplementedISR,                 /* vector 12 timer 4*/
    UnimplementedISR,                 /* vector 11 timer 3*/
    UnimplementedISR,                 /* vector 10 timer 2*/
    UnimplementedISR,                 /* vector 09 timer 1*/
    UnimplementedISR,                 /* vector 08 timer 0*/
    UnimplementedISR,                 /* vector 07 was RTI*/
    UnimplementedISR,                 /* vector 06 */
    UnimplementedISR,                 /* vector 05 */
    UnimplementedISR,                 /* vector 04 */
    UnimplementedISR,                 /* vector 03 */
    UnimplementedISR,                 /* vector 02 */
    UnimplementedISR,                 /* vector 01 */
    _start                            /* Reset vector */
};

unsigned char page;
char ram_data[1024];

// ignition related (wheel decoder)
ign_event dwell_events_a[NUM_TRIGS];
ign_event spark_events_a[NUM_TRIGS];
ign_event dwell_events_b[NUM_TRIGS];
ign_event spark_events_b[NUM_TRIGS];
ign_event *dwell_events;
ign_event *spark_events;
ign_event next_spark;
ign_event next_dwell;
ign_event next_spk_trl;
ign_event next_dwl_trl;
unsigned char next_fuel;
unsigned char trigger_teeth[NUM_TRIGS];
int trig_angs[NUM_TRIGS];
int trig_ang;
unsigned char coilsel;
unsigned char dwellsel;
unsigned char rotaryspksel;
unsigned char rotarydwlsel;
unsigned char num_spk;

//misc
unsigned char conf_err;
unsigned int adc67[2], gpioadc[8];
unsigned int mltimestamp;
unsigned char pwm1div, pwm2div, pwm3div, pwm4div;
unsigned char pwm1cnt, pwm2cnt, pwm3cnt, pwm4cnt;

// rs232 structs
variables outpc, txbuf;

// sensor variables
int last_tps,last_map,tpsdot_ltch,mapdot_ltch,old_map;
// fuel variables
unsigned int pwcalc1,pwcalc2,pw_open,PrimeP,AWEV,AWC;
unsigned char pwm1_on,pwm2_on,cut_fuel;
// ignition variables
unsigned char SPK,CHG, pulse_no,ign_state,ign_setpin,
              IgnOCpinstate,first_edis,PulseTol;
long charge_time,coil_dur_set;
unsigned int coil_dur; // was signed
unsigned long IgnTimerComp,dtpred,dtpred_last,NoiseFilterMin;
// IAC variables
unsigned long motor_time;
int IACmotor_pos,last_iacclt;
char IAC_moving,IACmotor_reset,IdleCtl,motor_step;
// General variables
unsigned int iacpwmctr, TC_ovflow;
unsigned long lmms,t_enable_IC,Rpm_Coeff,ltch_lmms,rcv_timeout,adc_lmms;
unsigned int asecount;
unsigned char flocker,tpsaclk,egocount,igncount,altcount,next_adc,first_adc,
              txmode,tble_idx,burn_idx,synch,
              egopstat,afrSL, FSensStat,knk_clk,knk_clk_test,knk_stat,knk_count,mms, millisec;
int ego1err,ego1errm1,ego2err,ego2errm1,sego1err,sego2err,egoKPX;
unsigned int afrdl1,afrdl2,afrtgt_skip, FSens_Pd,FSensFreq;
unsigned long tegoclk,tegoXpt,tegoupdate;
/* Clocks:
   - igncount: counts up each tach pulse, cleared when hit Divider pulses
   (and injection occurs).
   - asecount: counts up each time igncount = 0 (each Divider pulses).
   - egocount: counts up each tach pulse, cleared when hits EgoCountCmp
   - tpsaclk: counts every .1 sec
   - altcount: flips 0,1,0,1... on each injection, resulting in firing alternate
   injector banks if Alternate option.
 */
unsigned int txcnt,txgoal,rxoffset,rxnbytes,rxcnt,tble_word,ntword;
char AMCmode,bad_ego_flag,bad_ego_ltch,first_clt;
unsigned int AMCclk,AMCve_clk,AMCNSum,AMCburn_clk,AMCram_updates;
int knk_tble_adv,warmup_Tclt,ffspkdel;
long sumegocor1,sumegocor2;
unsigned long WF;
unsigned long AWA, SOA;
unsigned long tooth_diff_last_2, tooth_diff_last_1, tooth_diff_last, tooth_diff_this;
ign_time tooth_diff_rpm, dwl_time_ovflo, spk_time_ovflo, dwl_time_ovflo_trl;
ign_time spk_time_ovflo_trl, spk_trl_sametooth, tooth_diff_rpm_last;
unsigned char wheeldec_ovflo;
unsigned char no_triggers;
unsigned char no_teeth;
unsigned char tooth_no;
unsigned char last_tooth;
unsigned char mid_last_tooth;

int start_clt;
unsigned int tcrank_done,tcold_pos;

// CAN variables
unsigned long cansendclk,ltch_CAN=0xFFFFFFFF;
char *canvar_blkptr[NO_VAR_BLKS];
unsigned int can_status;
unsigned char can_clr_stat,can_reset,can_id,getCANdat=0;
canmsg can[2];

// pointers for spare port pins
volatile unsigned char *pPTMpin[8], *pPTTpin[8], *pPTApin0, *pPTEpin[2];
unsigned char dummyReg,lst_pval[NPORT];

// allocate space in ram for flash burner core
volatile unsigned char RamBurnPgm[36];

//global (static) vars for SCI, RTC ISR
unsigned char CANid,ibuf, next_txmode, rd_wr, flagbyte0, flagbyte1, flagbyte2;
//unsigned char scidiag[258];  //256 + 2 for counter
//
unsigned long stall_timeout;
unsigned char last_fsensdat;
unsigned short FPdcounter;
unsigned int lowres, lowres_ctr, tacho_targ, spk_mult, log_offset;
unsigned char fc_counter, adc_ctr;
unsigned char spk_cutx, spk_cuty, spk_cuti;
unsigned char staged_num_events; /* number of events into staging trasition */
unsigned long pw_staged1, pw_staged2; /* staged pulsewidths */
unsigned char dwl[8], mindwl, nomdwl, maxdwl, testcnt, rtsci, rtcksum;
unsigned int swtimer, deg_per_tooth[MAXNUMTEETH];
unsigned char pwmd1, pwmd2, trig2cnt, bl_timer;
//comment these when not in use
//#define WHEELTIMEDEBUG
#ifdef WHEELTIMEDEBUG
ign_time act_tooth_time[120];
unsigned int act_tooth_ang[120];
#endif

int main(void) {
int ix;
long ltmp;

  // initalize PLL - reset default is Oscillator clock
  // 8 MHz oscillator, PLL freq = 48 MHz, 24 MHz bus,
  //  divide by 16 for timer of 2/3 usec tic
  PLLCTL &= 0xBF;     // Turn off PLL so can change freq
  SYNR = 0x02;        // set PLL/ Bus freq to 48/ 24 MHz
  REFDV = 0x00;
  PLLCTL |= 0x40;     // Turn on PLL
  // wait for PLL lock
  while (!(CRGFLG & 0x08));
  CLKSEL = 0x80;      // select PLL as clock

  // wait for clock transition to finish
  for (ix = 0; ix < 60; ix++);

  // open flash programming capability
  Flash_Init();

  if((int)RamBurnPgm & 0x0001)	{   // odd address - cpy to even one
    (void)memcpy((void *)RamBurnPgm,NoOp,1);         // cpy noop to 1st location
    (void)memcpy((void *)&RamBurnPgm[1],SpSub,32);   // cpy flashburn core pgm to ram
  } else {
    (void)memcpy((void *)RamBurnPgm,SpSub,32);       // cpy flashburn core pgm to ram
  }

  page = 0; // on boot no pages in ram

  conf_err = 0; // no config errors yet
  flagbyte0 = 0; // must do these before ign_reset as it sets various bits
  flagbyte1 = 0;
  flagbyte2 = 0;

  // set up i/o ports
  //    - port M2 is fast idle solenoid
  //    - port M3 is inj led
  //    - port M4 is accel led
  //    - port M5 is warmup led
  //    - port E0 is flex fuel sensor input
  //    - port E4 is fuel pump
  //    - port P5 is bootload pin (input)
  //    - port T6 is IAC Coil A
  //    - port T7 is IAC Coil B
  //    - port B4 is IAC Enable
  //    - port A0 is Knock Enable (if set, means retard timing)
  DDRM |= 0xFC;    // port M - all outputs, full drive by default
  DDRE |= 0x10;	   // port E4 - output, E0 is input
  DDRT |= 0xE0;    // port T5-7 - outputs
  DDRB |= 0x10;    // port B4 - output
  IRQCR &= ~0x40;	// remove External IRQ pins from interrupt logic
  // can be input (flex fuel) or output (misc port)  // check for clashes in a minute
  DDRA &= 0xfe;    // port A0 - input
  //  Set pointers to real port addresses
  for(ix = 0; ix < 8; ix++)  {
    pPTMpin[ix] = pPTM;
    pPTTpin[ix] = pPTT;
  }
  pPTApin0 = pPORTA;
  // reset those pointers to pins which are to be used as alternate outputs
  outpc.port_status = 0;

  // turn off fidle solenoid, leds
  *pPTMpin[2] &= ~0x04;
  *pPTMpin[3] &= ~0x08;
  *pPTMpin[4] &= ~0x10;
  *pPTMpin[5] &= ~0x20;
  PORTE &= ~0x10;            // turn off fuel pump
  *pPTTpin[6] &= ~0xC0;      // turn off IAC coils
  PORTB |= 0x10;   // disable current to motor (set bit= 1)

  *pPTApin0 &= ~0x01;    // no knock signal

  // set all unused (even unbonded) ports to   with pullups
  DDRA &= 0x01;
  DDRB &= 0x10;
  DDRE &= 0x10;
  PUCR |= 0x13;    // enable pullups for ports E, B and A
  DDRP = 0x00;
  PERP = 0xFF;     // enable pullup resistance for port P
  DDRJ &= 0x3F;
  PERJ |= 0xC0;    // enable pullup resistance for port J6,7
  DDRS &= 0xF3;
  PERS |= 0x0C;    // enable pullup resistance for port S2,3

  // set up CRG RTI Interrupt for .128 ms clock. CRG from 8MHz oscillator.
  outpc.seconds = 0;   // (1.0035) secs
//  RTICTL = 0x10;   // load timeout register for .128 ms (smallest possible)
//  CRGINT |= 0x80;  // enable interrupt
//  CRGFLG = 0x80;   // clear interrupt flag (0 writes have no effect)
//  COPCTL = 0x44; // Enable long C.O.P. timeout 2^20 ~0.125s   XXXX disabled

  // Set up SCI (rs232): SCI BR reg= BusFreq(=24MHz)/16/baudrate
  SCI0BDL = (unsigned char)(1500000/115200);
  ltmp = (150000000/115200) - ((long)SCI0BDL*100);
  if(ltmp > 50) {
      SCI0BDL++;   // round up
  }
  SCI0CR1 = 0x00;
  SCI0CR2 = 0x24;   // TIE=0,RIE = 1; TE=0,RE =1
  txcnt = 0;
  rxcnt = 0;
  txmode = 0;
  txgoal = 0;
  rcv_timeout = 0xFFFFFFFF;

  //  Initialize timers:
  TIOS |= 0xFE; // Timer ch 0 = IC, ch 1-5 = OC & PWM,
//  TSCR2 = 0x84;    // setup timer, enable overflow int  <--- need to revisit XXXXXXX
  TCTL2 |= 0x88;   // bit OM1,3,5 = 1. OC output line high or
  TCTL1 |= 0x08;
  TCTL1 = (TCTL1 & 0xFB) | (SPK << 2);  // set OC o/p in OL5
  CFORC |= 0x20;           // force output in OL5 onto OC pin
  TCTL3 &= 0xf3; //TC5 disconnected from IC logic

  OC7M = 0; // don't want to use OC7 feature

  // Set up injector PWMs - PWM2, 4
  MODRR = 0x14;     // Make Port T pins 2,4 be PWM
  PWME = 0;         // disable pwms initially
  PWMPOL = 0x14;    // polarity = 1, => go hi when start
  PWMCLK = 0x14;    // select scaled clocks SB, SA
  PWMPRCLK = 0x00;  // prescale A,B clocks = bus = 24 MHz
  PWMSCLA = 0x0C;   // pwm clk = SA clk/(2*SCLA) = 24MHz/24 = 1 us clk
  PWMSCLB = 0x0C;   // pwm clk = SB clk/(2*SCLB) = 24MHz/24 = 1 us clk
  PWMCAE = 0x00;    // standard left align pulse: -----
//  PWMPER2 = flash4.InjPWMPd;   // set PWM period (us)
//  PWMPER4 = flash4.InjPWMPd;   // set PWM period (us)


  // set up ADC processing
  next_adc = 0;	   	// specifies next adc channel to be read
  ATD0CTL2 = 0x40;  // leave interrupt disabled, set fast flag clear
  ATD0CTL3 = 0x00;  // do 8 conversions/ sequence
  ATD0CTL4 = 0x67;  // 10-bit resoln, 16 tic cnvsn (max accuracy),
                    // prescaler divide by 16 => 2/3 us tic x 18 tics
  ATD0CTL5 = 0xB0;  // right justified,unsigned, continuous cnvsn,
                    // sample 8 channels starting with AN0
  ATD0CTL2 |= 0x80;  // turn on ADC0
  // wait for ADC engine charge-up or P/S ramp-up
  for(ix = 0; ix < 160; ix++)  {
    while(!(ATD0STAT0 >> 7));	 // wait til conversion complete
    ATD0STAT0 = 0x80;
  }
  flocker = 0;

  // make IC highest priority interrupt
  HPRIO = 0xEE;

  // enable global interrupts
  ENABLE_INTERRUPTS

  // Prime Pulse - shoot 1 prime pulse of length PrimeP ms x 10
  start_clt = outpc.clt;


  rtsci = 0;

    mltimestamp = TCNT;
    //  main loop
    for (;;)  {
	outpc.looptime = (outpc.looptime + TCNT - mltimestamp)>>1; // rolling avg
	mltimestamp = TCNT;

        //reset COP timer (That's Computer Operating Properly, not Coil On Plug...)
        ARMCOP = 0x55;
        ARMCOP = 0xAA;

/* in this stripped down code we bomb around this loop until correct serial command is
  sent */

        outpc.rpm = 0;


	realtime();
        //Removed re-init command

        /***************************************************************************
         **
         **  Check for serial receiver timeout
         **
         **************************************************************************/
        if(lmms > rcv_timeout)  {
            txmode = 0;    // break out of current receive sequence
            rcv_timeout = 0xFFFFFFFF;
        }

    }     //  END Main while(1) Loop
}



//*****************************************************************************
//* Function Name: Flash_Init
//* Description : Initialize Flash NVM for HCS12 by programming
//* FCLKDIV based on passed oscillator frequency, then
//* uprotect the array, and finally ensure PVIOL and
//* ACCERR are cleared by writing to them.
//*
//*****************************************************************************
void Flash_Init()  {
  /* Next, initialize FCLKDIV register to ensure we can program/erase */
  FCLKDIV = 39;
//  FPROT = 0xFF; /* Disable all protection (only in special modes)*/
// commented as it will likely spew out error normally
  FSTAT = PVIOL|ACCERR;/* Clear any errors */
  return;
}


void realtime(void) {
   unsigned char t1;
  if (rtsci == 0) {
    goto skip_rt;
  }
  if (rtsci == 1) {
    // copy outpc to txbuf one by one to allow interrupts
    txbuf.seconds = outpc.seconds;
    txbuf.pw1 = outpc.pw1;
    txbuf.pw2 = outpc.pw2;
    txbuf.rpm = outpc.rpm;
    txbuf.adv_deg = outpc.adv_deg;
    txbuf.squirt = outpc.squirt;
    txbuf.engine = outpc.engine;
    txbuf.afrtgt1 = outpc.afrtgt1;
    txbuf.afrtgt2 = outpc.afrtgt2;
    txbuf.wbo2_en1 = outpc.wbo2_en1;
    txbuf.wbo2_en2 = outpc.wbo2_en2;
    txbuf.baro = outpc.baro;
    txbuf.map = outpc.map;
    txbuf.mat = outpc.mat;
    txbuf.clt = outpc.clt;
    txbuf.tps = txbuf.tps;
    txbuf.batt = outpc.batt;
    txbuf.ego1 = outpc.ego1;
    txbuf.ego2 = outpc.ego2;
    txbuf.knock = outpc.knock;
    txbuf.egocor1 = outpc.egocor1;
    txbuf.egocor2 = outpc.egocor2;
    txbuf.aircor = outpc.aircor;
    txbuf.warmcor = outpc.warmcor;
    txbuf.tpsaccel = outpc.tpsaccel;
    txbuf.tpsfuelcut = outpc.tpsfuelcut;
    txbuf.barocor = outpc.barocor;
    txbuf.gammae = outpc.gammae;
    txbuf.vecurr1 = outpc.vecurr1;
    txbuf.vecurr2 = outpc.vecurr2;
    txbuf.iacstep = outpc.iacstep;
    txbuf.cold_adv_deg = outpc.cold_adv_deg;
    txbuf.tpsdot = outpc.tpsdot;
    txbuf.mapdot = outpc.mapdot;
    txbuf.coil_dur = outpc.coil_dur;
    txbuf.maf = outpc.maf;
    txbuf.fuelload = outpc.fuelload;
    txbuf.fuelcor = outpc.fuelcor;
    txbuf.port_status = outpc.port_status;
    txbuf.knk_rtd = outpc.knk_rtd;
    txbuf.EAEfcor = outpc.EAEfcor;
    txbuf.egoV1 = outpc.egoV1;
    txbuf.egoV2 = outpc.egoV2;
    txbuf.status1 = outpc.status1;
    txbuf.status2 = outpc.status2;
    txbuf.status3 = outpc.status3;
    txbuf.status4 = outpc.status4;
    txbuf.looptime = outpc.looptime;
    txbuf.istatus5 = outpc.istatus5;
    txbuf.tpsadc = outpc.tpsadc;
    txbuf.fuelload2 = outpc.fuelload2;
    txbuf.ignload = outpc.ignload;
    txbuf.ignload2 = outpc.ignload2;
    //txbuf. spare[5];
    txbuf.sync_status = outpc.sync_status;
    txbuf.sparechar = outpc.sparechar;
    txbuf.dt3 = outpc.dt3;
    txbuf.wallfuel = outpc.wallfuel;
    txbuf.gpioadc[0] = outpc.gpioadc[0];
    txbuf.gpioadc[1] = outpc.gpioadc[1];
    txbuf.gpioadc[2] = outpc.gpioadc[2];
    txbuf.gpioadc[3] = outpc.gpioadc[3];
    txbuf.gpioadc[4] = outpc.gpioadc[4];
    txbuf.gpioadc[5] = outpc.gpioadc[5];
    txbuf.gpioadc[6] = outpc.gpioadc[6];
    txbuf.gpioadc[7] = outpc.gpioadc[7];

    txbuf.gpiopwmin[0] = outpc.gpiopwmin[0];
    txbuf.gpiopwmin[1] = outpc.gpiopwmin[1];
    txbuf.gpiopwmin[2] = outpc.gpiopwmin[2];
    txbuf.gpiopwmin[3] = outpc.gpiopwmin[3];

    txbuf.gpioport[0] = outpc.gpioport[0];
    txbuf.gpioport[1] = outpc.gpioport[1];
    txbuf.gpioport[2] = outpc.gpioport[2];

    rtcksum = 0;
    rcv_timeout = 0xffffffff;
    SCI0CR2 &= ~0x80;   // xmit interrupt disable
    SCI0CR2 |= 0x08;   // xmit enable
  }
  if (SCI0SR1 & 0x80) { // check if output buffer is ready for more
    // send data block etc.
    __asm__ __volatile__ (
    "clra\n"
    "ldab %1\n"
    "tfr d,x\n"
    "dex\n"
    "ldab %2,x\n"
    "stab %0\n"
    : "=m" (t1)
    : "m" (rtsci), "m" (txbuf) );
    SCI0DRL = t1;
    rtcksum = rtcksum ^ t1;
    rtsci++;
    if (rtsci > SIZEOFTXBUF) {
      rtsci = 0;
      while ((SCI0SR1 & 0x80) == 0) { ; } // wait until byte sent
      SCI0DRL = rtcksum;
    }


  }
skip_rt:
  /* done realtime data portion */
  /* In here want to handle grabbing realtime data from GPIO at defined intervals
     and populating outpc */
  asm("nop");
}
